/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IInitializer;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.Parser;

public class Initializer
extends FieldDeclaration
implements IInitializer {
    public Block block;
    public int lastVisibleFieldID;
    public int bodyStart;
    public int bodyEnd;
    public boolean errorInSignature = false;

    public Initializer(Block block, int modifiers) {
        this.block = block;
        this.modifiers = modifiers;
        this.declarationSourceStart = this.sourceStart = block.sourceStart;
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public void parseStatements(Parser parser, TypeDeclaration typeDeclaration, CompilationUnitDeclaration unit) {
        parser.parse(this, typeDeclaration, unit);
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        if (this.modifiers != 0) {
            Initializer.printIndent(indent, output);
            Initializer.printModifiers(this.modifiers, output);
            output.append("{\n");
            this.block.printBody(indent, output);
            Initializer.printIndent(indent, output).append('}');
            return output;
        }
        return this.block.printStatement(indent, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.block.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 47;
    }
}

