/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.flow;

import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;

public class LabelFlowContext
extends SwitchFlowContext {
    public char[] labelName;

    public LabelFlowContext(FlowContext parent, ASTNode associatedNode, char[] labelName, BlockScope scope) {
        super(parent, associatedNode);
        this.labelName = labelName;
        this.checkLabelValidity(scope);
    }

    void checkLabelValidity(BlockScope scope) {
        FlowContext current = this.parent;
        while (current != null) {
            char[] currentLabelName = current.labelName();
            if (currentLabelName != null && CharOperation.equals(currentLabelName, this.labelName)) {
                scope.problemReporter().alreadyDefinedLabel(this.labelName, this.associatedNode);
            }
            current = current.parent;
        }
    }

    @Override
    public String individualToString() {
        return "Label flow context [label:" + String.valueOf(this.labelName) + "]";
    }

    @Override
    public char[] labelName() {
        return this.labelName;
    }
}

