/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.lookup;

import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.FunctionTypeBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.mod.wst.jsdt.internal.oaametadata.Method;

public class MethodBinding
extends Binding {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding declaringClass;
    char[] signature;
    public long tagBits;
    public FunctionTypeBinding functionTypeBinding;
    public ReferenceBinding allocationType;
    public Method oaaMethod;

    protected MethodBinding() {
    }

    public MethodBinding(int modifiers, char[] selector, TypeBinding returnType, TypeBinding[] parameters, ReferenceBinding declaringClass) {
        this.modifiers = modifiers;
        this.selector = selector;
        this.returnType = returnType;
        this.parameters = parameters == null || parameters.length == 0 ? Binding.NO_PARAMETERS : parameters;
        this.declaringClass = declaringClass;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int modifiers, TypeBinding[] parameters, ReferenceBinding declaringClass) {
        this(modifiers, TypeConstants.INIT, TypeBinding.UNKNOWN, parameters, declaringClass);
    }

    public MethodBinding(MethodBinding initialMethodBinding, ReferenceBinding declaringClass) {
        this.modifiers = initialMethodBinding.modifiers;
        this.selector = initialMethodBinding.selector;
        this.returnType = initialMethodBinding.returnType;
        this.parameters = initialMethodBinding.parameters;
        this.declaringClass = declaringClass;
    }

    public final boolean areParametersEqual(MethodBinding method) {
        TypeBinding[] args = method.parameters;
        if (this.parameters == args) {
            return true;
        }
        int length = this.parameters.length;
        if (length != args.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.parameters[i] != args[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final int kind() {
        return 8;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.declaringClass.getPackage();
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        char[] declaringKey = this.declaringClass.computeUniqueKey(false);
        int declaringLength = declaringKey.length;
        int selectorLength = this.selector == TypeConstants.INIT || this.selector == null ? 0 : this.selector.length;
        char[] sig = this.signature();
        int signatureLength = sig.length;
        char[] uniqueKey = new char[declaringLength + 1 + selectorLength + signatureLength];
        int index = 0;
        System.arraycopy(declaringKey, 0, uniqueKey, index, declaringLength);
        index = declaringLength;
        uniqueKey[index++] = 46;
        if (this.selector != null) {
            System.arraycopy(this.selector, 0, uniqueKey, index, selectorLength);
        }
        System.arraycopy(sig, 0, uniqueKey, index += selectorLength, signatureLength);
        return uniqueKey;
    }

    public TypeBinding constantPoolDeclaringClass() {
        return this.declaringClass;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public Object getDefaultValue() {
        MethodBinding originalMethod = this.original();
        if ((originalMethod.tagBits & 0x8000000000000L) == 0L) {
            originalMethod.tagBits |= 0x8000000000000L;
        }
        return null;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT || (this.tagBits & 0x20000000000000L) != 0L;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public MethodBinding original() {
        return this;
    }

    @Override
    public char[] readableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.sourceName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].sourceName());
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString().toCharArray();
    }

    public void setDefaultValue(Object defaultValue) {
        MethodBinding originalMethod = this.original();
        originalMethod.tagBits |= 0x8000000000000L;
    }

    @Override
    public char[] shortReadableName() {
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            buffer.append(this.declaringClass.shortReadableName());
        } else {
            buffer.append(this.selector);
        }
        buffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int i = 0;
            int length = this.parameters.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i].shortReadableName());
                ++i;
            }
        }
        buffer.append(')');
        int nameLength = buffer.length();
        char[] shortReadableName = new char[nameLength];
        buffer.getChars(0, nameLength, shortReadableName, 0);
        return shortReadableName;
    }

    protected final void setSelector(char[] selector) {
        this.selector = selector;
        this.signature = null;
    }

    public final char[] signature() {
        int i;
        boolean needSynthetics;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer buffer = new StringBuffer(this.parameters.length + 20);
        buffer.append('(');
        TypeBinding[] targetParameters = this.parameters;
        boolean isConstructor = this.isConstructor();
        boolean bl = needSynthetics = isConstructor && this.declaringClass.isNestedType();
        if (targetParameters != Binding.NO_PARAMETERS) {
            i = 0;
            while (i < targetParameters.length) {
                buffer.append(targetParameters[i].signature());
                ++i;
            }
        }
        if (needSynthetics) {
            i = targetParameters.length;
            int extraLength = this.parameters.length;
            while (i < extraLength) {
                buffer.append(this.parameters[i].signature());
                ++i;
            }
        }
        buffer.append(')');
        if (this.returnType != null) {
            buffer.append(this.returnType.signature());
        }
        int nameLength = buffer.length();
        this.signature = new char[nameLength];
        buffer.getChars(0, nameLength, this.signature, 0);
        return this.signature;
    }

    public String toString() {
        String s = this.returnType != null ? this.returnType.debugName() : "NULL TYPE";
        s = String.valueOf(s) + " ";
        s = String.valueOf(s) + (this.selector != null ? new String(this.selector) : "UNNAMED METHOD");
        s = String.valueOf(s) + "(";
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                int i = 0;
                int length = this.parameters.length;
                while (i < length) {
                    if (i > 0) {
                        s = String.valueOf(s) + ", ";
                    }
                    s = String.valueOf(s) + (this.parameters[i] != null ? this.parameters[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            s = String.valueOf(s) + "NULL PARAMETERS";
        }
        s = String.valueOf(s) + ") ";
        return s;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public MethodBinding createNamedMethodBinding(char[] name) {
        MethodBinding newBinding = new MethodBinding(this.modifiers, name, this.returnType, this.parameters, this.declaringClass);
        newBinding.functionTypeBinding = this.functionTypeBinding;
        newBinding.tagBits = this.tagBits;
        newBinding.signature = this.signature;
        return newBinding;
    }

    public void updateFrom(MethodBinding functionBinding) {
        this.returnType = functionBinding.returnType;
        this.parameters = functionBinding.parameters;
    }

    public void cleanup() {
        if (this.functionTypeBinding != null) {
            this.functionTypeBinding.cleanup();
        }
    }
}

