/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.parser;

import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredMethod;

public class RecoveredStatement
extends RecoveredElement {
    public Statement statement;
    public RecoveredElement[] childStatements;
    public int childCount;

    public RecoveredStatement(Statement statement, RecoveredElement parent, int bracketBalance) {
        super(parent, bracketBalance);
        this.statement = statement;
    }

    @Override
    public ASTNode parseTree() {
        return this.statement;
    }

    @Override
    public int sourceEnd() {
        return this.statement.sourceEnd;
    }

    @Override
    public String toString(int tab) {
        return String.valueOf(this.tabString(tab)) + "Recovered statement:\n" + this.statement.print(tab + 1, new StringBuffer(10));
    }

    public Statement updatedStatement() {
        int i = 0;
        while (i < this.childCount) {
            this.childStatements[i].updatedASTNode();
            ++i;
        }
        return this.statement;
    }

    @Override
    public void updateParseTree() {
        this.updatedStatement();
    }

    @Override
    public void updateSourceEndIfNecessary(int bodyStart, int bodyEnd) {
        if (this.statement.sourceEnd == 0) {
            this.statement.sourceEnd = bodyEnd;
        }
    }

    @Override
    public ProgramElement updatedASTNode() {
        return this.updatedStatement();
    }

    @Override
    public RecoveredElement add(AbstractMethodDeclaration methodDeclaration, int bracketBalanceValue) {
        RecoveredMethod element = new RecoveredMethod(methodDeclaration, this, bracketBalanceValue, this.recoveringParser);
        this.addChild(element);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (methodDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    private void addChild(RecoveredElement statement) {
        if (this.childStatements == null) {
            this.childStatements = new RecoveredElement[5];
            this.childCount = 0;
        } else if (this.childCount == this.childStatements.length) {
            this.childStatements = new RecoveredElement[2 * this.childCount];
            System.arraycopy(this.childStatements, 0, this.childStatements, 0, this.childCount);
        }
        this.childStatements[this.childCount++] = statement;
    }
}

