/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.eclipse.vjet.dsf.js.dbgp.ISourceProvider;

public class SourceListCommand
extends DBGPDebugger.Command {
    private DBGPDebugger m_debugger;
    private ISourceProvider[] m_sourcePoviders;

    public SourceListCommand(DBGPDebugger debugger, ISourceProvider[] sourceProviders) {
        this.m_debugger = debugger;
        this.m_sourcePoviders = new ISourceProvider[sourceProviders.length];
        System.arraycopy(sourceProviders, 0, this.m_sourcePoviders, 0, sourceProviders.length);
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        HashSet<String> fileSet = new HashSet<String>();
        ISourceProvider[] iSourceProviderArray = this.m_sourcePoviders;
        int n = this.m_sourcePoviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider provider = iSourceProviderArray[n2];
            String[] paths = provider.list();
            int i = 0;
            while (i < paths.length) {
                fileSet.add(paths[i]);
                ++i;
            }
            ++n2;
        }
        String[] files = fileSet.toArray(new String[0]);
        StringBuilder builder = new StringBuilder();
        builder.append("<response command=\"source_list\"\r\n          transaction_id=\"").append(options.get("-i")).append("\"\r\n          success=\"").append(1).append("\">\r\n").append(this.createFilePathNodesAsString(files)).append("\r\n</response>\r\n");
        this.m_debugger.printResponse(builder.toString());
    }

    private String createFilePathNodesAsString(String[] files) {
        StringBuilder b = new StringBuilder();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            b.append("<file name=\"" + f + "\" />\r\n");
            ++n2;
        }
        return b.toString();
    }
}

