/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdi;

import org.eclipse.vjet.dsf.jsdi.FunctionSource;
import org.eclipse.vjet.dsf.jsdi.ISourceInfo;
import org.mozilla.mod.javascript.debug.DebuggableScript;

public class SourceInfo
implements ISourceInfo {
    private static final long serialVersionUID = -8051720475243424001L;
    private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    private String m_text;
    private String m_uri;
    private boolean[] m_breakableLines;
    private boolean[] m_breakpoints;
    private FunctionSource[] m_functionSources;

    public SourceInfo(String text, DebuggableScript[] functions, String normilizedUri, int[] breakPoints) {
        this.m_text = text;
        this.m_uri = normilizedUri;
        int N = functions.length;
        int[][] lineArrays = new int[N][];
        int i = 0;
        while (i != N) {
            lineArrays[i] = functions[i].getLineNumbers();
            ++i;
        }
        int minAll = 0;
        int maxAll = -1;
        int[] firstLines = new int[N];
        int i2 = 0;
        while (i2 != N) {
            int[] lines = lineArrays[i2];
            if (lines == null || lines.length == 0) {
                firstLines[i2] = -1;
            } else {
                int max;
                int min = max = lines[0];
                int j = 1;
                while (j != lines.length) {
                    int line = lines[j];
                    if (line < min) {
                        min = line;
                    } else if (line > max) {
                        max = line;
                    }
                    ++j;
                }
                firstLines[i2] = min;
                if (minAll > maxAll) {
                    minAll = min;
                    maxAll = max;
                } else {
                    if (min < minAll) {
                        minAll = min;
                    }
                    if (max > maxAll) {
                        maxAll = max;
                    }
                }
            }
            ++i2;
        }
        if (minAll > maxAll) {
            this.m_breakableLines = EMPTY_BOOLEAN_ARRAY;
            this.m_breakpoints = EMPTY_BOOLEAN_ARRAY;
        } else {
            if (minAll < 0) {
                throw new IllegalStateException(String.valueOf(minAll));
            }
            int linesTop = maxAll + 1;
            this.m_breakableLines = new boolean[linesTop];
            this.m_breakpoints = new boolean[linesTop];
            int i3 = 0;
            while (i3 != N) {
                int[] lines = lineArrays[i3];
                if (lines != null && lines.length != 0) {
                    int j = 0;
                    while (j != lines.length) {
                        int line = lines[j];
                        this.m_breakableLines[line] = true;
                        ++j;
                    }
                }
                ++i3;
            }
        }
        if (breakPoints != null) {
            int[] nArray = breakPoints;
            int n = breakPoints.length;
            int i3 = 0;
            while (i3 < n) {
                int line = nArray[i3];
                if (line < this.m_breakpoints.length && this.isBreakableLine(line)) {
                    this.m_breakpoints[line] = true;
                }
                ++i3;
            }
        }
        this.m_functionSources = new FunctionSource[N];
        i2 = 0;
        while (i2 != N) {
            String name = functions[i2].getFunctionName();
            if (name == null) {
                name = "";
            }
            this.m_functionSources[i2] = new FunctionSource(this, firstLines[i2], name);
            ++i2;
        }
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public String getUri() {
        return this.m_uri;
    }

    public int getFunctionSourceCount() {
        return this.m_functionSources.length;
    }

    public FunctionSource getFunctionSource(int i) {
        return this.m_functionSources[i];
    }

    public void copyBreakpointsFrom(SourceInfo old) {
        int end = old.m_breakpoints.length;
        if (end > this.m_breakpoints.length) {
            end = this.m_breakpoints.length;
        }
        int line = 0;
        while (line != end) {
            if (old.m_breakpoints[line]) {
                this.m_breakpoints[line] = true;
            }
            ++line;
        }
    }

    @Override
    public boolean isBreakableLine(int line) {
        return line < this.m_breakableLines.length && this.m_breakableLines[line];
    }

    @Override
    public boolean isBreakpoint(int line) {
        if (!this.isBreakableLine(line)) {
            throw new IllegalArgumentException(String.valueOf(line));
        }
        return line < this.m_breakpoints.length && this.m_breakpoints[line];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBreakpoint(int line, boolean value) {
        if (!this.isBreakableLine(line)) {
            throw new IllegalArgumentException(String.valueOf(line));
        }
        boolean[] blArray = this.m_breakpoints;
        synchronized (this.m_breakpoints) {
            boolean changed;
            if (this.m_breakpoints[line] != value) {
                this.m_breakpoints[line] = value;
                changed = true;
            } else {
                changed = false;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBreakpoints() {
        boolean[] blArray = this.m_breakpoints;
        synchronized (this.m_breakpoints) {
            int line = 0;
            while (line != this.m_breakpoints.length) {
                this.m_breakpoints[line] = false;
                ++line;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean[] getBreakpoints() {
        return this.m_breakpoints;
    }
}

