/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsref;

import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.vsf.jsref.JsObj;
import org.eclipse.vjet.vsf.jsref.internals.JsTypeConvertor;
import org.eclipse.vjet.vsf.jsref.util.SetJsProp;
import org.eclipse.vjet.vsf.jsruntime.jsref.IJsPropSetter;

public class JsPropSetter
implements IJsPropSetter {
    private final JsObj m_obj;
    private final String m_name;
    private final IValueBinding<?> m_value;

    public JsPropSetter(JsObj obj, String name, IValueBinding<?> value) {
        this.m_obj = obj;
        this.m_name = name;
        this.m_value = value;
    }

    public JsObj getObj() {
        return this.m_obj;
    }

    public String getName() {
        return this.m_name;
    }

    public IValueBinding<?> getValue() {
        return this.m_value;
    }

    public String generate() {
        StringBuilder sb = new StringBuilder();
        if (this.m_obj.isInstance()) {
            sb.append(this.m_obj.getRefJs());
        } else {
            sb.append(this.m_obj.getCmpMeta().getCmpName());
        }
        sb.append(".").append(this.m_name).append("=").append(this.toJsValue()).append(";");
        return sb.toString();
    }

    private String toJsValue() {
        return JsTypeConvertor.toJsArg(this.m_value);
    }

    public void onClient() {
        SetJsProp.now(this.getObj(), (IJsPropSetter)this);
    }
}

