/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.checksum;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;

public class Checksum {
    private static final char[] alphabet = new char[32];
    private static final byte[] reverseMap = new byte[128];

    static {
        Arrays.fill(reverseMap, (byte)-1);
        int i = 97;
        while (i <= 122) {
            Checksum.alphabet[i - 97] = (char)i;
            Checksum.reverseMap[i] = (byte)(i - 97);
            ++i;
        }
        i = 0;
        while (i < 6) {
            Checksum.alphabet[26 + i] = (char)(i + 48);
            Checksum.reverseMap[i + 48] = (byte)(26 + i);
            ++i;
        }
    }

    public static String checksum(byte[] data) {
        UUID uuid = UUID.nameUUIDFromBytes(data);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        String encoded = Checksum.encode(buffer.array());
        return String.valueOf(encoded) + Checksum.hash(encoded);
    }

    private static char hash(String enc) {
        int index = enc.hashCode() % 32;
        if (index < 0) {
            return alphabet[-index];
        }
        return alphabet[index];
    }

    public static String checksum(String in) {
        try {
            return Checksum.checksum(in.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String encode(byte[] data) {
        int index = 0;
        int digit = 0;
        StringBuilder base32 = new StringBuilder(data.length * 8 / 5 + 1);
        int i = 0;
        int count = data.length;
        while (i < count) {
            int currByte;
            int n = currByte = data[i] >= 0 ? data[i] : data[i] + 256;
            if (index > 3) {
                int nextByte = i + 1 < data.length ? (data[i + 1] >= 0 ? data[i + 1] : data[i + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append(alphabet[digit]);
        }
        return base32.toString();
    }

    private static byte[] decode(String base32) {
        if (base32 == null) {
            return null;
        }
        byte[] bytes = new byte[base32.length() * 5 / 8];
        int i = 0;
        int index = 0;
        int offset = 0;
        while (i < base32.length()) {
            byte digit = reverseMap[base32.charAt(i)];
            if (digit != 255) {
                if (index <= 3) {
                    if ((index = (index + 5) % 8) == 0) {
                        int n = offset++;
                        bytes[n] = (byte)(bytes[n] | digit);
                        if (offset >= bytes.length) {
                            break;
                        }
                    } else {
                        int n = offset;
                        bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                    }
                } else {
                    index = (index + 5) % 8;
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | digit >>> index);
                    if (offset >= bytes.length) break;
                    int n2 = offset;
                    bytes[n2] = (byte)(bytes[n2] | digit << 8 - index);
                }
            }
            ++i;
        }
        return bytes;
    }

    public static boolean validateChecksum(String encoded) {
        if (encoded == null) {
            return false;
        }
        if (encoded.length() != 27) {
            return false;
        }
        int i = 0;
        while (i < encoded.length()) {
            char c = encoded.charAt(i);
            if (c < '0' || c > 'z') {
                return false;
            }
            if (reverseMap[c] == 255) {
                return false;
            }
            ++i;
        }
        char lastChar = encoded.charAt(26);
        String checksum = encoded.substring(0, 26);
        byte[] b = Checksum.decode(checksum);
        if (b.length != 16) {
            return false;
        }
        ByteBuffer bf = ByteBuffer.allocate(16);
        bf.put(b);
        bf.rewind();
        UUID uuid = new UUID(bf.getLong(), bf.getLong());
        if (uuid.variant() != 2 || uuid.version() != 3) {
            return false;
        }
        return lastChar == Checksum.hash(checksum);
    }

    public static String md5checksum(byte[] bin) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(bin);
            byte[] md5 = digest.digest();
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < md5.length) {
                builder.append(Integer.toHexString(0xFF & md5[i]));
                ++i;
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

