/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.serializer.BeanSerializer;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.dsf.serializer.AVjoSerializable;
import org.eclipse.vjet.dsf.serializer.VjoPrimitiveSerializer;
import org.eclipse.vjet.dsf.serializers.ISerializableForVjo;

public class VjoBeanSerializer
extends VjoPrimitiveSerializer {
    private static Logger s_logger = Logger.getInstance(VjoBeanSerializer.class);

    @Override
    public boolean canSerialize(Object obj) {
        Class<?> type = obj.getClass();
        if (this.isPrimitive(type)) {
            return false;
        }
        if (type.isEnum()) {
            return false;
        }
        if (type.isArray()) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            return false;
        }
        if (List.class.isAssignableFrom(type)) {
            return false;
        }
        if (Set.class.isAssignableFrom(type)) {
            return false;
        }
        if (type.getAnnotation(AVjoSerializable.class) != null) {
            return false;
        }
        return !ISerializableForVjo.class.isAssignableFrom(type);
    }

    @Override
    public Object doSerialize(Object obj) throws SerializationException {
        JsonObject sb = new JsonObject();
        try {
            this.objectStateTransfer(obj, sb);
        }
        catch (IntrospectionException e) {
            s_logger.log((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            s_logger.log((Throwable)e);
        }
        catch (IllegalAccessException e) {
            s_logger.log((Throwable)e);
        }
        catch (InvocationTargetException e) {
            s_logger.log((Throwable)e);
        }
        return sb;
    }

    public void objectStateTransfer(Object obj, JsonObject sb) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SerializationException {
        Class<?> type = obj.getClass();
        BeanSerializer.BeanData bd = BeanSerializer.getBeanData(type);
        for (Map.Entry entry : bd.m_readableProps.entrySet()) {
            Method meth = (Method)entry.getValue();
            Object value = meth.invoke(obj, new Object[0]);
            sb.put((String)entry.getKey(), this.getOwner().serialize(value));
        }
    }

    @Override
    protected Object toCache(Object toSerialize, Object result) {
        return result;
    }

    @Override
    protected boolean canCache(Object toSerialize) {
        return true;
    }
}

