/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.utils.jstrace;

import java.util.HashMap;
import org.eclipse.vjet.vsf.jsref.JsObj;
import org.eclipse.vjet.vsf.jsruntime.compregistry.JsComponentRegistry;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.utils.jstrace.TraceJsr;

public class VJOTracer {
    private static final String PARAM_TYPE = "trace_type";
    private static final String PARAM_EXPR = "trace_expr";
    private static final String PARAM_WL = "trace_wl";
    private static final String PARAM_BL = "trace_bl";
    private static final String PARAM_FORMAT = "trace_format";
    private static final String PARAM_LIFESPAN = "trace_lifespan";
    private static final String PARAM_URI = "trace_uri";
    private static final String PARAM_GUID = "trace_guid";
    private static final String PARAM_MSGBEF = "trace_msg_bef";
    private static final String PARAM_MSGAFT = "trace_msg_aft";
    private static final String TRACE_TYPE = "type";
    private static final String TRACE_WHITE_LIST = "wl";
    private static final String TRACE_BLACK_LIST = "bl";
    private static final String TRACE_URI = "uri";
    private static final String TRACE_LIFESPAN = "life";
    private static final String TRACE_GUID = "guid";
    private static final String TRACE_FORMATTER = "fmt";
    private static final String TRACE_MSG_BEF = "beforeMsgId";
    private static final String TRACE_MSG_AFT = "afterMsgId";
    private static final String TRACE_JSR = "trace_jsr";
    private static final String TRACE_TYPE_LOCAL = "local";
    private static final String TRACE_TYPE_REMOTE = "remote";
    private static final String TRACE_TYPE_MSG = "msg";
    private static final String TRACE_TYPE_ECLIPSE = "eclipse";

    public void traceJS(IParamGetter paramGetter) {
        HashMap<String, String> cfg = new HashMap<String, String>();
        String whiteList = this.getParam(paramGetter, PARAM_WL, "");
        cfg.put(TRACE_WHITE_LIST, whiteList);
        String blackList = this.getParam(paramGetter, PARAM_BL, "");
        cfg.put(TRACE_BLACK_LIST, blackList);
        String type = this.getParam(paramGetter, PARAM_TYPE, TRACE_TYPE_LOCAL);
        cfg.put(TRACE_TYPE, type);
        String expr = this.getParam(paramGetter, PARAM_EXPR, "");
        JsComponentRegistry reg = JsRuntimeCtx.ctx().getCompRegistry();
        boolean fmtInReg = false;
        if (TRACE_TYPE_LOCAL.equals(type)) {
            String fmt = this.getParam(paramGetter, PARAM_FORMAT, null);
            if (fmt != null && !"vjo.dsf.utils.jstrace.PlainFormatter".equals(fmt)) {
                String jsr = fmt;
                if (!jsr.endsWith("Jsr")) {
                    jsr = String.valueOf(jsr) + "Jsr";
                }
                JsObj jObj = null;
                try {
                    jObj = (JsObj)Class.forName(jsr).newInstance();
                    reg.moveOrder(jObj.getInstanceId(), 0);
                    cfg.put(TRACE_FORMATTER, fmt);
                    fmtInReg = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {}
            }
        } else if (TRACE_TYPE_REMOTE.equals(type)) {
            String guid = this.getParam(paramGetter, PARAM_GUID, "GUID");
            cfg.put(TRACE_GUID, guid);
            String lifeSpan = this.getParam(paramGetter, PARAM_LIFESPAN, "");
            cfg.put(TRACE_LIFESPAN, lifeSpan);
            String uri = this.getParam(paramGetter, PARAM_URI, "");
            cfg.put(TRACE_URI, uri);
        } else if (TRACE_TYPE_MSG.equals(type)) {
            String bef = this.getParam(paramGetter, PARAM_MSGBEF, "");
            String aft = this.getParam(paramGetter, PARAM_MSGAFT, "");
            cfg.put(TRACE_MSG_BEF, bef);
            cfg.put(TRACE_MSG_AFT, aft);
        } else if (TRACE_TYPE_ECLIPSE.equals(type)) {
            String uri = this.getParam(paramGetter, PARAM_URI, "");
            cfg.put(TRACE_URI, uri);
        }
        int pos = fmtInReg ? 1 : 0;
        cfg.put(TRACE_JSR, Integer.toString(pos));
        TraceJsr tJsr = new TraceJsr(expr, cfg);
        reg.moveOrder(tJsr.getInstanceId(), pos);
    }

    protected String getParam(IParamGetter paramGetter, String param, String defaultValue) {
        String value = paramGetter.getParam(param);
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public static interface IParamGetter {
        public String getParam(String var1);
    }
}

