/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.console.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.dltk.mod.console.IScriptExecResult;
import org.eclipse.dltk.mod.console.IScriptInterpreter;
import org.eclipse.dltk.mod.console.ScriptConsoleHistory;
import org.eclipse.dltk.mod.console.ScriptConsolePrompt;
import org.eclipse.dltk.mod.console.ScriptExecResult;
import org.eclipse.dltk.mod.console.ui.IScriptConsoleInput;
import org.eclipse.dltk.mod.console.ui.IScriptConsoleListener;
import org.eclipse.dltk.mod.console.ui.IScriptConsoleSession;
import org.eclipse.dltk.mod.console.ui.Messages;
import org.eclipse.dltk.mod.console.ui.ScriptConsolePartitioner;
import org.eclipse.dltk.mod.console.ui.ScriptConsoleSourceViewerConfiguration;
import org.eclipse.dltk.mod.console.ui.internal.ICommandHandler;
import org.eclipse.dltk.mod.console.ui.internal.ScriptConsoleInput;
import org.eclipse.dltk.mod.console.ui.internal.ScriptConsolePage;
import org.eclipse.dltk.mod.console.ui.internal.ScriptConsoleSession;
import org.eclipse.dltk.mod.console.ui.internal.ScriptConsoleViewer;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class ScriptConsole
extends TextConsole
implements ICommandHandler {
    private ILaunch launch = null;
    private ILaunchesListener2 listener = null;
    private ScriptConsolePage page;
    private ScriptConsolePartitioner partitioner;
    private IContentAssistProcessor processor;
    private ITextHover hover;
    private IScriptInterpreter interpreter;
    private ScriptConsoleSession session;
    private ListenerList consoleListeners = new ListenerList(1);
    private ScriptConsolePrompt prompt = new ScriptConsolePrompt("=>", "->");
    private ScriptConsoleHistory history = new ScriptConsoleHistory();
    private boolean terminated = false;
    private ScriptConsoleViewer.ConsoleDocumentListener documentListener;

    protected void appendInvitation(final ScriptConsoleViewer viewer) {
        Control control = viewer.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        viewer.disableProcessing();
                        ScriptConsole.this.getDocumentListener().appendDelimeter();
                        ScriptConsole.this.getDocumentListener().appendInvitation();
                        viewer.enableProcessing();
                    }
                    catch (BadLocationException e) {
                        if (!DLTKCore.DEBUG) break block2;
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    protected void enableEdit(final ScriptConsoleViewer viewer) {
        Control control = viewer.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                viewer.setEditable(true);
            }
        });
    }

    private void updateText(final ScriptConsoleViewer viewer, final String text, final boolean clean) {
        Control control = viewer.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                block5: {
                    viewer.disableProcessing();
                    IDocument document = ScriptConsole.this.getDocument();
                    try {
                        if (clean) {
                            document.replace(0, document.getLength(), text);
                            ScriptConsole.this.getDocumentListener().appendDelimeter();
                        } else {
                            document.replace(document.getLength(), 0, text);
                            ScriptConsole.this.getDocumentListener().appendDelimeter();
                        }
                        IDocumentPartitioner partitioner = viewer.getDocument().getDocumentPartitioner();
                        if (partitioner instanceof ScriptConsolePartitioner) {
                            ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
                            scriptConsolePartitioner.clearRanges();
                            viewer.getTextWidget().redraw();
                        }
                    }
                    catch (BadLocationException e) {
                        if (!DLTKCore.DEBUG) break block5;
                        e.printStackTrace();
                    }
                }
                viewer.enableProcessing();
            }
        });
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public ScriptConsolePage getPage() {
        return this.page;
    }

    public ScriptConsole(String consoleName, String consoleType, ImageDescriptor image) {
        super(consoleName, consoleType, image, true);
        this.session = new ScriptConsoleSession();
        this.addListener(this.session);
        this.partitioner = new ScriptConsolePartitioner();
        this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this.partitioner);
        this.partitioner.connect(this.getDocument());
    }

    public ScriptConsole(String consoleName, String consoleType) {
        this(consoleName, consoleType, null);
    }

    public IScriptConsoleSession getSession() {
        return this.session;
    }

    public void addListener(IScriptConsoleListener listener) {
        this.consoleListeners.add((Object)listener);
    }

    public void removeListener(IScriptConsoleListener listener) {
        this.consoleListeners.remove((Object)listener);
    }

    protected void setContentAssistProcessor(IContentAssistProcessor processor) {
        this.processor = processor;
    }

    protected void setInterpreter(IScriptInterpreter interpreter) {
        this.interpreter = interpreter;
        interpreter.addInitialListenerOperation((Runnable)new InitialStreamReader(interpreter));
    }

    public void setPrompt(ScriptConsolePrompt prompt) {
        this.prompt = prompt;
    }

    public ScriptConsolePrompt getPrompt() {
        return this.prompt;
    }

    public ScriptConsoleHistory getHistory() {
        return this.history;
    }

    protected void setTextHover(ITextHover hover) {
        this.hover = hover;
    }

    public ScriptConsoleViewer.ConsoleDocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new ScriptConsoleViewer.ConsoleDocumentListener(this, this.getPrompt(), this.getHistory());
            this.documentListener.setDocument(this.getDocument());
        }
        return this.documentListener;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        ScriptConsoleSourceViewerConfiguration cfg = new ScriptConsoleSourceViewerConfiguration(this.processor, this.hover);
        this.page = this.createPage(view, cfg);
        return this.page;
    }

    protected ScriptConsolePage createPage(IConsoleView view, SourceViewerConfiguration cfg) {
        return new ScriptConsolePage(this, view, cfg);
    }

    public void clearConsole() {
        this.page.clearConsolePage();
    }

    public IScriptConsoleInput getInput() {
        return new ScriptConsoleInput(this.page);
    }

    public int getState() {
        return this.interpreter.getState();
    }

    @Override
    public IScriptExecResult handleCommand(String userInput) throws IOException {
        if (this.interpreter == null && this.interpreter.isValid()) {
            return new ScriptExecResult("");
        }
        Object[] listeners = this.consoleListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IScriptConsoleListener)listeners[i]).userRequest(userInput);
            ++i;
        }
        IScriptExecResult output = this.interpreter.exec(userInput);
        if (this.interpreter.getState() == 0) {
            this.prompt.setMode(true);
        } else {
            this.prompt.setMode(false);
        }
        int i2 = 0;
        while (i2 < listeners.length) {
            ((IScriptConsoleListener)listeners[i2]).interpreterResponse(output);
            ++i2;
        }
        return output;
    }

    public void terminate() {
        block2: {
            this.terminated = true;
            try {
                this.interpreter.close();
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void dispose() {
        this.partitioner.clearRanges();
        this.terminate();
        if (this.listener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.listener);
        }
        super.dispose();
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
        if (this.listener == null) {
            this.listener = new ScriptConsoleLaunchListener();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.listener);
        }
    }

    private final class InitialStreamReader
    implements Runnable {
        private final IScriptInterpreter interpreter;

        private InitialStreamReader(IScriptInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        @Override
        public void run() {
            while (ScriptConsole.this.page == null || ScriptConsole.this.page != null && ScriptConsole.this.page.getViewer() == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    if (!DLTKCore.DEBUG) continue;
                    e.printStackTrace();
                }
            }
            final ScriptConsoleViewer viewer = (ScriptConsoleViewer)ScriptConsole.this.page.getViewer();
            InputStream stream = this.interpreter.getInitialOutputStream();
            if (stream == null) {
                return;
            }
            final BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            Thread readerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean first = true;
                    while (!ScriptConsole.this.terminated) {
                        try {
                            String readLine = reader.readLine();
                            if (readLine == null) break;
                            ScriptConsole.this.updateText(viewer, readLine, first);
                            first = false;
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break;
                            e.printStackTrace();
                            break;
                        }
                    }
                    if (!first) {
                        ScriptConsole.this.appendInvitation(viewer);
                    }
                    ScriptConsole.this.enableEdit(viewer);
                }
            });
            readerThread.start();
        }
    }

    private class ScriptConsoleLaunchListener
    implements ILaunchesListener2 {
        private ScriptConsoleLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] launches) {
            if (ScriptConsole.this.terminated) {
                return;
            }
            int i = 0;
            while (i < launches.length) {
                if (launches[i].equals(ScriptConsole.this.launch)) {
                    final ScriptConsoleViewer consoleViewer = (ScriptConsoleViewer)ScriptConsole.this.page.getViewer();
                    ScriptConsole.this.page.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (consoleViewer != null) {
                                consoleViewer.disableProcessing();
                                ScriptConsole.this.appendInvitation(consoleViewer);
                                ScriptConsole.this.updateText(consoleViewer, Messages.ScriptConsole_processTerminated, false);
                                consoleViewer.setEditable(false);
                            }
                        }
                    });
                }
                ++i;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }
}

