/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.launching;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IInterpreterRunner;
import org.eclipse.dltk.mod.launching.InterpreterConfig;
import org.eclipse.dltk.mod.launching.LaunchingMessages;
import org.eclipse.dltk.mod.launching.debug.DebuggingEngineManager;
import org.eclipse.dltk.mod.launching.debug.IDebuggingEngine;

public class DebugRunnerDelegate
implements IInterpreterRunner {
    private IInterpreterInstall install;

    public DebugRunnerDelegate(IInterpreterInstall install) {
        this.install = install;
    }

    @Override
    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        IScriptProject scriptProject = AbstractScriptLaunchConfigurationDelegate.getScriptProject(launchConfiguration);
        DebuggingEngineManager manager = DebuggingEngineManager.getInstance();
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)scriptProject);
        IDebuggingEngine engine = manager.getSelectedDebuggingEngine(scriptProject.getProject(), toolkit.getNatureId());
        if (engine != null) {
            IInterpreterRunner runner = engine.getRunner(this.install);
            if (runner != null) {
                runner.run(config, launch, monitor);
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.mod.launching", 107, MessageFormat.format((String)LaunchingMessages.InterpreterRunnerDoesntExist, (Object[])new String[]{this.install.getName(), "debug"}), null));
            }
        }
    }
}

