/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.ScriptModelUtil;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.corext.util.Resources;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;

    private Checks() {
    }

    public static boolean isAvailable(IModelElement modelElement) throws ModelException {
        if (modelElement == null) {
            return false;
        }
        if (!modelElement.exists()) {
            return false;
        }
        if (modelElement.isReadOnly()) {
            return false;
        }
        if (!(modelElement instanceof IScriptProject) && !modelElement.isStructureKnown()) {
            return false;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add binary modules support.");
        }
        return true;
    }

    public static boolean isBuildpathDelete(IProjectFragment pkgRoot) {
        IResource res = pkgRoot.getResource();
        if (res == null) {
            return true;
        }
        IProject definingProject = res.getProject();
        if (res.getParent() != null && pkgRoot.isArchive() && !res.getParent().equals((Object)definingProject)) {
            return true;
        }
        IProject occurringProject = pkgRoot.getScriptProject().getProject();
        return !definingProject.equals((Object)occurringProject);
    }

    public static RefactoringStatus checkSourceModuleNewName(ISourceModule cu, String newName) {
        String newCUName = ScriptModelUtil.getRenamedCUName((ISourceModule)cu, (String)newName);
        if (Checks.resourceExists(RenameResourceChange.renamedResourcePath(ResourceUtil.getResource(cu).getFullPath(), newCUName))) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.Checks_cu_name_used, newName));
        }
        return new RefactoringStatus();
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static boolean isAlreadyNamed(IModelElement element, String name) {
        return name.equals(element.getElementName());
    }

    public static boolean isTopLevel(IType type) {
        return type.getDeclaringType() == null;
    }

    public static RefactoringStatus checkTypeName(String name) {
        if (name.indexOf(".") != -1) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_no_dot);
        }
        return Checks.checkName(name, JavaConventions.validateJavaTypeName((String)name));
    }

    public static RefactoringStatus checkPackageName(String newName) {
        return Checks.checkName(newName, JavaConventions.validatePackageName((String)newName));
    }

    public static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus checkIfCuBroken(IType type) throws ModelException {
        ISourceModule cu = (ISourceModule)DLTKCore.create((IResource)type.getSourceModule().getResource());
        if (cu == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_created);
        }
        if (!cu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_parsed);
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus checkForMainMethods(IType type) {
        return null;
    }

    public static void checkCompileErrorsInAffectedFile(RefactoringStatus result, IResource resource) throws ModelException {
        if (Checks.hasCompileErrors(resource)) {
            result.addWarning(Messages.format(RefactoringCoreMessages.Checks_cu_has_compile_errors, resource.getFullPath().makeRelative()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasCompileErrors(IResource resource) throws ModelException {
        try {
            IMarker[] problemMarkers = resource.findMarkers("org.eclipse.dltk.mod.core.problem", true, 2);
            int i = 0;
            while (true) {
                if (i >= problemMarkers.length) {
                    return false;
                }
                if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    public static IType findTypeInScriptFolder(IScriptFolder scriptFolder, String newElementName) throws ModelException {
        Assert.isTrue((boolean)scriptFolder.exists());
        Assert.isTrue((!scriptFolder.isReadOnly() ? 1 : 0) != 0);
        if (newElementName.indexOf(".") != -1) {
            newElementName = newElementName.substring(0, newElementName.indexOf("."));
        }
        ISourceModule[] cus = scriptFolder.getSourceModules();
        int i = 0;
        while (i < cus.length) {
            if (cus[i].getType(newElementName).exists()) {
                return cus[i].getType(newElementName);
            }
            ++i;
        }
        return null;
    }

    public static IFile[] getModifiedFiles(Change[] changes) {
        ArrayList result = new ArrayList();
        Checks.getModifiedFiles(result, changes);
        return result.toArray(new IFile[result.size()]);
    }

    private static void getModifiedFiles(List result, Change[] changes) {
        int i = 0;
        while (i < changes.length) {
            IFile file;
            Change change = changes[i];
            Object modifiedElement = change.getModifiedElement();
            if (modifiedElement instanceof IAdaptable && (file = (IFile)((IAdaptable)modifiedElement).getAdapter(IFile.class)) != null) {
                result.add(file);
            }
            if (change instanceof CompositeChange) {
                Checks.getModifiedFiles(result, ((CompositeChange)change).getChildren());
            }
            ++i;
        }
    }

    public static RefactoringStatus checkSourceModuleName(String newName) {
        Status status = null;
        if (newName == null) {
            status = new Status(4, "org.eclipse.dltk.mod.core", -1, RefactoringCoreMessages.convention_unit_nullName, null);
        }
        if (!newName.endsWith(".js")) {
            status = new Status(4, "org.eclipse.dltk.mod.core", -1, RefactoringCoreMessages.convention_unit_notJavaScriptName, null);
        }
        if (status != null) {
            return Checks.checkName(newName, (IStatus)status);
        }
        newName = Checks.removeJavaScriptLikeExtension(newName);
        return Checks.checkTypeName(newName);
    }

    public static String getFullPath(ISourceModule cu) {
        Assert.isTrue((boolean)cu.exists());
        return cu.getResource().getFullPath().toString();
    }

    public static String removeJavaScriptLikeExtension(String name) {
        if (name.lastIndexOf(".") != -1) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }
}

