/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.browsing.ext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.ui.browsing.ext.ColumnForm;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class MultiSelectionListViewer
extends ScrolledComposite {
    private List viewers = new ArrayList();
    private int elements = 0;
    private ColumnForm columnForm;
    private ITreeContentProvider contentProvider;
    private Object input;
    private ILabelProvider labelProvider;
    private int selectedView = 0;

    private void updateAll(int controlIndex) {
        TreeViewer viewer;
        Tree tree;
        if (this.viewers.size() == 0) {
            this.addPane();
            return;
        }
        int i = controlIndex + 1;
        while (i < this.viewers.size()) {
            TreeViewer viewer2 = (TreeViewer)this.viewers.get(i);
            if (!viewer2.getControl().isDisposed()) {
                viewer2.refresh(true);
            }
            ++i;
        }
        this.selectedView = controlIndex;
        Object[] elementsFrom = this.getElementsFrom(controlIndex);
        boolean required = false;
        if (elementsFrom.length > 0) {
            required = true;
        }
        int disposeCount = 0;
        int i2 = this.viewers.size() - 1;
        while (i2 > controlIndex) {
            elementsFrom = this.getElementsFrom(i2);
            if (elementsFrom.length == 0) {
                ++disposeCount;
            }
            --i2;
        }
        int j = 0;
        while (j < disposeCount) {
            if (j != disposeCount - 1 || !required) {
                this.removePane();
            }
            ++j;
        }
        if (controlIndex == this.viewers.size() - 1 && required) {
            this.addPane();
        }
        if (!(tree = (viewer = (TreeViewer)this.viewers.get(controlIndex)).getTree()).isDisposed()) {
            tree.getBounds();
        }
        this.elementSelectionChanged(viewer.getSelection());
    }

    public MultiSelectionListViewer(Composite parent, int style) {
        super(parent, style | 0x100);
        this.setLayout((Layout)new GridLayout());
        this.columnForm = new ColumnForm((Composite)this, 65792);
        this.columnForm.setSize(400, 300);
        this.setContent((Control)this.columnForm);
        this.setExpandVertical(true);
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                MultiSelectionListViewer.this.columnForm.layout();
            }
        });
        this.layout();
        this.columnForm.layout();
    }

    private void addPane() {
        if (this.isDisposed()) {
            return;
        }
        Tree list = new Tree((Composite)this.columnForm, 4);
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer viewer = new TreeViewer(list);
        viewer.setContentProvider((IContentProvider)new TreeContentProvider(this.elements));
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.configureViewer(viewer);
        viewer.setInput(this.input);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionUpdater(this.elements));
        list.setSize(100, 100);
        list.layout();
        this.viewers.add(viewer);
        this.columnForm.layout();
        this.layout();
        ++this.elements;
    }

    protected void configureViewer(TreeViewer viewer) {
    }

    private void removePane() {
        if (this.elements > 0 && !this.isDisposed()) {
            --this.elements;
            TreeViewer last = (TreeViewer)this.viewers.get(this.viewers.size() - 1);
            if (!last.getControl().isDisposed()) {
                last.getControl().dispose();
            }
            this.viewers.remove(last);
            this.columnForm.layout();
            this.layout();
        }
    }

    public void setContentProvider(ITreeContentProvider provider) {
        this.contentProvider = provider;
    }

    public void setInput(Object input) {
        if (input != null && !input.equals(this.input)) {
            this.contentProvider.inputChanged(null, this.input, input);
        }
        this.input = input;
        int len = this.viewers.size();
        int i = 0;
        while (i < len) {
            this.removePane();
            ++i;
        }
        this.updateAll(0);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    private Object[] getElementsFrom(int controlIndex) {
        if (controlIndex < this.viewers.size()) {
            IStructuredSelection sel;
            Object firstElement;
            TreeViewer prevViewer = (TreeViewer)this.viewers.get(controlIndex);
            ISelection selection = prevViewer.getSelection();
            if (selection != null && selection instanceof IStructuredSelection && (firstElement = (sel = (IStructuredSelection)selection).getFirstElement()) != null) {
                return this.contentProvider.getChildren(firstElement);
            }
        } else {
            return this.contentProvider.getElements(this.input);
        }
        return new Object[0];
    }

    public ISelection getSelection() {
        if (this.viewers.size() > this.selectedView) {
            TreeViewer viewer = (TreeViewer)this.viewers.get(this.selectedView);
            return viewer.getSelection();
        }
        return null;
    }

    public void elementSelectionChanged(ISelection selection) {
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
        int i = 0;
        while (i < this.viewers.size()) {
            TreeViewer viewer = (TreeViewer)this.viewers.get(i);
            if (!viewer.getControl().isDisposed()) {
                viewer.refresh(true);
            }
            ++i;
        }
    }

    public class SelectionUpdater
    implements ISelectionChangedListener {
        int controlIndex = 0;

        public SelectionUpdater(int controlIndex) {
            this.controlIndex = controlIndex;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            MultiSelectionListViewer.this.updateAll(this.controlIndex);
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private int controlIndex = 0;
        Object[] NONE = new Object[0];

        public TreeContentProvider(int index) {
            this.controlIndex = index;
        }

        public Object[] getElements(Object inputElement) {
            if (this.controlIndex == 0) {
                return MultiSelectionListViewer.this.contentProvider.getElements(MultiSelectionListViewer.this.input);
            }
            return MultiSelectionListViewer.this.getElementsFrom(this.controlIndex - 1);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return this.NONE;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

