/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.javatojs.control.ITranslationInitializer;
import org.eclipse.vjet.dsf.javatojs.control.translate.DeclarationPhase;
import org.eclipse.vjet.dsf.javatojs.control.translate.DependencyPhase;
import org.eclipse.vjet.dsf.javatojs.control.translate.ImplementationPhase;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TraceTime;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslationTraceId;
import org.eclipse.vjet.dsf.javatojs.translate.AstBinding;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.config.TranslateConfig;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomTranslateDelegator;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.javatojs.util.AstParserHelper;
import org.eclipse.vjet.dsf.javatojs.util.JavaToJsHelper;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.traversal.JstDepthFirstTraversal;
import org.eclipse.vjet.dsf.jst.traversal.JstVisitorAdapter;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;

public final class TranslationController {
    public static final TraceId CONTROLLER = TranslationTraceId.CONTROLLER;
    public static final TraceAttr TARGETED = new TraceAttr("method", "TargetedTranslation");
    public static final TraceAttr ON_DEMAND = new TraceAttr("method", "OnDemandTranslation");
    private static final JstCache s_jstCache = JstCache.getInstance();
    private ITranslationInitializer m_initializer;
    private TranslateCtx m_ctx;
    private List<TranslateError> m_directErrors = new ArrayList<TranslateError>();
    private List<TranslateError> m_phaseErrors = new ArrayList<TranslateError>();
    private Map<JstType, List<Throwable>> m_exceptions = new LinkedHashMap<JstType, List<Throwable>>();
    private boolean m_initialized = false;

    public TranslationController() {
        s_jstCache.clear();
        this.m_ctx = TranslateCtx.createCtx();
    }

    public TranslationController(ITranslationInitializer configInitializer) {
        this();
        this.setInitializer(configInitializer);
    }

    public TranslationController setInitializer(ITranslationInitializer initializer) {
        this.m_initializer = initializer;
        return this;
    }

    public ITranslationInitializer getInitializer() {
        return this.m_initializer;
    }

    public boolean isParallelEnabled() {
        return this.m_ctx.isParallelEnabled();
    }

    public TranslationController enableParallel(boolean enableParallel) {
        this.m_ctx.enableParallel(enableParallel);
        return this;
    }

    public boolean isTraceEnabled() {
        return this.m_ctx.isTraceEnabled();
    }

    public TranslationController enableTrace(boolean enableTrace) {
        this.m_ctx.enableTrace(enableTrace);
        return this;
    }

    public TranslateCtx getCtx() {
        if (this.m_ctx == null) {
            this.m_ctx = TranslateCtx.createCtx();
        }
        return this.m_ctx;
    }

    public TranslateConfig getConfig() {
        return this.getCtx().getConfig();
    }

    public JstType targetedTranslation(Class<?> srcType) {
        this.initialize();
        TraceTime timer = this.m_ctx.getTraceManager().getTimer();
        this.getTracer().startGroup(CONTROLLER, timer, TARGETED);
        try {
            ArrayList srcTypes = new ArrayList(1);
            srcTypes.add(srcType);
            List<JstType> jstTypes = this.targetedTranslation(this.getSourceFiles(srcTypes, this.m_directErrors), this.m_directErrors);
            JstType jstType = jstTypes.isEmpty() ? null : jstTypes.get(0);
            return jstType;
        }
        finally {
            this.getTracer().endGroup(CONTROLLER, this.m_directErrors, timer);
        }
    }

    public List<JstType> targetedTranslation(List<Class<?>> srcTypes) {
        this.initialize();
        TraceTime timer = this.m_ctx.getTraceManager().getTimer();
        this.getTracer().startGroup(CONTROLLER, timer, TARGETED);
        try {
            List<JstType> list = this.targetedTranslation(this.getSourceFiles(srcTypes, this.m_directErrors), this.m_directErrors);
            return list;
        }
        finally {
            this.getTracer().endGroup(CONTROLLER, this.m_directErrors, timer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JstType targetedTranslation(URI fileURI, InputStreamReader inputSrc) {
        this.initialize();
        TraceTime timer = this.m_ctx.getTraceManager().getTimer();
        this.getTracer().startGroup(CONTROLLER, timer, TARGETED);
        try {
            if (inputSrc == null) {
                this.m_directErrors.add(new TranslateError("SrcNotFound", "inputSrc is null"));
                return null;
            }
            if (fileURI == null) {
                this.m_directErrors.add(new TranslateError("SrcNotFound", "fileName is null"));
                return null;
            }
            String src = JavaToJsHelper.readFromInputReader(inputSrc);
            if (src == null) {
                this.m_directErrors.add(new TranslateError("SrcNotFound", "Source is not found for the input stream"));
                return null;
            }
            LinkedHashMap<URI, String> srcFiles = new LinkedHashMap<URI, String>();
            srcFiles.put(fileURI, src);
            List<JstType> jstTypes = this.targetedTranslation(srcFiles, this.m_directErrors);
            JstType jstType = jstTypes.isEmpty() ? null : jstTypes.get(0);
            return jstType;
        }
        finally {
            this.getTracer().endGroup(CONTROLLER, this.m_directErrors, timer);
        }
    }

    public List<JstType> targetedTranslation(Map<URI, String> files) {
        this.initialize();
        TraceTime timer = this.m_ctx.getTraceManager().getTimer();
        this.getTracer().startGroup(CONTROLLER, timer, TARGETED);
        try {
            List<JstType> list = this.targetedTranslation(files, this.m_directErrors);
            return list;
        }
        finally {
            this.getTracer().endGroup(CONTROLLER, this.m_directErrors, timer);
        }
    }

    public List<JstType> onDemandTranslation(Class<?> srcCls) {
        this.initialize();
        TraceTime timer = this.m_ctx.getTraceManager().getTimer();
        this.getTracer().startGroup(CONTROLLER, timer, ON_DEMAND);
        try {
            ArrayList srcTypes = new ArrayList(1);
            srcTypes.add(srcCls);
            List<JstType> list = this.onDemandTranslation(this.getSourceFiles(srcTypes, this.m_directErrors), this.m_directErrors);
            return list;
        }
        finally {
            this.getTracer().endGroup(CONTROLLER, this.m_directErrors, timer);
        }
    }

    public List<JstType> onDemandTranslation(List<Class<?>> srcTypes) {
        this.initialize();
        TraceTime timer = this.m_ctx.getTraceManager().getTimer();
        this.getTracer().startGroup(CONTROLLER, timer, ON_DEMAND);
        try {
            List<JstType> list = this.onDemandTranslation(this.getSourceFiles(srcTypes, this.m_directErrors), this.m_directErrors);
            return list;
        }
        finally {
            this.getTracer().endGroup(CONTROLLER, this.m_directErrors, timer);
        }
    }

    public List<JstType> onDemandTranslation(Map<URI, String> files) {
        this.initialize();
        TraceTime timer = this.m_ctx.getTraceManager().getTimer();
        this.getTracer().startGroup(CONTROLLER, timer, ON_DEMAND);
        try {
            List<JstType> list = this.onDemandTranslation(files, this.m_directErrors);
            return list;
        }
        finally {
            this.getTracer().endGroup(CONTROLLER, this.m_directErrors, timer);
        }
    }

    public List<TranslateError> getErrors() {
        ArrayList<TranslateError> errors = new ArrayList<TranslateError>();
        errors.addAll(this.m_directErrors);
        errors.addAll(this.m_phaseErrors);
        Collection<TranslateInfo> tInfos = this.getCtx().getAllTranslateInfos();
        for (TranslateInfo info : tInfos) {
            errors.addAll(info.getStatus().getErrors());
        }
        return errors;
    }

    public Map<JstType, List<Throwable>> getExceptions() {
        return Collections.unmodifiableMap(this.m_exceptions);
    }

    public void reset() {
        this.m_ctx.reset();
        s_jstCache.clear();
        this.m_directErrors.clear();
        this.m_phaseErrors.clear();
        this.m_exceptions.clear();
        this.m_initialized = false;
    }

    private void initialize() {
        if (this.m_initialized) {
            return;
        }
        CustomTranslateDelegator customTranslator = this.getCtx().getProvider().getCustomTranslator();
        Initializer.getInstance().initialize(this.getInitializer());
        List list = this.m_ctx.getConfig().getJstLibProvider().getAll();
        for (IJstLib lib : list) {
            for (JstType jstType : lib.getAllTypes(true)) {
                customTranslator.initialize(jstType);
            }
        }
        this.m_initialized = true;
    }

    private List<JstType> createJstTypes(Map<URI, String> files, List<TranslateError> errors) {
        if (files == null) {
            errors.add(new TranslateError("NullInput", "files is null"));
            return Collections.emptyList();
        }
        ArrayList<JstType> jstTypes = new ArrayList<JstType>();
        String pkgPath = null;
        String pkgName = null;
        String clsName = null;
        for (Map.Entry<URI, String> entry : files.entrySet()) {
            String filePath = entry.getKey().toString();
            String src = entry.getValue();
            if (src == null) {
                errors.add(new TranslateError("SrcNotFound", "Source value is null for: " + filePath));
                continue;
            }
            if (filePath != null) {
                int index = filePath.lastIndexOf("\\");
                if (index < 0) {
                    index = filePath.lastIndexOf("/");
                }
                if (index < 0) {
                    errors.add(new TranslateError("InvalidPath", "Invalid path: " + filePath));
                    continue;
                }
                pkgPath = filePath.substring(0, index);
                clsName = filePath.substring(index + 1);
                if ((index = clsName.indexOf(".")) > 0) {
                    clsName = clsName.substring(0, index);
                }
                if ((pkgName = JavaToJsHelper.getPkgNameFromSrc(src)) == null) {
                    errors.add(new TranslateError("InvalidType", "package is null"));
                    continue;
                }
            } else {
                errors.add(new TranslateError("InvalidPath", "path is null"));
                continue;
            }
            try {
                JstType jstType = this.createJstType(new URL(pkgPath), pkgName, clsName, src, errors);
                if (jstType == null || this.m_ctx.isExcluded((IJstType)jstType)) continue;
                jstTypes.add(jstType);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return jstTypes;
    }

    private JstType createJstType(URL pkgPath, String pkgName, String clsName, String src, List<TranslateError> errors) {
        String clsFullName;
        if (pkgName == null) {
            clsFullName = clsName;
        } else {
            clsFullName = pkgName != null && pkgName.length() > 0 ? String.valueOf(pkgName) + "." + clsName : clsName;
            if (DataTypeHelper.getNativeType((String)clsFullName) == null) {
                clsFullName = String.valueOf(this.m_ctx.getConfig().getPackageMapping().mapTo(pkgName)) + "." + clsName;
            }
        }
        if (this.m_ctx.isExcludedType(clsFullName)) {
            errors.add(new TranslateError(LogLevel.WARN, "ExcludedType", String.valueOf(clsFullName) + " is disabled in policy."));
            return null;
        }
        JstType jstType = s_jstCache.getType(clsFullName, true);
        if (src != null) {
            ASTParser astParser = AstParserHelper.newParser(this.m_ctx.getConfig().shouldParseComments());
            astParser.setSource(src.toCharArray());
            CompilationUnit cu = (CompilationUnit)astParser.createAST(null);
            jstType.setSource(new JstSource((JstSource.IBinding)new AstBinding(pkgPath, pkgName, clsName, (ASTNode)cu)));
        }
        return jstType;
    }

    private Map<URI, String> getSourceFiles(List<Class<?>> srcTypes, List<TranslateError> errors) {
        if (srcTypes == null) {
            errors.add(new TranslateError("NullInput", "srcTypes is null"));
            return Collections.emptyMap();
        }
        LinkedHashMap<URI, String> srcFiles = new LinkedHashMap<URI, String>();
        for (Class<?> cls : srcTypes) {
            if (cls == null) {
                errors.add(new TranslateError("NullInput", "cls is null"));
                continue;
            }
            URL url = JavaSourceLocator.getInstance().getSourceUrl(cls);
            if (url == null) {
                errors.add(new TranslateError("NullInput", "url for " + cls.getName() + " is null"));
                continue;
            }
            try {
                String src = JavaToJsHelper.readFromInputReader(new InputStreamReader(url.openStream()));
                if (src == null) {
                    errors.add(new TranslateError("SrcNotFound", "Source is not found at: " + url.toString()));
                    continue;
                }
                srcFiles.put(url.toURI(), src);
            }
            catch (IOException e) {
                errors.add(new TranslateError("SrcNotFound", "Can not read source from [" + e.getMessage() + "]: " + url.toString()));
            }
            catch (URISyntaxException e) {
                errors.add(new TranslateError("SrcNotFound", "Can not read source from [" + e.getMessage() + "]: " + url.toString()));
            }
        }
        return srcFiles;
    }

    private List<JstType> targetedTranslation(Map<URI, String> files, List<TranslateError> errors) {
        if (files == null) {
            errors.add(new TranslateError("NullInput", "files is null"));
            return Collections.emptyList();
        }
        ArrayList<JstType> allList = new ArrayList<JstType>();
        ArrayList<JstType> removeList = new ArrayList<JstType>();
        List<JstType> entryTypes = this.createJstTypes(files, errors);
        allList.addAll(entryTypes);
        this.preProcess(entryTypes, errors);
        DependencyPhase dependencyPhase = new DependencyPhase(entryTypes, true);
        List<JstType> dependentList = dependencyPhase.translate();
        this.m_phaseErrors.addAll(dependencyPhase.getErrors());
        this.addExceptions(dependencyPhase.getExceptions());
        while (!dependentList.isEmpty()) {
            this.addToList(allList, dependentList);
            removeList.addAll(this.preProcess(dependentList, errors));
            DeclarationPhase declarationPhase = new DeclarationPhase(dependentList, true);
            dependentList = declarationPhase.translate();
            this.m_phaseErrors.addAll(declarationPhase.getErrors());
            this.addExceptions(declarationPhase.getExceptions());
        }
        ImplementationPhase implPhase = new ImplementationPhase(dependencyPhase.getStartingTypes());
        List<JstType> jstTypes = implPhase.translate();
        this.m_phaseErrors.addAll(implPhase.getErrors());
        this.addExceptions(implPhase.getExceptions());
        this.postProcess(allList);
        JstCache cache = JstCache.getInstance();
        for (JstType type : removeList) {
            cache.removeJstType(type);
        }
        return jstTypes;
    }

    private List<JstType> onDemandTranslation(Map<URI, String> files, List<TranslateError> errors) {
        ArrayList<JstType> implList = new ArrayList<JstType>();
        ArrayList<JstType> removeList = new ArrayList<JstType>();
        List<JstType> entryTypes = this.createJstTypes(files, errors);
        implList.addAll(entryTypes);
        this.preProcess(entryTypes, errors);
        DependencyPhase dependencyPhase = new DependencyPhase(entryTypes, true);
        List<JstType> dependentList = dependencyPhase.translate();
        this.m_phaseErrors.addAll(dependencyPhase.getErrors());
        this.addExceptions(dependencyPhase.getExceptions());
        while (!dependentList.isEmpty()) {
            removeList.addAll(this.preProcess(dependentList, errors));
            DeclarationPhase declarationPhase = new DeclarationPhase(dependentList, true);
            this.addToList(implList, dependentList);
            dependentList = declarationPhase.translate();
            this.m_phaseErrors.addAll(declarationPhase.getErrors());
            this.addExceptions(declarationPhase.getExceptions());
        }
        ImplementationPhase implPhase = new ImplementationPhase(implList);
        List<JstType> jstTypes = implPhase.translate();
        this.m_phaseErrors.addAll(implPhase.getErrors());
        this.addExceptions(implPhase.getExceptions());
        this.postProcess(jstTypes);
        JstCache cache = JstCache.getInstance();
        for (JstType type : removeList) {
            cache.removeJstType(type);
        }
        return jstTypes;
    }

    private List<JstType> preProcess(List<JstType> types, List<TranslateError> errors) {
        ArrayList<JstType> removeList = new ArrayList<JstType>();
        for (JstType jstType : types) {
            CompilationUnit cu = AstBindingHelper.getCompilationUnit(jstType);
            String srcName = AstBindingHelper.getSourceName((IJstNode)jstType);
            if (cu != null) continue;
            String jstName = jstType.getName();
            if (jstName == null) {
                removeList.add(jstType);
                errors.add(new TranslateError("NullInput", "jstName is null"));
                continue;
            }
            srcName = this.m_ctx.getConfig().getPackageMapping().mapFrom(jstName);
            URL srcUrl = JavaSourceLocator.getInstance().getSourceUrl(srcName);
            if (srcUrl == null) {
                removeList.add(jstType);
                errors.add(new TranslateError("SrcNotFound", srcName));
                continue;
            }
            String srcPath = srcUrl.toString();
            int index = srcPath.indexOf(srcName.replace(".", "/"));
            String pkgPath = srcPath.substring(0, index);
            String pkgName = srcPath.substring(index);
            pkgName = (index = pkgName.lastIndexOf("/")) < 0 ? null : pkgName.substring(0, index).replace("/", ".");
            pkgPath = String.valueOf(pkgPath) + pkgName.replace(".", "/");
            if (pkgName == null) {
                removeList.add(jstType);
                errors.add(new TranslateError("InvalidPath", "Fail to extract pkgName: " + pkgPath));
                continue;
            }
            String src = JavaSourceLocator.getInstance().getSource(srcUrl);
            if (src == null) {
                removeList.add(jstType);
                errors.add(new TranslateError("SrcNotFound", "failed to read source at " + srcPath));
                continue;
            }
            cu = JavaToJsHelper.toAst(src);
            if (cu == null) {
                removeList.add(jstType);
                errors.add(new TranslateError("FailedToParse", "Failed to parse source at:" + srcPath));
                continue;
            }
            try {
                jstType.setSource(new JstSource((JstSource.IBinding)new AstBinding(new URL(pkgPath), pkgName, jstType.getSimpleName(), (ASTNode)cu)));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return removeList;
    }

    private void postProcess(List<JstType> jstTypes) {
        List<JstVisitorAdapter> visitors = this.m_ctx.getConfig().getPostTranslationVisitors();
        for (JstType type : jstTypes) {
            JstDepthFirstTraversal.accept((IJstNode)type, visitors);
        }
    }

    private void addToList(List<JstType> toList, List<JstType> fromList) {
        for (JstType d : fromList) {
            if (toList.contains(d)) continue;
            toList.add(d);
        }
    }

    private void addExceptions(Map<JstType, List<Throwable>> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        for (Map.Entry<JstType, List<Throwable>> entry : exceptions.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            List<Throwable> list = this.m_exceptions.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<Throwable>();
                this.m_exceptions.put(entry.getKey(), list);
            }
            list.addAll((Collection<Throwable>)entry.getValue());
        }
    }

    private ITranslateTracer getTracer() {
        return this.m_ctx.getTraceManager().getTracer();
    }

    private static class Initializer {
        private static Initializer s_instance = new Initializer();

        private Initializer() {
        }

        private static Initializer getInstance() {
            return s_instance;
        }

        private void initialize(ITranslationInitializer topInitializer) {
            if (topInitializer == null) {
                return;
            }
            Stack<ITranslationInitializer> stack = new Stack<ITranslationInitializer>();
            stack.push(topInitializer);
            this.collectDependents(topInitializer, stack);
            while (!stack.isEmpty()) {
                ITranslationInitializer initializer = stack.pop();
                try {
                    initializer.initialize();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Exception when initialize " + initializer.getClass().getName(), t);
                }
            }
        }

        private void collectDependents(ITranslationInitializer initializer, Stack<ITranslationInitializer> stack) {
            if (initializer == null) {
                return;
            }
            List<ITranslationInitializer> dependents = initializer.getDependents();
            if (dependents == null || dependents.isEmpty()) {
                return;
            }
            for (ITranslationInitializer d : dependents) {
                if (this.inStackAlready(d, stack)) continue;
                stack.push(d);
                this.collectDependents(d, stack);
            }
        }

        private boolean inStackAlready(ITranslationInitializer initializer, Stack<ITranslationInitializer> stack) {
            Iterator itr = stack.iterator();
            while (itr.hasNext()) {
                if (((ITranslationInitializer)itr.next()).getClass() != initializer.getClass()) continue;
                return true;
            }
            return false;
        }
    }
}

