/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.vjet.dsf.javatojs.parse.BaseTypeVisitor;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateTraceMgr;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateTracer;
import org.eclipse.vjet.dsf.javatojs.translate.AstBinding;
import org.eclipse.vjet.dsf.javatojs.translate.DataTypeTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.PackageTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.config.PackageMapping;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.javatojs.util.JavaToJsHelper;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.vjo.lib.LibManager;

public class BasePhase {
    private TranslateCtx m_ctx;
    private TranslationMode m_mode;
    private List<JstType> m_startingTypes;
    private List<JstType> m_dependentTypes;
    private List<StringWriter> m_writers;
    private List<TranslateError> m_directErrors;
    private Map<JstType, List<Throwable>> m_exceptions;
    private PackageMapping m_pkgMapping;
    private DataTypeTranslator m_dataTypeTranslator;

    protected BasePhase(TranslationMode mode) {
        assert (mode != null) : "mode cannot be null";
        this.m_ctx = TranslateCtx.ctx();
        this.m_mode = mode;
        this.m_pkgMapping = this.m_ctx.getConfig().getPackageMapping();
        this.m_dataTypeTranslator = this.m_ctx.getProvider().getDataTypeTranslator();
        if (this.m_ctx.isTraceEnabled()) {
            this.m_writers = new ArrayList<StringWriter>();
        }
    }

    public List<JstType> getStartingTypes() {
        if (this.m_startingTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_startingTypes);
    }

    public List<TranslateError> getErrors() {
        if (this.m_directErrors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_directErrors);
    }

    public Map<JstType, List<Throwable>> getExceptions() {
        if (this.m_exceptions == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_exceptions);
    }

    protected TranslateCtx getCtx() {
        return this.m_ctx;
    }

    protected TranslationMode getMode() {
        return this.m_mode;
    }

    protected List<JstType> getDependentTypes() {
        if (this.m_dependentTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_dependentTypes);
    }

    protected void setStartingTypes(List<JstType> types) {
        this.m_startingTypes = types;
    }

    protected void addStartingType(JstType type) {
        if (type == null) {
            return;
        }
        if (this.m_startingTypes == null) {
            this.m_startingTypes = new ArrayList<JstType>();
        } else if (this.m_startingTypes.contains(type)) {
            return;
        }
        this.m_startingTypes.add(type);
    }

    protected void addDependency(BaseTypeVisitor visitor) {
        TranslateInfo tInfo;
        Map<String, JstType> unknownList;
        JstType targetType = visitor.getType();
        if (targetType == null) {
            return;
        }
        List<JstType> dependents = visitor.getDependency();
        if (dependents != null) {
            for (JstType t : dependents) {
                this.addDependentType(targetType, t);
            }
        }
        if ((unknownList = (tInfo = this.m_ctx.getTranslateInfo(targetType)).getUnknownTypes()).isEmpty()) {
            return;
        }
        ArrayList<String> importedPkgs = new ArrayList<String>();
        if (targetType.getPackage() != null) {
            importedPkgs.add(this.m_ctx.getConfig().getPackageMapping().mapFrom(targetType.getPackage().getName()));
        }
        importedPkgs.addAll(tInfo.getImportedPkgs());
        PackageTranslator pkgTranslator = this.m_ctx.getProvider().getPackageTranslator();
        PackageMapping pkgMapping = this.m_ctx.getConfig().getPackageMapping();
        HashMap<String, JstType> unresolvedList = new HashMap<String, JstType>();
        for (Map.Entry<String, JstType> entry : unknownList.entrySet()) {
            boolean resolved = false;
            for (String pkg : importedPkgs) {
                String clsName = TranslateHelper.Type.resolveImplicitImport(String.valueOf(pkg) + "." + entry.getKey(), targetType);
                if (clsName == null) continue;
                if (JstCache.getInstance().getType(pkgMapping.mapTo(clsName)) != null) {
                    resolved = true;
                    break;
                }
                JstType dependent = entry.getValue();
                this.addDependentType(targetType, dependent);
                if (dependent.getPackage() == null) {
                    dependent.setPackage(pkgTranslator.getPackage(pkg));
                }
                resolved = true;
                break;
            }
            if (resolved) continue;
            unresolvedList.put(entry.getKey(), entry.getValue());
        }
        try {
            this.processUnresolved(targetType, unresolvedList);
        }
        catch (Exception e) {
            System.out.println("Problem while processing unresolved");
            e.printStackTrace();
        }
    }

    protected void addError(TranslateError error) {
        if (this.m_directErrors == null) {
            this.m_directErrors = new ArrayList<TranslateError>();
        }
        this.m_directErrors.add(error);
    }

    protected void setExceptions(JstType type, List<Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        if (this.m_exceptions == null) {
            this.m_exceptions = new LinkedHashMap<JstType, List<Throwable>>();
        }
        this.m_exceptions.put(type, exceptions);
    }

    protected ITranslateTracer getTracer() {
        return this.m_ctx.getTraceManager().getTracer();
    }

    protected ITranslateTracer getTracer(JstType type) {
        if (this.m_ctx.isTraceEnabled()) {
            StringWriter writer = new StringWriter();
            this.m_writers.add(writer);
            return this.m_ctx.getTraceManager().getTracer(writer);
        }
        return TranslateTracer.NO_OP;
    }

    protected void mergeTraces() {
        if (!this.m_ctx.isTraceEnabled() || this.m_writers == null) {
            return;
        }
        TranslateTraceMgr mgr = this.m_ctx.getTraceManager();
        for (StringWriter w : this.m_writers) {
            mgr.append(w.toString());
        }
    }

    private void addDependentType(JstType targetType, JstType dependentType) {
        if (dependentType == null || dependentType instanceof JstArray) {
            return;
        }
        if (this.m_ctx.isJsType((IJstType)dependentType) || this.m_ctx.isMappedToJS((IJstType)dependentType) || this.m_ctx.isExcluded((IJstType)dependentType)) {
            return;
        }
        JstType jstType = dependentType;
        String simpleName = jstType.getSimpleName();
        String fullName = jstType.getName();
        TranslateInfo targetTypeInfo = this.m_ctx.getTranslateInfo(targetType);
        TranslateInfo dependentTypeInfo = this.m_ctx.getTranslateInfo(dependentType);
        PackageMapping pkgMapping = this.m_ctx.getConfig().getPackageMapping();
        String srcName = pkgMapping.mapFrom(fullName);
        if (srcName == null) {
            this.addError(new TranslateError("SrcNameIsNull", "srcName is null for '" + fullName + "'"));
            return;
        }
        DataTypeTranslator dataTypeTranslator = this.m_ctx.getProvider().getDataTypeTranslator();
        if (LibManager.getInstance().hasType(fullName) || DataTypeHelper.isPrimitiveType((String)simpleName) || DataTypeHelper.isInJDK((String)fullName) || VjoTranslateHelper.isVjoNativeType(fullName) || VjoTranslateHelper.isVjoJdkType(fullName) || this.m_ctx.isMappedToVJO((IJstType)dependentType)) {
            if (!this.addImport(targetType, jstType)) {
                dataTypeTranslator.addImport((IJstType)dependentType, targetType, fullName);
            }
            return;
        }
        TranslationMode mode = this.getMode();
        if (mode.hasDeclaration() && dependentTypeInfo.getMode().hasDeclaration() || mode.hasDependency() && dependentTypeInfo.getMode().hasDependency()) {
            this.addImport(targetType, jstType);
            return;
        }
        String clsName = TranslateHelper.Type.resolveEmbeddedType(srcName, targetType);
        if (clsName == null) {
            clsName = TranslateHelper.Type.resolveImplicitImport(srcName, targetType);
        }
        if (clsName != null) {
            if (clsName.equals(pkgMapping.mapFrom(targetType.getName()))) {
                return;
            }
            if (this.m_ctx.isExcludedType(clsName)) {
                targetTypeInfo.setType(dependentType.getSimpleName(), (IJstType)dependentType);
                return;
            }
        } else {
            if (this.m_ctx.isExcludedType(srcName)) {
                targetTypeInfo.setType(dependentType.getSimpleName(), (IJstType)dependentType);
                return;
            }
            this.addError(new TranslateError(LogLevel.WARN, "SrcNotFound", "Source not found for '" + srcName + "' when translating " + targetType.getName()));
            return;
        }
        String jstName = pkgMapping.mapTo(clsName);
        String pkg = TranslateHelper.getPkgName(jstName);
        if (clsName.equals(srcName)) {
            JstType cachedType = JstCache.getInstance().addType(jstType, true);
            if (cachedType != jstType) {
                targetTypeInfo.setClearTypeRefs(true);
                jstType = cachedType;
            }
            this.addImport(targetType, jstType);
        } else if (srcName.indexOf(".") < 0) {
            jstType.setPackage(new JstPackage(pkg));
            JstType cachedType = JstCache.getInstance().addType(jstType, true);
            if (cachedType != jstType) {
                targetTypeInfo.setClearTypeRefs(true);
                jstType = cachedType;
            }
            this.addImport(targetType, jstType);
        } else {
            jstType = JstCache.getInstance().getType(jstName, true);
            if (targetTypeInfo.getType(simpleName, false) != null) {
                targetTypeInfo.removeType(simpleName);
            }
            if (targetTypeInfo.getType(srcName, false) != null) {
                targetTypeInfo.removeType(srcName);
            }
            dataTypeTranslator.addImport((IJstType)jstType, targetType, jstType.getSimpleName());
            targetTypeInfo.setClearTypeRefs(true);
        }
        if (this.m_dependentTypes == null) {
            this.m_dependentTypes = new ArrayList<JstType>();
        } else if (this.m_dependentTypes.contains(jstType)) {
            return;
        }
        this.m_dependentTypes.add(jstType);
    }

    private void processUnresolved(JstType targetType, Map<String, JstType> unResolvedTypes) throws MalformedURLException, IOException, URISyntaxException {
        if (unResolvedTypes.isEmpty()) {
            return;
        }
        AstBinding astBinging = AstBindingHelper.getAstSrcBinding((IJstNode)targetType);
        if (astBinging == null) {
            return;
        }
        URL pkgPath = astBinging.getPkgPath();
        String pkgName = astBinging.getPkgName();
        ArrayList<URL> fileList = new ArrayList<URL>();
        JavaToJsHelper.getDirectFiles(pkgPath, fileList, this.m_ctx.getConfig().getFileFilter());
        ArrayList<String> typesInSamePackage = new ArrayList<String>();
        for (URL file : fileList) {
            String clsName;
            String filePath = file.getPath();
            int index = filePath.lastIndexOf("\\");
            if (index < 0) {
                index = filePath.lastIndexOf("/");
            }
            if ((index = (clsName = filePath.substring(index + 1)).indexOf(".")) > 0) {
                clsName = clsName.substring(0, index);
            }
            if (clsName.equals(targetType.getSimpleName())) continue;
            typesInSamePackage.add(pkgName == null ? clsName : String.valueOf(pkgName) + "." + clsName);
        }
        PackageMapping pkgMapping = this.m_ctx.getConfig().getPackageMapping();
        DataTypeTranslator dataTypeTranslator = this.m_ctx.getProvider().getDataTypeTranslator();
        block1: for (Map.Entry<String, JstType> entry : unResolvedTypes.entrySet()) {
            String typeName = entry.getKey();
            JstType type = entry.getValue();
            boolean isResolved = false;
            for (String srcName : typesInSamePackage) {
                URL srcUrl = JavaSourceLocator.getInstance().getSourceUrl(srcName);
                String src = JavaSourceLocator.getInstance().getSource(srcUrl);
                if (src == null) {
                    this.addError(new TranslateError("InvalidPath", "Source is null for " + srcName));
                    continue;
                }
                CompilationUnit cu = JavaToJsHelper.toAst(src);
                block3: for (Object o : cu.types()) {
                    if (!(o instanceof AbstractTypeDeclaration)) continue;
                    AbstractTypeDeclaration astType = (AbstractTypeDeclaration)o;
                    if (astType.getName().toString().equals(typeName)) {
                        type.setPackage(targetType.getPackage());
                        dataTypeTranslator.addImport((IJstType)type, targetType, type.getSimpleName());
                        String jstName = pkgMapping.mapTo(srcName);
                        JstType dType = JstCache.getInstance().getType(jstName, true);
                        dType.addSiblingType(type);
                        this.addDependentType(targetType, dType);
                        isResolved = true;
                        break;
                    }
                    for (Object bodyObj : astType.bodyDeclarations()) {
                        if (!(bodyObj instanceof AbstractTypeDeclaration) || !this.containType(astType = (AbstractTypeDeclaration)bodyObj, typeName)) continue;
                        String jstName = pkgMapping.mapTo(srcName);
                        JstType dType = JstCache.getInstance().getType(jstName, true);
                        if (!dType.hasInnerType(type.getSimpleName())) {
                            dType.addInnerType(type);
                        }
                        this.addDependentType(targetType, dType);
                        isResolved = true;
                        continue block3;
                    }
                }
                if (isResolved) continue block1;
            }
        }
    }

    private boolean addImport(JstType targetType, JstType dependentType) {
        TranslateInfo targetTypeInfo = this.m_ctx.getTranslateInfo(targetType);
        String simpleName = dependentType.getSimpleName();
        String fullName = dependentType.getName();
        String srcName = this.m_pkgMapping.mapFrom(fullName);
        if (targetTypeInfo.getType(srcName, false) != null) {
            this.m_dataTypeTranslator.addImport((IJstType)dependentType, targetType, fullName);
            return true;
        }
        if (targetTypeInfo.getType(simpleName, false) != null) {
            this.m_dataTypeTranslator.addImport((IJstType)dependentType, targetType, simpleName);
            return true;
        }
        return false;
    }

    private boolean containType(AbstractTypeDeclaration astType, String typeName) {
        if (astType.getName().toString().equals(typeName)) {
            return true;
        }
        for (Object bodyObj : astType.bodyDeclarations()) {
            if (!(bodyObj instanceof AbstractTypeDeclaration) || !this.containType((AbstractTypeDeclaration)bodyObj, typeName)) continue;
            return true;
        }
        return false;
    }
}

