/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.javatojs.control.translate.ResponseCommand;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TraceTime;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslationTraceId;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public abstract class BaseTask
extends ResponseCommand {
    public static final TraceId TASK = TranslationTraceId.TASK;
    private String m_id;
    private CompilationUnit m_cu;
    private TranslateCtx m_parentCtx;
    private ITranslateTracer m_tracer;
    private List<Throwable> m_exceptions;

    BaseTask(String id, CompilationUnit cu, ITranslateTracer tracer, TranslateCtx parentCtx) {
        this.m_id = id;
        this.m_cu = cu;
        this.m_tracer = tracer;
        this.m_parentCtx = parentCtx;
    }

    protected abstract TranslationMode getMode();

    protected abstract JstType getType();

    abstract void doIt();

    @Override
    public void execute() {
        TraceTime timer = this.m_parentCtx.getTraceManager().getTimer();
        if (this.m_tracer.isEnabled()) {
            this.m_tracer.startGroup(TASK, timer, new TraceAttr("type", this.getId()), new TraceAttr("mode", this.getMode().toString()), new TraceAttr("thread", String.valueOf(Thread.currentThread().getId())));
        }
        try {
            try {
                this.setupCtx();
                this.doIt();
            }
            catch (Throwable t) {
                if (this.m_exceptions == null) {
                    this.m_exceptions = new ArrayList<Throwable>();
                }
                this.m_exceptions.add(t);
                t.printStackTrace();
                if (this.m_tracer.isEnabled()) {
                    this.m_tracer.endGroup(TASK, this.getErrors(), timer);
                }
                this.restoreCtx();
            }
        }
        finally {
            if (this.m_tracer.isEnabled()) {
                this.m_tracer.endGroup(TASK, this.getErrors(), timer);
            }
            this.restoreCtx();
        }
    }

    public String getId() {
        return this.m_id;
    }

    public String toString() {
        return this.getId();
    }

    CompilationUnit getCompilationUnit() {
        return this.m_cu;
    }

    protected ITranslateTracer getTracer() {
        return this.m_tracer;
    }

    public List<TranslateError> getErrors() {
        if (this.getType() == null) {
            return Collections.emptyList();
        }
        JstType jstType = this.getType();
        if (jstType.getEmbededTypes().isEmpty()) {
            return this.m_parentCtx.getTranslateInfo(jstType).getStatus().getErrors();
        }
        ArrayList<TranslateError> list = new ArrayList<TranslateError>();
        list.addAll(this.m_parentCtx.getTranslateInfo(jstType).getStatus().getErrors());
        for (JstType embeded : jstType.getEmbededTypes()) {
            list.addAll(this.m_parentCtx.getTranslateInfo(embeded).getStatus().getErrors());
        }
        return list;
    }

    public List<Throwable> getExceptions() {
        if (this.m_exceptions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_exceptions);
    }

    private void setupCtx() {
        TranslateCtx.createChildCtx(this.m_parentCtx).getTraceManager().setTracer(this.m_tracer);
    }

    private void restoreCtx() {
        TranslateCtx.setCtx(this.m_parentCtx);
    }
}

