/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control.translate;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.javatojs.control.translate.BasePhase;
import org.eclipse.vjet.dsf.javatojs.control.translate.TranslationParallelRunner;
import org.eclipse.vjet.dsf.javatojs.control.translate.TypeVisitTask;
import org.eclipse.vjet.dsf.javatojs.parse.BaseTypeVisitor;
import org.eclipse.vjet.dsf.javatojs.parse.TypeDependencyVisitor;
import org.eclipse.vjet.dsf.javatojs.parse.TypeDnDVisitor;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslationTraceId;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class DependencyPhase
extends BasePhase {
    private static final TraceId DEPENDENCY_PHASE = TranslationTraceId.DEPENDENCY_PHASE;

    public DependencyPhase(JstType jstType, boolean includeDeclaration) {
        super(new TranslationMode().addDependency());
        ArrayList<JstType> jstTypes = new ArrayList<JstType>();
        jstTypes.add(jstType);
        this.setStartingTypes(jstTypes);
        if (includeDeclaration) {
            this.getMode().addDeclaration();
        }
    }

    public DependencyPhase(List<JstType> jstTypes, boolean includeDeclaration) {
        super(new TranslationMode().addDependency());
        this.setStartingTypes(jstTypes);
        if (includeDeclaration) {
            this.getMode().addDeclaration();
        }
    }

    public List<JstType> translate() {
        ITranslateTracer tracer = this.getTracer();
        tracer.startGroup(DEPENDENCY_PHASE, new TraceAttr[0]);
        try {
            TranslateCtx ctx = this.getCtx();
            TranslationMode mode = this.getMode();
            List<JstType> jstTypes = this.getStartingTypes();
            ArrayList<TypeVisitTask> tasks = new ArrayList<TypeVisitTask>(jstTypes.size());
            for (JstType jstType : jstTypes) {
                if (jstType == null) {
                    this.addError(new TranslateError("NullInput", "jstType is null"));
                    continue;
                }
                ctx.getTranslateInfo(jstType).addMode(mode);
                CompilationUnit cu = AstBindingHelper.getCompilationUnit(jstType);
                String srcName = AstBindingHelper.getSourceName((IJstNode)jstType);
                BaseTypeVisitor visitor = this.createVisitor(jstType);
                tasks.add(new TypeVisitTask(srcName, cu, visitor, this.getTracer(jstType), ctx));
            }
            if (tasks.size() == 1 || !ctx.isParallelEnabled()) {
                for (TypeVisitTask task : tasks) {
                    task.execute();
                    this.addDependency(task.getVisitor());
                    if (task.getType() == null) {
                        this.addError(new TranslateError("StackError", String.valueOf(task.getId()) + ": curType is null"));
                        continue;
                    }
                    this.setExceptions(task.getType(), task.getExceptions());
                }
            } else if (tasks.size() > 0) {
                TranslationParallelRunner.getInstance().execute(tasks);
                for (TypeVisitTask task : tasks) {
                    this.addDependency(task.getVisitor());
                    this.setExceptions(task.getType(), task.getExceptions());
                }
            }
            this.mergeTraces();
            List<JstType> list = this.getDependentTypes();
            return list;
        }
        finally {
            tracer.endGroup(DEPENDENCY_PHASE, this.getErrors());
        }
    }

    private BaseTypeVisitor createVisitor(JstType type) {
        if (this.getMode().hasDeclaration()) {
            return new TypeDnDVisitor(type);
        }
        return new TypeDependencyVisitor(type);
    }
}

