/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.parse;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.vjet.dsf.javatojs.parse.BaseTypeVisitor;
import org.eclipse.vjet.dsf.javatojs.translate.DataTypeTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.stmt.JstBlockInitializer;

public class TypeDependencyVisitor
extends BaseTypeVisitor {
    public TypeDependencyVisitor(JstType type) {
        super(type, new TranslationMode().addDependency());
    }

    protected TypeDependencyVisitor(JstType type, TranslationMode mode) {
        super(type, mode);
    }

    @Override
    public void postVisit(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            this.removeCurBlock();
            this.removeCurMtd();
        } else if (node instanceof Initializer) {
            this.removeCurBlock();
        } else if (node instanceof WhileStatement || node instanceof DoStatement || node instanceof IfStatement || node instanceof SwitchStatement || node instanceof ForStatement || node instanceof EnhancedForStatement || node instanceof TryStatement || node instanceof SynchronizedStatement) {
            this.removeCurBlock();
        }
        super.postVisit(node);
    }

    public boolean visit(PackageDeclaration pkg) {
        return false;
    }

    public boolean visit(QualifiedName node) {
        JstType jstType;
        if (node.getParent() instanceof MethodDeclaration) {
            return false;
        }
        String name = node.getFullyQualifiedName();
        if (this.hasDependency(name, true)) {
            return false;
        }
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(this.getCurType().getRootType());
        QualifiedName qualifier = node;
        JstCache jstCache = JstCache.getInstance();
        while (true) {
            String typeName;
            if (tInfo.getType(typeName = qualifier.toString(), true) != null) {
                return false;
            }
            jstType = jstCache.getType(typeName);
            if (jstType != null) {
                tInfo.setType(typeName, (IJstType)jstType);
                return false;
            }
            jstType = this.getCtx().getProvider().getCustomTranslator().processType(typeName, (ASTNode)node, this.getCurScope());
            if (jstType != null) {
                tInfo.setType(typeName, (IJstType)jstType);
                return false;
            }
            if (qualifier instanceof SimpleName) break;
            qualifier = qualifier.getQualifier();
        }
        qualifier = node;
        SimpleName simpleQualifier = null;
        while (true) {
            String qName;
            if (TranslateHelper.Type.isFullyQualifiedTypeName(qName = qualifier.toString())) {
                jstType = this.getCtx().getProvider().getCustomTranslator().processType(qName, (ASTNode)node, (BaseJstNode)this.getCurType());
                if (jstType == null) {
                    jstType = JstCache.getInstance().getType(this.getCtx().getConfig().getPackageMapping().mapTo(qName), true);
                }
                this.getCtx().getTranslateInfo(this.getCurType()).setType(qName, (IJstType)jstType);
                this.addDependency((IJstType)jstType, (ASTNode)qualifier);
                return false;
            }
            if (qualifier instanceof SimpleName) break;
            qualifier = qualifier.getQualifier();
        }
        simpleQualifier = (SimpleName)qualifier;
        String simpleName = simpleQualifier.toString();
        String fullName = tInfo.getImported(simpleName);
        if (fullName == null) {
            fullName = TranslateHelper.Type.resolveImplicitImport(simpleName, this.getCurType());
        }
        if (fullName != null) {
            jstType = this.getCtx().getProvider().getCustomTranslator().processType(fullName, (ASTNode)node, this.getCurScope());
            if (jstType == null) {
                fullName = this.getCtx().getConfig().getPackageMapping().mapTo(fullName);
                jstType = JstCache.getInstance().getType(fullName, true);
            }
            tInfo.setType(simpleName, (IJstType)jstType);
            this.addDependency((IJstType)jstType, (ASTNode)simpleQualifier);
            return false;
        }
        return false;
    }

    public boolean visit(SimpleType node) {
        ASTNode parent = node.getParent();
        if (parent instanceof MethodDeclaration || parent instanceof ClassInstanceCreation) {
            return false;
        }
        String name = node.toString();
        if (this.hasDependency(name, true)) {
            return false;
        }
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(this.getCurType());
        IJstType jstType = this.getCtx().getProvider().getDataTypeTranslator().processType((Type)node, (BaseJstNode)(this.getCurMtd() != null ? this.getCurMtd() : this.getCurType()));
        if (jstType != null) {
            tInfo.setType(name, jstType);
            this.addDependency(jstType, (ASTNode)node);
        }
        return false;
    }

    public boolean visit(SimpleName node) {
        if (node.getParent() instanceof MethodDeclaration) {
            return false;
        }
        String name = node.getFullyQualifiedName();
        if (this.hasDependency(name, true)) {
            return false;
        }
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(this.getCurType());
        String typeName = tInfo.getImportedStaticRefTypeName(name);
        if (typeName != null) {
            typeName = this.getCtx().getConfig().getPackageMapping().mapTo(typeName);
            JstType jstType = JstFactory.getInstance().createJstType(typeName, false);
            tInfo.setType(jstType.getSimpleName(), (IJstType)jstType);
            this.addDependency((IJstType)jstType, null);
        }
        return false;
    }

    public boolean visit(TypeLiteral node) {
        IJstType jstType = this.getCtx().getProvider().getDataTypeTranslator().processType(node.getType(), (BaseJstNode)(this.getCurMtd() != null ? this.getCurMtd() : this.getCurType()));
        this.addDependency(jstType, (ASTNode)node.getType());
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration astMtd) {
        boolean visitChildren = super.visit(astMtd);
        JstMethod jstMtd = this.getCurMtd();
        if (jstMtd == null) {
            return false;
        }
        this.getCurType().addChild((IJstNode)jstMtd);
        return visitChildren;
    }

    public boolean visit(VariableDeclarationExpression astExpr) {
        this.visitVarDecl((ASTNode)astExpr, astExpr.getType(), astExpr.fragments());
        return true;
    }

    public boolean visit(VariableDeclarationStatement astStmt) {
        this.visitVarDecl((ASTNode)astStmt, astStmt.getType(), astStmt.fragments());
        return true;
    }

    public boolean visit(SingleVariableDeclaration astNode) {
        IJstType varType = this.getCtx().getProvider().getDataTypeTranslator().processType(astNode.getType(), this.getCurrentDeclaration());
        if (astNode.getExtraDimensions() > 0) {
            int i = 0;
            while (i < astNode.getExtraDimensions()) {
                varType = JstFactory.getInstance().createJstArrayType(varType, true);
                ++i;
            }
        }
        if (astNode.isVarargs()) {
            varType = JstFactory.getInstance().createJstArrayType(varType, true);
        }
        JstBlock curBlock = this.getCurBlock();
        if (varType == null || curBlock == null) {
            return false;
        }
        curBlock.getVarTable().addVarType(this.getCtx().getProvider().getNameTranslator().processVarName(astNode.getName(), (BaseJstNode)curBlock), varType);
        this.addDependency(varType, (ASTNode)astNode.getType());
        return true;
    }

    public boolean visit(MethodInvocation astNode) {
        DataTypeTranslator dataTypeTranslator = this.getCtx().getProvider().getDataTypeTranslator();
        Expression expr = astNode.getExpression();
        String typeName = null;
        IJstType jstType = null;
        if (expr instanceof SimpleName) {
            typeName = expr.toString();
            if (this.isVar(typeName)) {
                return true;
            }
            if (this.isPtyOrEnum(typeName)) {
                return true;
            }
            jstType = dataTypeTranslator.processName((Name)expr, (BaseJstNode)this.getCurType());
            this.addDependency(jstType, (ASTNode)expr);
        } else if (expr instanceof ClassInstanceCreation) {
            typeName = ((ClassInstanceCreation)expr).getType().toString();
            jstType = this.getCtx().getProvider().getDataTypeTranslator().processType(((ClassInstanceCreation)expr).getType(), this.getCurrentDeclaration());
            this.addDependency(jstType, (ASTNode)((ClassInstanceCreation)expr).getType());
        }
        if (jstType != null) {
            this.getCtx().getTranslateInfo(this.getCurType()).setType(typeName, jstType);
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        JstType jstType = TranslateHelper.Factory.createJstType((ASTNode)node, (IJstNode)this.getCurType());
        this.getCurScope().addChild((IJstNode)jstType);
        this.setCurType(jstType);
        this.getCtx().getTranslateInfo(jstType.getRootType()).addAnonymousType(node, jstType);
        return true;
    }

    public boolean visit(TypeDeclarationStatement node) {
        String typeName = node.getDeclaration().getName().getFullyQualifiedName();
        JstType jstType = TranslateHelper.Factory.createJstType((ASTNode)node, (IJstNode)this.getCurType());
        jstType.setSimpleName(typeName);
        jstType.setParent((IJstNode)this.getScopeParent());
        this.getCurScope().addChild((IJstNode)jstType);
        this.setCurType(jstType);
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        ClassInstanceCreation cic;
        if (node.getExpression() != null) {
            this.getCtx().getTranslateInfo(this.getCurType()).addEmbededType(node.getType().toString());
        }
        if ((cic = node).getExpression() == null) {
            IJstType objType = this.getCtx().getProvider().getDataTypeTranslator().processType(cic.getType(), this.getCurrentDeclaration());
            this.addDependency(objType, (ASTNode)cic.getType());
        }
        return true;
    }

    public boolean visit(Initializer initializer) {
        if (this.skipImpl()) {
            return false;
        }
        JstType ownerType = this.getCurType();
        JstBlockInitializer jstBlock = new JstBlockInitializer(Modifier.isStatic((int)initializer.getModifiers()));
        ownerType.addChild((IJstNode)jstBlock);
        this.getCtx().getTranslateInfo(ownerType).addInitializer(initializer, jstBlock);
        this.setCurBlock(jstBlock.getBody());
        return true;
    }

    public boolean visit(WhileStatement astStmt) {
        return this.visitBlockStmt((Statement)astStmt);
    }

    public boolean visit(DoStatement astStmt) {
        return this.visitBlockStmt((Statement)astStmt);
    }

    public boolean visit(IfStatement astStmt) {
        return this.visitBlockStmt((Statement)astStmt);
    }

    public boolean visit(SwitchStatement astStmt) {
        return this.visitBlockStmt((Statement)astStmt);
    }

    public boolean visit(ForStatement astStmt) {
        return this.visitBlockStmt((Statement)astStmt);
    }

    public boolean visit(EnhancedForStatement astStmt) {
        return this.visitBlockStmt((Statement)astStmt);
    }

    public boolean visit(TryStatement astStmt) {
        return this.visitBlockStmt((Statement)astStmt);
    }

    public boolean visit(SynchronizedStatement astStmt) {
        return this.visitBlockStmt((Statement)astStmt);
    }

    private boolean visitBlockStmt(Statement astStmt) {
        JstBlock curBlock = this.getCurBlock();
        if (curBlock == null) {
            return false;
        }
        BlockStmt blockStmt = (BlockStmt)this.getCtx().getProvider().getStmtTranslator().processStatement(astStmt, (BaseJstNode)curBlock);
        this.setCurBlock(blockStmt.getBody());
        return true;
    }

    private boolean visitVarDecl(ASTNode astNode, Type type, List fragments) {
        IJstType varType = this.getCtx().getProvider().getDataTypeTranslator().processType(type, this.getCurrentDeclaration());
        JstBlock curBlock = this.getCurBlock();
        if (varType == null || curBlock == null) {
            return false;
        }
        VarTable varTable = curBlock.getVarTable();
        for (Object o : fragments) {
            if (o instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment f = (VariableDeclarationFragment)o;
                varTable.addVarType(this.getCtx().getProvider().getNameTranslator().processVarName(f.getName(), (BaseJstNode)curBlock), varType);
                continue;
            }
            this.getCtx().getLogger().logUnhandledNode(this, astNode, (BaseJstNode)curBlock);
        }
        this.addDependency(varType, (ASTNode)type);
        return true;
    }

    private boolean isVar(String name) {
        BaseJstNode scopeNode = this.getCurScope();
        String varName = this.getCtx().getProvider().getNameTranslator().processVarName(name);
        if (TranslateHelper.Type.getVarType(varName, (IJstNode)scopeNode) != null) {
            return true;
        }
        JstMethod curMtd = this.getCurMtd();
        if (curMtd == null) {
            return false;
        }
        JstBlock block = curMtd.getBlock(false);
        if (block != null) {
            return TranslateHelper.Type.getVarType(name, (IJstNode)block) != null;
        }
        return false;
    }

    private boolean isPtyOrEnum(String name) {
        JstType jstType = this.getCurType();
        if (jstType.getProperty(name) != null) {
            return true;
        }
        return jstType.getEnumValue(name) != null;
    }
}

