/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.prebuild;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Task;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class BaseBuildTask
extends Task {
    public static final String JAVA_SUFFIX = ".java";
    public static final String JSR_SUFFIX = "Jsr.java";

    protected void getBuildFiles(File dir, List<URL> list, final String pkgNamesStr, final String excludePkg, final boolean debug) {
        File[] subDirs;
        int n;
        if (dir == null) {
            throw new RuntimeException("dir is null");
        }
        if (!dir.exists()) {
            throw new RuntimeException("dir " + dir.getAbsolutePath() + " doesn't exist");
        }
        File[] j2jFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String[] pkgNames;
                if (!name.endsWith(BaseBuildTask.JAVA_SUFFIX) || name.endsWith(BaseBuildTask.JSR_SUFFIX) || pkgNamesStr == null) {
                    return false;
                }
                String[] stringArray = pkgNames = pkgNamesStr.split(",");
                int n = pkgNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String pkgName = stringArray[n2];
                    String subdir = pkgName.replace(".", File.separator);
                    if (excludePkg != null) {
                        String excludeSubDir = excludePkg.replace(".", File.separator);
                        if (dir.getPath().contains(excludeSubDir)) {
                            return false;
                        }
                    }
                    if (dir.getPath().contains(String.valueOf(File.separator) + subdir + File.separator) || dir.getPath().endsWith(String.valueOf(File.separator) + subdir)) {
                        if (debug) {
                            System.out.println("Accept: " + dir.toString() + File.separator + name);
                        }
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        if (j2jFiles != null) {
            File[] fileArray = j2jFiles;
            n = j2jFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    list.add(f.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println("Malformed resource URL for file : " + f);
                }
                ++n2;
            }
        }
        File[] fileArray = subDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int n3 = subDirs.length;
        n = 0;
        while (n < n3) {
            File subDir = fileArray[n];
            this.getBuildFiles(subDir, list, pkgNamesStr, excludePkg, debug);
            ++n;
        }
    }

    protected static File[] parseSourceDirs(String srcDirs, String projRoot) {
        String[] sources = srcDirs.split(File.pathSeparator);
        File[] dirs = new File[sources.length];
        int count = 0;
        String[] stringArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            String source;
            String sourceFile = source = stringArray[n2];
            if (source.indexOf(projRoot) == -1) {
                sourceFile = String.valueOf(projRoot) + File.separatorChar + source;
            }
            dirs[count] = new File(sourceFile);
            ++count;
            ++n2;
        }
        return dirs;
    }

    protected void dump(List<JstType> jstTypes) {
        for (JstType jstType : jstTypes) {
            JstArg arg;
            Iterator iter;
            JstArg arg2;
            Z z = new Z();
            z.format((Object)">> JstType");
            z.format("name", (Object)jstType.getName());
            if (!jstType.getAnnotations().isEmpty()) {
                z.format("annotations", (Object)jstType.getAnnotations());
            }
            z.format("extends", (Object)jstType.getExtends());
            z.format((Object)"static props:");
            for (IJstProperty p : jstType.getAllPossibleProperties(true, true)) {
                if (!p.getAnnotations().isEmpty()) {
                    z.format("\tprops-annotations", (Object)p.getAnnotations());
                }
                z.append((Object)("\t" + p.getModifiers().toString()));
                z.append((Object)(" " + p.getType().getName()));
                z.append((Object)(" " + p.getName()));
                z.format((Object)";");
            }
            z.format((Object)"instance props:");
            for (IJstProperty p : jstType.getAllPossibleProperties(false, true)) {
                if (!p.getAnnotations().isEmpty()) {
                    z.format("\tprops-annotations", (Object)p.getAnnotations());
                }
                z.append((Object)("\t" + p.getModifiers().toString()));
                z.append((Object)(" " + p.getType().getName()));
                z.append((Object)(" " + p.getName()));
                z.format((Object)";");
            }
            JstMethod cons = jstType.getConstructor();
            if (cons != null) {
                z.format((Object)"constructor:");
                z.append((Object)("\t" + cons.getModifiers().toString()));
                z.append((Object)(" " + cons.getName()));
                z.append((Object)"(");
                Iterator iter2 = cons.getArgs().iterator();
                while (iter2.hasNext()) {
                    JstArg arg3 = (JstArg)iter2.next();
                    z.append((Object)arg3.getType().getName());
                    z.append((Object)(" " + arg3.getName()));
                    if (!iter2.hasNext()) continue;
                    z.append((Object)", ");
                }
                z.format((Object)");");
                for (IJstMethod over : cons.getOverloaded()) {
                    z.format((Object)"overloaded-constructor:");
                    z.append((Object)("\t" + over.getModifiers().toString()));
                    z.append((Object)(" " + over.getName()));
                    z.append((Object)"(");
                    iter2 = over.getArgs().iterator();
                    while (iter2.hasNext()) {
                        arg2 = (JstArg)iter2.next();
                        z.append((Object)arg2.getType().getName());
                        z.append((Object)(" " + arg2.getName()));
                        if (!iter2.hasNext()) continue;
                        z.append((Object)", ");
                    }
                    z.format((Object)");");
                }
            }
            z.format((Object)"static methods:");
            for (IJstMethod m : jstType.getMethods(true, true)) {
                if (!m.getAnnotations().isEmpty()) {
                    z.format("\tmtd-annotations", (Object)m.getAnnotations());
                }
                z.append((Object)("\t" + m.getModifiers().toString() + " "));
                if (m.getRtnType() != null) {
                    z.append((Object)m.getRtnType().getName());
                    z.append((Object)" ");
                }
                z.append((Object)m.getName());
                z.append((Object)"(");
                iter = m.getArgs().iterator();
                while (iter.hasNext()) {
                    arg2 = (JstArg)iter.next();
                    z.append((Object)arg2.getType().getName());
                    z.append((Object)(" " + (arg2.isVariable() ? "..." : "") + arg2.getName()));
                    if (!iter.hasNext()) continue;
                    z.append((Object)", ");
                }
                z.format((Object)");");
                for (IJstMethod over : m.getOverloaded()) {
                    z.format((Object)"overloaded-method:");
                    z.append((Object)("\t" + over.getModifiers().toString()));
                    if (over.getRtnType() != null) {
                        z.append((Object)" ");
                        z.append((Object)over.getRtnType().getName());
                        z.append((Object)" ");
                    }
                    z.append((Object)(" " + over.getName()));
                    z.append((Object)"(");
                    iter = over.getArgs().iterator();
                    while (iter.hasNext()) {
                        arg = (JstArg)iter.next();
                        z.append((Object)arg.getType().getName());
                        z.append((Object)(" " + arg.getName()));
                        if (!iter.hasNext()) continue;
                        z.append((Object)", ");
                    }
                    z.format((Object)");");
                }
            }
            z.format((Object)"instance methods:");
            for (IJstMethod m : jstType.getMethods(false, true)) {
                if (!m.getAnnotations().isEmpty()) {
                    z.format("\tmtd-annotations", (Object)m.getAnnotations());
                }
                z.append((Object)("\t" + m.getModifiers().toString() + " "));
                if (m.getRtnType() != null) {
                    z.append((Object)m.getRtnType().getName());
                    z.append((Object)" ");
                }
                z.append((Object)m.getName());
                z.append((Object)"(");
                iter = m.getArgs().iterator();
                while (iter.hasNext()) {
                    arg2 = (JstArg)iter.next();
                    z.append((Object)arg2.getType().getName());
                    z.append((Object)(" " + (arg2.isVariable() ? "..." : "") + arg2.getName()));
                    if (!iter.hasNext()) continue;
                    z.append((Object)", ");
                }
                z.format((Object)");");
                for (IJstMethod over : m.getOverloaded()) {
                    z.format((Object)"overloaded-method:");
                    z.append((Object)("\t" + over.getModifiers().toString()));
                    if (over.getRtnType() != null) {
                        z.append((Object)" ");
                        z.append((Object)over.getRtnType().getName());
                        z.append((Object)" ");
                    }
                    z.append((Object)(" " + over.getName()));
                    z.append((Object)"(");
                    iter = over.getArgs().iterator();
                    while (iter.hasNext()) {
                        arg = (JstArg)iter.next();
                        z.append((Object)arg.getType().getName());
                        z.append((Object)(" " + arg.getName()));
                        if (!iter.hasNext()) continue;
                        z.append((Object)", ");
                    }
                    z.format((Object)");");
                }
            }
            System.out.println(z);
        }
    }
}

