/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.trace;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.vjet.dsf.common.trace.ITraceData;

public class TraceTime
implements ITraceData {
    static final TraceTime NO_OP_TIMER = new NoOpTimer();
    private static String TIME_FORMAT = "HH:mm:ss:SSS";
    private static String NULL = "null";
    private Date m_start;
    private Date m_end;

    TraceTime() {
    }

    public void start() {
        this.m_start = new Date();
    }

    public void end() {
        this.m_end = new Date();
    }

    public String getStartTime() {
        if (this.m_start == null) {
            return NULL;
        }
        return TraceTime.formatTime(this.m_start);
    }

    public String getEndTime() {
        if (this.m_end == null) {
            return NULL;
        }
        return TraceTime.formatTime(this.m_end);
    }

    public String getDuration() {
        if (this.m_end == null || this.m_start == null) {
            return NULL;
        }
        return String.valueOf(this.m_end.getTime() - this.m_start.getTime());
    }

    private static String formatTime(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
        return formatter.format(date);
    }

    private static class NoOpTimer
    extends TraceTime {
        private NoOpTimer() {
        }

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }

        @Override
        public String getStartTime() {
            return null;
        }

        @Override
        public String getEndTime() {
            return null;
        }

        @Override
        public String getDuration() {
            return null;
        }
    }
}

