/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.JstSource;

public class AstBinding
implements JstSource.IBinding {
    private URL m_pkgPath;
    private String m_pkgName;
    private String m_clsName;
    private ASTNode m_astNode;
    private Map<String, String> m_interfaces;

    public AstBinding(URL pkgPath, String pkgName, String clsName, ASTNode astNode) {
        assert (pkgPath != null) : "pkgPath cannot be null";
        assert (pkgName != null) : "pkgName cannot be null";
        assert (clsName != null) : "clsName cannot be null";
        assert (astNode != null) : "astNode cannot be null";
        this.m_pkgPath = pkgPath;
        this.m_pkgName = pkgName;
        this.m_clsName = clsName;
        this.m_astNode = astNode;
    }

    public AstBinding(ASTNode astNode) {
        assert (astNode != null) : "astNode cannot be null";
        this.m_astNode = astNode;
    }

    public String getName() {
        if (this.m_astNode instanceof CompilationUnit) {
            return this.m_pkgName == null ? this.m_clsName : String.valueOf(this.m_pkgName) + "." + this.m_clsName;
        }
        if (this.m_astNode instanceof TypeDeclaration) {
            return ((TypeDeclaration)this.m_astNode).getName().toString();
        }
        return null;
    }

    public String toText() {
        return this.m_astNode.toString();
    }

    public URL getPkgPath() {
        return this.m_pkgPath;
    }

    public String getPkgName() {
        return this.m_pkgName;
    }

    public String getClassName() {
        return this.m_clsName;
    }

    public ASTNode getAstNode() {
        return this.m_astNode;
    }

    public synchronized void addInterfaceName(String key, String fullName) {
        if (this.m_interfaces == null) {
            this.m_interfaces = new LinkedHashMap<String, String>();
        }
        this.m_interfaces.put(key, fullName);
    }

    public synchronized Map<String, String> getInterfaceNames() {
        if (this.m_interfaces == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_interfaces);
    }

    public String toString() {
        Z z = new Z();
        z.format("m_pkgPath", (Object)this.m_pkgPath);
        z.format("m_pkgName", (Object)this.m_pkgName);
        z.format("m_clsName", (Object)this.m_clsName);
        z.format("m_astNode", (Object)this.m_astNode.getClass().getName());
        return z.toString();
    }
}

