/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class NameTranslator
extends BaseTranslator {
    public String processVarName(SimpleName astName, BaseJstNode jstNode) {
        return this.processVarName(astName.toString());
    }

    public String processVarName(String varName) {
        String name = varName;
        if (JsCoreKeywords.isReservedKeyword((String)name)) {
            name = String.valueOf(name) + this.getCtx().getConfig().getVjoConvention().getSurfixReservedWord();
            return name;
        }
        return name;
    }

    public JstIdentifier processName(Name astName, boolean skipCustomTranslation, BaseJstNode jstNode) {
        return this.processName(astName, false, false, null, skipCustomTranslation, jstNode);
    }

    public JstIdentifier processName(Name astName, IExpr qualifierExpr, boolean skipCustomTranslation, BaseJstNode jstNode) {
        return this.processName(astName, false, false, qualifierExpr, skipCustomTranslation, jstNode);
    }

    public JstIdentifier processName(Name astName, boolean hasSuper, boolean hasThis, IExpr qualifierExpr, boolean skipCustomTranslation, BaseJstNode jstNode) {
        JstIdentifier jstIdentifier = null;
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstNode.getOwnerType());
        if (!skipCustomTranslation) {
            jstIdentifier = this.processName(astName, hasSuper, hasThis, qualifierExpr, true, jstNode);
            JstIdentifier customized = this.getCustomTranslator().processIdentifier(astName, hasSuper, hasThis, qualifierExpr, jstIdentifier, jstNode);
            if (customized != null) {
                return customized;
            }
            return jstIdentifier;
        }
        if (astName instanceof QualifiedName) {
            String name = astName.getFullyQualifiedName();
            IJstType jstType = tInfo.getType(name, false);
            if (jstType != null) {
                jstIdentifier = new JstIdentifier(name);
                jstIdentifier.setJstBinding((IJstNode)jstType);
                jstIdentifier.setType(jstType);
                TranslateHelper.Type.validateTypeReference(jstType, (ASTNode)astName, (BaseJstNode)jstIdentifier, jstNode, this);
                return jstIdentifier;
            }
            QualifiedName qn = (QualifiedName)astName;
            JstIdentifier jstQualifier = this.processName(qn.getQualifier(), qualifierExpr, skipCustomTranslation, jstNode);
            if (jstQualifier == null) {
                return this.processName((Name)qn.getName(), qualifierExpr, skipCustomTranslation, jstNode);
            }
            jstIdentifier = this.processName((Name)qn.getName(), (IExpr)jstQualifier, skipCustomTranslation, jstNode);
            if (jstIdentifier.getQualifier() == null) {
                this.setNameQualifier(jstIdentifier, jstQualifier, jstNode);
                this.setNameIdentifierType(jstIdentifier, (BaseJstNode)jstQualifier);
            }
            return jstIdentifier;
        }
        if (astName instanceof SimpleName) {
            String name = this.processVarName(astName.toString());
            if (qualifierExpr == null && !hasThis && !hasSuper) {
                IJstType varType = TranslateHelper.Type.getLocalVarType(name, (IJstNode)jstNode);
                if (varType != null) {
                    jstIdentifier = new JstIdentifier(name);
                    this.setNameIdentifierType(jstIdentifier, jstNode);
                    return jstIdentifier;
                }
                String typeName = this.getCtx().getTranslateInfo(jstNode.getRootType()).getImportedStaticRefTypeName(name);
                typeName = this.getCtx().getConfig().getPackageMapping().mapTo(typeName);
                IJstType refType = this.getDataTypeTranslator().findJstType(typeName, jstNode);
                if (refType != null) {
                    jstIdentifier = new JstIdentifier(name);
                    jstIdentifier.setQualifier(VjoTranslateHelper.getStaticMemberQualifier(refType, jstNode));
                    IJstProperty pty = TranslateHelper.Property.getProperty(refType, name);
                    if (pty != null) {
                        jstIdentifier.setJstBinding((IJstNode)pty);
                        jstIdentifier.setType(pty.getType());
                    }
                    TranslateHelper.Type.validateTypeReference(refType, (ASTNode)astName, (BaseJstNode)jstIdentifier, jstNode, this);
                    return jstIdentifier;
                }
            }
            if ((jstIdentifier = this.getEnumConstIdentifier(name, hasSuper, hasThis, qualifierExpr, jstNode)) != null) {
                return jstIdentifier;
            }
            jstIdentifier = this.getTypeIndentifier(name, astName, hasSuper, hasThis, qualifierExpr, jstNode);
            if (jstIdentifier != null) {
                return jstIdentifier;
            }
            jstIdentifier = this.getPropertyIdentifier(astName, hasSuper, hasThis, qualifierExpr, jstNode);
            if (jstIdentifier != null) {
                return jstIdentifier;
            }
            return null;
        }
        this.getLogger().logUnhandledNode(this, (ASTNode)astName, jstNode);
        return null;
    }

    public JstIdentifier processMtdName(Name astName, List<IExpr> args, IExpr qualifierExpr, BaseJstNode jstNode) {
        return this.processMtdName(astName, args, true, false, qualifierExpr, jstNode);
    }

    public JstIdentifier processMtdName(Name astName, List<IExpr> args, boolean needSuper, boolean needThis, IExpr qualifierExpr, BaseJstNode jstNode) {
        if (astName instanceof SimpleName) {
            String mtdName = this.processVarName(astName.toString());
            if (jstNode.getOwnerType() instanceof JstType) {
                String typeName = this.getCtx().getTranslateInfo(jstNode.getRootType()).getImportedStaticRefTypeName(mtdName);
                typeName = this.getCtx().getConfig().getPackageMapping().mapTo(typeName);
                IJstType refType = this.getDataTypeTranslator().findJstType(typeName, jstNode);
                if (refType != null) {
                    JstIdentifier jstIdentifier = new JstIdentifier(mtdName);
                    jstIdentifier.setQualifier(VjoTranslateHelper.getStaticMemberQualifier(refType, jstNode));
                    IJstMethod mtd = TranslateHelper.Method.getMethod(astName.getParent(), refType, mtdName, args);
                    if (mtd != null) {
                        jstIdentifier.setJstBinding((IJstNode)mtd);
                        jstIdentifier.setType(mtd.getRtnType());
                    }
                    return jstIdentifier;
                }
            }
            return this.getMethodIdentifier(astName, args, needSuper, needThis, qualifierExpr, jstNode);
        }
        if (astName instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)astName;
            JstIdentifier qualifier = this.processMtdName(qn.getQualifier(), args, needSuper, needThis, qualifierExpr, jstNode);
            JstIdentifier identifier = this.processMtdName((Name)qn.getName(), args, needSuper, needThis, qualifierExpr, jstNode);
            if (identifier != null && qualifier != null) {
                identifier.setQualifier(qualifier);
                this.setMtdIdentifierType(identifier, (IJstNode)qualifier);
            }
            return identifier;
        }
        this.getLogger().logUnhandledNode(this, (ASTNode)astName, jstNode);
        return null;
    }

    private JstIdentifier getTypeIndentifier(String name, Name astName, boolean needSuper, boolean needThis, IExpr qualifierExpr, BaseJstNode jstNode) {
        JstType ownerType = jstNode.getOwnerType();
        JstIdentifier jstIdentifier = null;
        JstIdentifier jstQualifier = null;
        if (qualifierExpr != null) {
            IJstType qualifierType = qualifierExpr.getResultType();
            if (qualifierType != null) {
                if (qualifierType.getEmbededType(name) != null) {
                    IJstType embededType = qualifierType.getEmbededType(name);
                    jstQualifier = VjoTranslateHelper.getStaticTypeQualifier(embededType, jstNode, true);
                    jstIdentifier = new JstIdentifier(name);
                    jstIdentifier.setJstBinding((IJstNode)embededType);
                    jstIdentifier.setType(embededType);
                    if (qualifierType instanceof JstType) {
                        TranslateHelper.Type.validateEmbeddedTypeReference((ASTNode)astName, (JstType)qualifierType, name, jstNode, jstNode, this);
                    }
                }
                return jstIdentifier;
            }
        } else {
            if (name.equals(ownerType.getSimpleName()) || name.equals(ownerType.getName())) {
                jstIdentifier = jstQualifier = VjoTranslateHelper.getStaticTypeQualifier((IJstType)ownerType, jstNode, true);
                jstIdentifier.setJstBinding((IJstNode)ownerType);
                jstIdentifier.setType((IJstType)ownerType);
                return jstIdentifier;
            }
            if (ownerType.getOuterType() != null && (name.equals(ownerType.getOuterType().getSimpleName()) || name.equals(ownerType.getOuterType().getName()))) {
                jstIdentifier = new JstIdentifier(this.getCtx().getConfig().getVjoConvention().getOuterStaticPrefix());
                jstIdentifier.setJstBinding((IJstNode)ownerType.getOuterType());
                jstIdentifier.setType((IJstType)ownerType.getOuterType());
                return jstIdentifier;
            }
            if (ownerType.getEmbededType(name) != null) {
                JstType embededType = ownerType.getEmbededType(name);
                jstQualifier = VjoTranslateHelper.getStaticTypeQualifier((IJstType)embededType, jstNode, true);
                jstIdentifier = new JstIdentifier(name, jstQualifier);
                jstIdentifier.setJstBinding((IJstNode)embededType);
                jstIdentifier.setType((IJstType)embededType);
                return jstIdentifier;
            }
            IJstType type = this.getDataTypeTranslator().findJstType(name, (BaseJstNode)ownerType);
            if (type != null && type.getPackage() != null) {
                jstIdentifier = TranslateHelper.Type.createIdentifier(type, jstNode);
                jstIdentifier.setJstBinding((IJstNode)type);
                jstIdentifier.setType(type);
                TranslateHelper.Type.validateTypeReference(type, (ASTNode)astName, (BaseJstNode)jstIdentifier, jstNode, this);
                return jstIdentifier;
            }
        }
        return null;
    }

    private JstIdentifier getEnumConstIdentifier(String name, boolean needSuper, boolean hasThis, IExpr qualifierExpr, BaseJstNode jstNode) {
        JstType ownerType;
        IJstProperty jstPty = null;
        JstType scopeType = ownerType = jstNode.getOwnerType();
        if (qualifierExpr != null && qualifierExpr.getResultType() != null) {
            scopeType = qualifierExpr.getResultType();
        }
        if (!scopeType.isEnum()) {
            return null;
        }
        jstPty = scopeType.getEnumValue(name);
        if (jstPty == null) {
            return null;
        }
        JstIdentifier jstIdentifier = new JstIdentifier(name);
        jstIdentifier.setType(jstPty.getType());
        jstIdentifier.setJstBinding((IJstNode)jstPty);
        JstIdentifier jstQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(jstIdentifier, jstNode);
        this.setNameQualifier(jstIdentifier, jstQualifier, jstNode);
        this.setNameIdentifierType(jstIdentifier, jstNode);
        return jstIdentifier;
    }

    private JstIdentifier getPropertyIdentifier(Name astName, boolean hasSuper, boolean hasThis, IExpr qualifierExpr, BaseJstNode jstNode) {
        JstType ownerType;
        String name = this.processVarName(astName.toString());
        IJstProperty jstPty = null;
        VjoConvention convension = this.getCtx().getConfig().getVjoConvention();
        JstIdentifier jstIdentifier = new JstIdentifier(name);
        JstIdentifier jstQualifier = null;
        JstType scopeType = ownerType = jstNode.getOwnerType();
        if (qualifierExpr != null && qualifierExpr.getResultType() != null) {
            scopeType = qualifierExpr.getResultType();
        }
        if (scopeType instanceof JstType) {
            TranslateHelper.Property.validateFieldReference(astName, jstNode, (BaseJstNode)scopeType, this);
        }
        boolean isMember = false;
        boolean isInherited = false;
        boolean isOuters = false;
        if (hasSuper) {
            jstPty = scopeType.getExtend().getStaticProperty(name, true);
            if (jstPty == null) {
                jstPty = scopeType.getExtend().getInstanceProperty(name, true);
            }
            if (jstPty != null) {
                isInherited = true;
            }
        } else {
            jstPty = scopeType.getInstanceProperty(name, false);
            if (jstPty == null) {
                jstPty = scopeType.getStaticProperty(name, false);
            }
            if (jstPty == null && (jstPty = scopeType.getInstanceProperty(name, true)) == null) {
                jstPty = scopeType.getStaticProperty(name, true);
            }
            if (jstPty != null) {
                if (jstPty.getOwnerType() == scopeType) {
                    isMember = true;
                } else {
                    isInherited = true;
                }
            }
        }
        if (jstPty == null) {
            IJstType outerType = NameTranslator.getContainingType((IJstType)scopeType);
            while (outerType != null) {
                jstPty = outerType.getStaticProperty(name, true);
                if (jstPty == null) {
                    jstPty = outerType.getInstanceProperty(name, true);
                }
                if (jstPty != null) {
                    isOuters = true;
                    break;
                }
                outerType = NameTranslator.getContainingType(outerType);
            }
        }
        if (jstPty != null) {
            jstIdentifier.setJstBinding((IJstNode)jstPty);
            jstIdentifier.setType(jstPty.getType());
            if (this.needReCalcQualifier(qualifierExpr, jstPty.isStatic())) {
                if (isMember) {
                    if (jstPty.getModifiers().isStatic()) {
                        jstQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(jstIdentifier, jstNode);
                    } else {
                        jstQualifier = new JstIdentifier(VjoConvention.getThisPrefix());
                        jstQualifier.setJstBinding((IJstNode)ownerType);
                        jstQualifier.setType((IJstType)ownerType);
                    }
                } else if (isInherited) {
                    if (jstPty.getModifiers().isStatic()) {
                        jstQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(jstIdentifier, jstNode);
                    } else if (qualifierExpr == null) {
                        jstQualifier = new JstIdentifier(VjoConvention.getThisPrefix());
                    }
                    if (jstQualifier != null) {
                        IJstType binding = jstPty.getOwnerType();
                        jstQualifier.setJstBinding((IJstNode)binding);
                        jstQualifier.setType(binding);
                        if (binding != null && !ownerType.getRootType().getImportsMap().values().contains(binding)) {
                            this.getDataTypeTranslator().addImport(binding, ownerType, binding.getSimpleName());
                        }
                    }
                } else if (isOuters) {
                    if (jstPty.getModifiers().isStatic()) {
                        jstQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(jstIdentifier, jstNode);
                    } else if (qualifierExpr == null) {
                        jstQualifier = VjoTranslateHelper.getInstanceMemberQualifier(jstPty.getOwnerType(), (IJstNode)jstNode);
                    }
                    if (jstQualifier != null) {
                        jstQualifier.setJstBinding((IJstNode)jstPty.getOwnerType());
                        jstQualifier.setType(jstPty.getOwnerType());
                    }
                }
                this.setNameQualifier(jstIdentifier, jstQualifier, jstNode);
            }
        }
        this.setNameIdentifierType(jstIdentifier, jstNode);
        return jstIdentifier;
    }

    private JstIdentifier getMethodIdentifier(Name astName, List<IExpr> args, boolean hasSuper, boolean hasThis, IExpr qualifierExpr, BaseJstNode jstNode) {
        JstType ownerType;
        String name = this.processVarName(astName.toString());
        VjoConvention convension = this.getCtx().getConfig().getVjoConvention();
        JstType scopeType = ownerType = jstNode.getOwnerType();
        if (qualifierExpr != null && qualifierExpr.getResultType() != null) {
            scopeType = qualifierExpr.getResultType();
        }
        String qualifier = null;
        IJstMethod jstMtd = null;
        JstIdentifier jstIdentifier = new JstIdentifier(name);
        JstIdentifier jstQualifier = null;
        boolean isMember = false;
        boolean isInherited = false;
        boolean isOuters = false;
        boolean isAnon = ownerType.isAnonymous();
        if (hasSuper) {
            if (scopeType.getExtend() != null && (jstMtd = TranslateHelper.Method.getMethod(astName.getParent(), scopeType.getExtend(), name, args)) != null) {
                isInherited = true;
            }
        } else {
            jstMtd = TranslateHelper.Method.getMethod(astName.getParent(), (IJstType)scopeType, name, args);
            if (jstMtd != null) {
                if (jstMtd.getOwnerType() == scopeType) {
                    isMember = true;
                } else {
                    isInherited = true;
                }
            }
        }
        if (jstMtd == null) {
            IJstType outerType = scopeType.getOuterType();
            while (outerType != null) {
                jstMtd = TranslateHelper.Method.getMethod(astName.getParent(), outerType, name, args);
                if (jstMtd != null) {
                    isOuters = true;
                    break;
                }
                outerType = outerType.getOuterType();
            }
        }
        if (isAnon && jstMtd == null) {
            IJstType containerType = scopeType.getExtend();
            StringBuffer buf = new StringBuffer(VjoConvention.getThisPrefix());
            while (containerType != null) {
                jstMtd = containerType.getStaticMethod(name, true);
                if (jstMtd == null) {
                    jstMtd = containerType.getInstanceMethod(name, true);
                }
                if (jstMtd != null) {
                    jstIdentifier.setJstBinding((IJstNode)jstMtd);
                    if (jstMtd.getModifiers().isStatic()) {
                        jstQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(jstIdentifier, jstNode);
                    } else if (qualifierExpr == null) {
                        jstQualifier = new JstIdentifier(buf.toString());
                    }
                    if (jstQualifier != null) {
                        jstQualifier.setJstBinding((IJstNode)jstMtd.getOwnerType());
                        jstQualifier.setType(jstMtd.getOwnerType());
                        this.setNameQualifier(jstIdentifier, jstQualifier, jstNode);
                        this.setMtdIdentifierType(jstIdentifier, (IJstNode)scopeType);
                        return jstIdentifier;
                    }
                }
                if (!containerType.isEmbededType()) break;
                containerType = (IJstType)containerType.getParentNode();
                buf.append(convension.getParentInstancePrefix());
            }
        }
        if (jstMtd != null) {
            jstIdentifier.setJstBinding((IJstNode)jstMtd);
            if (this.needReCalcQualifier(qualifierExpr, jstMtd.isStatic())) {
                if (isMember) {
                    if (hasThis) {
                        jstQualifier = new JstIdentifier(VjoConvention.getThisPrefix());
                        jstQualifier.setJstBinding((IJstNode)ownerType);
                        jstQualifier.setType((IJstType)ownerType);
                    }
                } else if (isInherited) {
                    if (jstMtd.getModifiers().isStatic()) {
                        jstQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(jstIdentifier, jstNode);
                    } else if (qualifierExpr == null) {
                        if (hasSuper) {
                            jstQualifier = new JstIdentifier(convension.getBasePrefix());
                        } else if (hasThis) {
                            jstQualifier = new JstIdentifier(VjoConvention.getThisPrefix());
                        }
                    }
                    if (jstQualifier != null) {
                        IJstType binding = jstMtd.getOwnerType();
                        jstQualifier.setJstBinding((IJstNode)binding);
                        jstQualifier.setType(binding);
                        if (binding != null && !ownerType.getRootType().getImportsMap().values().contains(binding)) {
                            this.getDataTypeTranslator().addImport(binding, ownerType, binding.getSimpleName());
                        }
                    }
                } else if (isOuters) {
                    if (jstMtd.getModifiers().isStatic()) {
                        jstQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(jstIdentifier, jstNode);
                    } else if (qualifierExpr == null) {
                        jstQualifier = VjoTranslateHelper.getInstanceMemberQualifier(jstMtd.getOwnerType(), (IJstNode)jstNode);
                    }
                    if (jstQualifier != null) {
                        jstQualifier.setJstBinding((IJstNode)jstMtd.getOwnerType());
                        jstQualifier.setType(jstMtd.getOwnerType());
                    }
                }
                if (jstQualifier == null) {
                    jstIdentifier.setJstBinding((IJstNode)jstMtd);
                    if (jstMtd.getOwnerType() == scopeType.getOuterType()) {
                        if (hasThis) {
                            qualifier = convension.getOuterStaticPrefix();
                        }
                    } else if (hasSuper) {
                        qualifier = String.valueOf(convension.getOuterStaticPrefix()) + "." + convension.getBasePrefix();
                    }
                    jstQualifier = new JstIdentifier(qualifier);
                    jstQualifier.setJstBinding((IJstNode)jstMtd.getOwnerType());
                    jstQualifier.setType(jstMtd.getOwnerType());
                }
                this.setNameQualifier(jstIdentifier, jstQualifier, jstNode);
            }
        }
        this.setMtdIdentifierType(jstIdentifier, (IJstNode)scopeType);
        if (scopeType instanceof JstType) {
            TranslateHelper.Method.validateMethodReference(jstMtd, (ASTNode)astName, jstNode, this);
        }
        return jstIdentifier;
    }

    private boolean needReCalcQualifier(IExpr qualifierExpr, boolean isStatic) {
        return qualifierExpr == null || qualifierExpr instanceof JstIdentifier && (((JstIdentifier)qualifierExpr).getJstBinding() instanceof IJstType || isStatic && ((JstIdentifier)qualifierExpr).getType() instanceof IJstType) || isStatic && qualifierExpr instanceof ObjCreationExpr && ((ObjCreationExpr)qualifierExpr).getResultType() instanceof IJstType;
    }

    private void setNameQualifier(JstIdentifier jstIdentifier, JstIdentifier qualifier, BaseJstNode jstNode) {
        if (jstIdentifier == null || qualifier == null) {
            return;
        }
        if (TranslateHelper.isStaticMember(jstIdentifier)) {
            JstIdentifier staticQualifier = null;
            IJstMethod jstMtd = TranslateHelper.Method.getOwnerMethod((IJstNode)jstNode);
            if (jstMtd != null && jstMtd.getOwnerType() instanceof JstType) {
                JstType qualifierType;
                IJstNode binding;
                MethodKey mtdKey;
                TranslateInfo tInfo = TranslateCtx.ctx().getTranslateInfo((JstType)jstMtd.getOwnerType());
                if (tInfo.getMethodCustomInfo(mtdKey = MethodKey.genMethodKey(jstMtd)).isForceFullyQualify() && (binding = jstIdentifier.getJstBinding()) != null && binding instanceof JstProperty && !(qualifierType = ((JstProperty)binding).getOwnerType()).isEmbededType()) {
                    staticQualifier = new JstIdentifier(qualifierType.getName());
                    staticQualifier.setType((IJstType)qualifierType);
                    staticQualifier.setJstBinding((IJstNode)qualifierType);
                }
            } else {
                staticQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(qualifier, jstNode);
            }
            if (staticQualifier != null) {
                jstIdentifier.setQualifier(staticQualifier);
                return;
            }
        }
        jstIdentifier.setQualifier(qualifier);
    }

    private void setNameIdentifierType(JstIdentifier jstIdentifier, BaseJstNode jstNode) {
        if (jstIdentifier.getType() != null || jstNode == null) {
            return;
        }
        String name = this.processVarName(jstIdentifier.getName());
        IJstType jstType = TranslateHelper.Type.getVarType(name, (IJstNode)jstNode);
        if (jstType != null) {
            jstIdentifier.setType(jstType);
        }
    }

    private void setMtdIdentifierType(JstIdentifier jstIdentifier, IJstNode jstNode) {
        IJstNode binding = jstIdentifier.getJstBinding();
        if (binding == null || !(binding instanceof IJstMethod)) {
            return;
        }
        IJstMethod jstMtd = (IJstMethod)binding;
        if (jstMtd != null) {
            jstIdentifier.setType(jstMtd.getRtnType());
        }
    }

    private static IJstType getContainingType(IJstType type) {
        if (type.isAnonymous()) {
            IJstType node = type;
            while ((node = node.getParentNode()) != null) {
                if (!(node instanceof IJstType)) continue;
                return node;
            }
            return null;
        }
        return type.getOuterType();
    }

    private boolean isStaticInvocation(IExpr qualifierExpr) {
        return qualifierExpr != null && qualifierExpr.toExprText().startsWith(VjoConvention.getThisPrefix());
    }
}

