/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.javatojs.control.BuildFileFilter;
import org.eclipse.vjet.dsf.javatojs.control.ExpressionTypeVisitor;
import org.eclipse.vjet.dsf.javatojs.control.IBuildResourceFilter;
import org.eclipse.vjet.dsf.javatojs.report.DefaultErrorReportPolicy;
import org.eclipse.vjet.dsf.javatojs.report.ErrorReportPolicy;
import org.eclipse.vjet.dsf.javatojs.translate.TranslatorProvider;
import org.eclipse.vjet.dsf.javatojs.translate.config.JavaTranslationConvention;
import org.eclipse.vjet.dsf.javatojs.translate.config.PackageMapping;
import org.eclipse.vjet.dsf.javatojs.translate.custom.ICustomTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.custom.anno.IAnnoProcessor;
import org.eclipse.vjet.dsf.javatojs.translate.policy.ITranslationPolicy;
import org.eclipse.vjet.dsf.javatojs.translate.policy.TranslationPolicy;
import org.eclipse.vjet.dsf.javatojs.translate.post.DirectDependencyVisitor;
import org.eclipse.vjet.dsf.javatojs.translate.post.FieldPostTranslationVisitor;
import org.eclipse.vjet.dsf.javatojs.translate.post.JavaOnlyVisitor;
import org.eclipse.vjet.dsf.javatojs.translate.post.MethodPostTranslationVisitor;
import org.eclipse.vjet.dsf.javatojs.translate.post.OptimizationVisitor;
import org.eclipse.vjet.dsf.javatojs.translate.post.TypePostTranslationVisitor;
import org.eclipse.vjet.dsf.jsnative.global.Boolean;
import org.eclipse.vjet.dsf.jsnative.global.Date;
import org.eclipse.vjet.dsf.jsnative.global.String;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.lib.IJstLibProvider;
import org.eclipse.vjet.dsf.jst.traversal.JstVisitorAdapter;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public final class TranslateConfig {
    private java.lang.String m_javaVersion;
    private java.lang.String m_jsVersion;
    private java.lang.String m_jstVersion;
    private ITranslationPolicy m_policy;
    private IBuildResourceFilter m_fileFilter;
    private IJstLibProvider m_jstLibProvider;
    private TranslatorProvider m_provider;
    private List<IAnnoProcessor> m_annoProcessors = new ArrayList<IAnnoProcessor>();
    private List<ICustomTranslator> m_customTranslators = new ArrayList<ICustomTranslator>();
    private List<JstVisitorAdapter> m_postTranslationVisitors = new ArrayList<JstVisitorAdapter>();
    private PackageMapping m_pkgMapping;
    private JavaTranslationConvention m_javaTranslationConvention;
    private VjoConvention m_vjoConvention;
    private ErrorReportPolicy m_errorPolicy;
    private boolean m_parseComments = false;
    private static final Map<java.lang.String, java.lang.String> JAVATOJSNATIVEMAP = new HashMap<java.lang.String, java.lang.String>();

    static {
        JAVATOJSNATIVEMAP.put(java.lang.String.class.getName(), String.class.getName());
        JAVATOJSNATIVEMAP.put(java.util.Date.class.getName(), Date.class.getName());
        JAVATOJSNATIVEMAP.put(java.lang.Boolean.class.getName(), Boolean.class.getName());
    }

    public TranslateConfig() {
        this.m_postTranslationVisitors.add(new TypePostTranslationVisitor());
        this.m_postTranslationVisitors.add(new FieldPostTranslationVisitor());
        this.m_postTranslationVisitors.add(new MethodPostTranslationVisitor());
        this.m_postTranslationVisitors.add(new JavaOnlyVisitor());
        this.m_postTranslationVisitors.add(new ExpressionTypeVisitor());
        this.m_postTranslationVisitors.add(new DirectDependencyVisitor());
        this.m_postTranslationVisitors.add(new OptimizationVisitor());
    }

    public java.lang.String getJavaVersion() {
        return this.m_javaVersion;
    }

    public void setJavaVersion(java.lang.String javaVersion) {
        this.m_javaVersion = javaVersion;
    }

    public java.lang.String getJsVersion() {
        return this.m_jsVersion;
    }

    public void setJsVersion(java.lang.String jsVersion) {
        this.m_jsVersion = jsVersion;
    }

    public ITranslationPolicy getPolicy() {
        if (this.m_policy == null) {
            this.m_policy = new TranslationPolicy();
        }
        return this.m_policy;
    }

    public TranslateConfig setPolicy(ITranslationPolicy policy) {
        this.m_policy = policy;
        return this;
    }

    public java.lang.String getJstVersion() {
        return this.m_jstVersion;
    }

    public void setJstVersion(java.lang.String jstVersion) {
        this.m_jstVersion = jstVersion;
    }

    public void setFileFilter(IBuildResourceFilter filter) {
        this.m_fileFilter = filter;
    }

    public IBuildResourceFilter getFileFilter() {
        if (this.m_fileFilter == null) {
            this.m_fileFilter = new BuildFileFilter(this.getPolicy());
        }
        return this.m_fileFilter;
    }

    public void setProvider(TranslatorProvider provider) {
        this.m_provider = provider;
    }

    public TranslatorProvider getProvider() {
        if (this.m_provider == null) {
            this.m_provider = new TranslatorProvider();
            return this.m_provider;
        }
        return this.m_provider;
    }

    public IJstLibProvider getJstLibProvider() {
        if (this.m_jstLibProvider == null) {
            this.m_jstLibProvider = new IJstLibProvider(){

                public List<IJstLib> getAll() {
                    return Collections.emptyList();
                }

                public IJstLibProvider add(IJstLib jstLib) {
                    return this;
                }

                public IJstLib remove(java.lang.String lib) {
                    return null;
                }

                public void clearAll() {
                }
            };
        }
        return this.m_jstLibProvider;
    }

    public void setJstLibProvider(IJstLibProvider libProvider) {
        this.m_jstLibProvider = libProvider;
    }

    public TranslateConfig addAnnoProcessor(IAnnoProcessor annoProcessor) {
        if (annoProcessor != null && this.m_annoProcessors.isEmpty()) {
            this.m_annoProcessors.add(annoProcessor);
        }
        return this;
    }

    public List<IAnnoProcessor> getAnnoProcessors() {
        return Collections.unmodifiableList(this.m_annoProcessors);
    }

    public TranslateConfig addCustomTranslator(ICustomTranslator customTranslator) {
        if (customTranslator != null && !this.m_customTranslators.contains(customTranslator)) {
            this.m_customTranslators.add(customTranslator);
        }
        return this;
    }

    public List<ICustomTranslator> getCustomTranslators() {
        return Collections.unmodifiableList(this.m_customTranslators);
    }

    public TranslateConfig addPostTranslationVisitor(JstVisitorAdapter visitor) {
        if (visitor != null) {
            this.m_postTranslationVisitors.add(visitor);
        }
        return this;
    }

    public List<JstVisitorAdapter> getPostTranslationVisitors() {
        return Collections.unmodifiableList(this.m_postTranslationVisitors);
    }

    public JavaTranslationConvention getJavaTranslationConvention() {
        if (this.m_javaTranslationConvention == null) {
            this.m_javaTranslationConvention = new JavaTranslationConvention();
        }
        return this.m_javaTranslationConvention;
    }

    public void setJavaForEachTranslationConvention(JavaTranslationConvention convention) {
        this.m_javaTranslationConvention = convention;
    }

    public VjoConvention getVjoConvention() {
        if (this.m_vjoConvention == null) {
            this.m_vjoConvention = new VjoConvention();
        }
        return this.m_vjoConvention;
    }

    public void setVjoConvention(VjoConvention vjoConvention) {
        this.m_vjoConvention = vjoConvention;
    }

    public PackageMapping getPackageMapping() {
        if (this.m_pkgMapping == null) {
            this.m_pkgMapping = new PackageMapping();
        }
        return this.m_pkgMapping;
    }

    public void setPkgMapping(PackageMapping pkgMapping) {
        this.m_pkgMapping = pkgMapping;
    }

    public ErrorReportPolicy getErrorPolicy() {
        if (this.m_errorPolicy == null) {
            this.m_errorPolicy = new DefaultErrorReportPolicy();
        }
        return this.m_errorPolicy;
    }

    public void setErrorPolicy(ErrorReportPolicy policy) {
        this.m_errorPolicy = policy;
    }

    public boolean shouldParseComments() {
        return this.m_parseComments;
    }

    public void setParseComments(boolean value) {
        this.m_parseComments = value;
    }

    public java.lang.String mapToNative(java.lang.String fullName) {
        return JAVATOJSNATIVEMAP.get(fullName);
    }
}

