/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class WildcardList {
    List<String> wildcardList = new ArrayList<String>();
    private List<String> wildcardRegularExpressionList = new ArrayList<String>();

    public void addWildcard(String wildcardString) {
        this.wildcardList.add(wildcardString);
        this.wildcardRegularExpressionList.add(WildcardList.wildcardToRegex(wildcardString));
    }

    public boolean contains(String matchingString) {
        for (String wildcardRegularExpression : this.wildcardRegularExpressionList) {
            if (!Pattern.matches(wildcardRegularExpression, matchingString)) continue;
            return true;
        }
        return false;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int i = 0;
        int is = wildcard.length();
        while (i < is) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    break;
                }
                case '?': {
                    s.append(".");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    break;
                }
                default: {
                    s.append(c);
                }
            }
            ++i;
        }
        s.append('$');
        return s.toString();
    }

    public static void main(String[] args) {
        WildcardList wildcardList = new WildcardList();
        wildcardList.addWildcard("*.test.*.*");
        System.out.println(wildcardList.contains("pkg.test.Abc.java"));
        System.out.println(wildcardList.contains("pkg.1test.Abc.java"));
        System.out.println(wildcardList.contains("pkg.test.Abc.text"));
    }
}

