/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.post;

import java.util.Set;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.traversal.JstVisitorAdapter;

public class OptimizationVisitor
extends JstVisitorAdapter {
    public void postVisit(IJstNode node) {
        if (!(node instanceof JstType)) {
            return;
        }
        JstType jstType = (JstType)node;
        this.removeIndirectDependency(jstType);
    }

    private void removeIndirectDependency(JstType jstType) {
        for (String key : jstType.getImportsMap().keySet()) {
            IJstType itm = (IJstType)jstType.getImportsMap().get(key);
            if (this.isInActiveImports(jstType, itm) || this.isInExtends(jstType, itm) || this.isInSatisfies(jstType, itm)) continue;
            jstType.addInactiveImport(key, itm);
            jstType.removeImport(itm);
        }
    }

    private boolean isInActiveImports(JstType jstType, IJstType itm) {
        Set<IJstType> activeImports = TranslateCtx.ctx().getTranslateInfo(jstType).getActiveImports();
        if (activeImports.contains(itm)) {
            return true;
        }
        for (IJstType imp : activeImports) {
            if (imp == null || !imp.getName().equals(itm.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isInExtends(JstType jstType, IJstType dependencyType) {
        for (IJstNode itm : jstType.getExtends()) {
            JstType type = null;
            if (itm instanceof JstType) {
                type = (JstType)itm;
            } else if (itm instanceof JstTypeReference) {
                type = (JstType)((JstTypeReference)itm).getReferencedType();
            } else if (itm instanceof JstTypeWithArgs) {
                type = (JstType)((JstTypeWithArgs)itm).getType();
            }
            if (type == null) continue;
            if (type.getOuterType() != null) {
                type = type.getOuterType();
            }
            if (!type.equals(dependencyType)) continue;
            return true;
        }
        for (IJstNode itm : jstType.getEmbededTypes()) {
            if (!this.isInExtends((JstType)itm, dependencyType)) continue;
            return true;
        }
        return false;
    }

    private boolean isInSatisfies(JstType jstType, IJstType dependencyType) {
        for (IJstNode itm : jstType.getSatisfies()) {
            JstType type = null;
            if (itm instanceof JstType) {
                type = (JstType)itm;
            } else if (itm instanceof JstTypeReference) {
                type = (JstType)((JstTypeReference)itm).getReferencedType();
            } else if (itm instanceof JstTypeWithArgs) {
                type = (JstType)((JstTypeWithArgs)itm).getType();
            }
            if (type == null) continue;
            if (type.getOuterType() != null) {
                type = type.getOuterType();
            }
            if (!type.equals(dependencyType)) continue;
            return true;
        }
        for (IJstNode itm : jstType.getEmbededTypes()) {
            if (!this.isInSatisfies((JstType)itm, dependencyType)) continue;
            return true;
        }
        return false;
    }
}

