/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util;

import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalFunc;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalProp;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class AccessControlUtil {
    public static boolean isVisible(IJstMethod mtd, IJstType ownerType, IJstType callerType) {
        if (mtd instanceof JstGlobalFunc) {
            return true;
        }
        if (mtd.isDispatcher()) {
            for (IJstMethod overload : mtd.getOverloaded()) {
                if (!AccessControlUtil.isVisible(overload.getModifiers(), ownerType, callerType)) continue;
                return true;
            }
            return false;
        }
        return AccessControlUtil.isVisible(mtd.getModifiers(), ownerType, callerType);
    }

    public static boolean isVisible(IJstProperty pty, IJstType ownerType, IJstType callerType) {
        if (pty instanceof JstGlobalProp) {
            return true;
        }
        return AccessControlUtil.isVisible(pty.getModifiers(), ownerType, callerType);
    }

    private static boolean isVisible(JstModifiers modifiers, IJstType ownerType, IJstType callerType) {
        if (!modifiers.isPublic()) {
            IJstType fieldOwnerType = ownerType;
            if (fieldOwnerType instanceof JstInferredType.AugmentedType) {
                fieldOwnerType = ((JstInferredType.AugmentedType)fieldOwnerType).getExtend();
            }
            if (fieldOwnerType instanceof JstInferredType) {
                fieldOwnerType = ((JstInferredType)fieldOwnerType).getType();
            }
            if (fieldOwnerType instanceof JstMixedType) {
                JstMixedType mixedTypes = (JstMixedType)fieldOwnerType;
                for (IJstType mixed : mixedTypes.getMixedTypes()) {
                    if (!AccessControlUtil.isVisible(modifiers, mixed, callerType)) continue;
                    return true;
                }
            }
            boolean isVisible = false;
            if (modifiers.isPrivate()) {
                if (callerType == fieldOwnerType || JstTypeHelper.hasSameRootType((IJstType)callerType, (IJstType)fieldOwnerType)) {
                    isVisible = true;
                }
            } else if (modifiers.isProtected()) {
                if (callerType == fieldOwnerType || JstTypeHelper.isTypeOf((IJstType)callerType, (IJstType)fieldOwnerType)) {
                    isVisible = true;
                }
            } else {
                JstPackage callerPackage = JstTypeHelper.getTruePackage((IJstType)callerType);
                JstPackage fieldOwnerPackage = JstTypeHelper.getTruePackage((IJstType)fieldOwnerType);
                if (fieldOwnerPackage == null) {
                    isVisible = true;
                } else if (callerPackage != null && callerPackage.getName().equals(fieldOwnerPackage.getName())) {
                    isVisible = true;
                }
            }
            return isVisible;
        }
        return true;
    }
}

