/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.expr.ArrayCreationExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class VjoArrayCreationExprValidator
extends VjoSemanticValidator
implements IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(ArrayCreationExpr.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof ArrayCreationExpr)) {
            return;
        }
        String groupId = ctx.getGroupId();
        ArrayCreationExpr expr = (ArrayCreationExpr)jstNode;
        List dimensions = expr.getDimensions();
        for (IExpr dimension : dimensions) {
            IJstType dimensionValue;
            String[] args = new String[]{dimension != null ? dimension.toExprText() : "NULL", expr.toExprText()};
            IJstType iJstType = dimensionValue = dimension != null ? dimension.getResultType() : null;
            if (dimensionValue == null || TypeCheckUtil.isNumber(dimensionValue)) continue;
            BaseVjoSemanticRuleCtx arrayCreationDimensionTypeShouldBeIntegerRuleCtx = new BaseVjoSemanticRuleCtx((IJstNode)expr, groupId, args);
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ARRAY_CREATION_DIMENSION_TYPE_SHOULD_BE_INTEGER, arrayCreationDimensionTypeShouldBeIntegerRuleCtx);
        }
    }
}

