/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.jsgen.shared.ids.VjoSyntaxProbIds;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoConstants;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.ClassBetterStartWithCapitalLetterRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.MTypeShouldNotBeAsInnerTypeRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.MTypeShouldNotHaveInnerTypesRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.TypeNameShouldNotBeEmptyRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.MixinValidationUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPreAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.FileBinding;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.lib.TsLibLoader;

public class VjoJstTypeValidator
extends VjoSemanticValidator
implements IVjoValidationPreAllChildrenListener,
IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();
    private static Pattern s_typePattern;

    static {
        s_targetTypes.add(JstType.class);
        s_typePattern = Pattern.compile("([a-zA-Z_$][0-9a-zA-Z_$]*\\.)*[a-zA-Z_$][0-9a-zA-Z_$]*");
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPreAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof JstType)) {
            return;
        }
        JstType jstType = (JstType)jstNode;
        this.validateBeforeAll(ctx, jstType);
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof JstType)) {
            return;
        }
        JstType jstType = (JstType)jstNode;
        this.validateAfterAll(ctx, jstType);
    }

    private void validateAfterAll(VjoValidationCtx ctx, JstType jstType) {
        BaseVjoSemanticRuleCtx ruleCtx;
        this.validateTypePath(ctx, jstType);
        this.validateTypeName(ctx, jstType);
        HashMap<String, Object> dupProtectMap = new HashMap<String, Object>();
        for (IJstMethod m : jstType.getMethods(true)) {
            if (m instanceof JstProxyMethod || m instanceof ISynthesized) continue;
            if (!dupProtectMap.containsKey(m.getName().getName())) {
                dupProtectMap.put(m.getName().getName(), m);
                continue;
            }
            if (m.getName().getName().trim().length() <= 0) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)m.getName(), ctx.getGroupId(), new String[]{m.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().DUPLICATE_METHOD, ruleCtx);
        }
        for (IJstProperty p : jstType.getProperties(true)) {
            if (p instanceof JstProxyProperty || p instanceof ISynthesized) continue;
            if (!dupProtectMap.containsKey(p.getName().getName())) {
                dupProtectMap.put(p.getName().getName(), p);
                continue;
            }
            if (p.getName().getName().trim().length() <= 0) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)p.getName(), ctx.getGroupId(), new String[]{p.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().DUPLICATE_PROPERTY, ruleCtx);
        }
        for (IJstMethod m : jstType.getMethods(false)) {
            BaseVjoSemanticRuleCtx ruleCtx2;
            if (m instanceof JstProxyMethod || m instanceof ISynthesized) continue;
            String mtdName = m.getName().getName();
            if (!dupProtectMap.containsKey(mtdName)) {
                dupProtectMap.put(mtdName, m);
                continue;
            }
            IJstNode potentialMtd = (IJstNode)dupProtectMap.get(mtdName);
            JstTypeWithArgs typeWithArgs = null;
            JstType jstIType = jstType;
            if (jstIType instanceof JstTypeWithArgs) {
                typeWithArgs = (JstTypeWithArgs)jstIType;
            }
            if (potentialMtd != null && potentialMtd instanceof IJstMethod && ((IJstMethod)potentialMtd).isStatic()) {
                if (!this.isCompatibleMethod(typeWithArgs, typeWithArgs, m, (IJstMethod)potentialMtd)) continue;
                ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)m.getName(), ctx.getGroupId(), new String[]{mtdName, jstType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OVERLAP_STATIC_AND_NONE_STATIC_METHOD, ruleCtx2);
                continue;
            }
            if (m.getName().getName().trim().length() <= 0) continue;
            ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)m.getName(), ctx.getGroupId(), new String[]{m.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().DUPLICATE_METHOD, ruleCtx2);
        }
        for (IJstProperty p : jstType.getProperties(false)) {
            BaseVjoSemanticRuleCtx ruleCtx3;
            if (p instanceof JstProxyProperty || p instanceof ISynthesized) continue;
            String ptyName = p.getName().getName();
            if (!dupProtectMap.containsKey(ptyName)) {
                dupProtectMap.put(ptyName, p);
                continue;
            }
            IJstNode potentialPty = (IJstNode)dupProtectMap.get(ptyName);
            if (potentialPty != null && potentialPty instanceof IJstProperty && ((IJstProperty)potentialPty).isStatic()) {
                ruleCtx3 = new BaseVjoSemanticRuleCtx((IJstNode)p.getName(), ctx.getGroupId(), new String[]{ptyName, jstType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OVERLAP_STATIC_AND_NONE_STATIC_PROPERTY, ruleCtx3);
                continue;
            }
            if (p.getName().getName().replaceAll("\\\"", "").length() <= 0) continue;
            ruleCtx3 = new BaseVjoSemanticRuleCtx((IJstNode)p.getName(), ctx.getGroupId(), new String[]{p.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().DUPLICATE_PROPERTY, ruleCtx3);
        }
        HashMap<String, List<IJstMethod>> instanceMethodMap = new HashMap<String, List<IJstMethod>>();
        List allInstanceMethods = JstTypeHelper.getDeclaredMethods((List)jstType.getMethods(false, true));
        for (IJstMethod m : allInstanceMethods) {
            ArrayList<IJstMethod> mList = (ArrayList<IJstMethod>)instanceMethodMap.get(m.getName().getName());
            if (mList == null) {
                mList = new ArrayList<IJstMethod>();
                instanceMethodMap.put(m.getName().getName(), mList);
            }
            mList.add(m);
        }
        HashMap<String, List<IJstMethod>> staticMethodMap = new HashMap<String, List<IJstMethod>>();
        List allStaticMethods = JstTypeHelper.getDeclaredMethods((List)jstType.getMethods(true));
        for (IJstMethod m : allStaticMethods) {
            ArrayList<IJstMethod> mList = (ArrayList<IJstMethod>)staticMethodMap.get(m.getName().getName());
            if (mList == null) {
                mList = new ArrayList<IJstMethod>();
                staticMethodMap.put(m.getName().getName(), mList);
            }
            mList.add(m);
        }
        this.validateMixin(ctx, jstType, instanceMethodMap, staticMethodMap);
        if (jstType.isClass()) {
            this.validateCType(ctx, jstType, instanceMethodMap);
        } else if (jstType.isEnum()) {
            this.validateEType(ctx, jstType, instanceMethodMap);
        } else if (jstType.isInterface()) {
            this.validateIType(ctx, jstType);
        } else if (jstType.isOType()) {
            this.validateOType(ctx, jstType);
        } else if (jstType.isMixin()) {
            this.validateMType(ctx, jstType);
        }
        this.validateAllTypes(ctx, jstType);
    }

    private void validateMixin(VjoValidationCtx ctx, JstType jstType, Map<String, List<IJstMethod>> instanceMethodMap, Map<String, List<IJstMethod>> staticMethodMap) {
        for (IJstTypeReference mixinTypeRef : jstType.getMixinsRef()) {
            BaseVjoSemanticRuleCtx ruleCtx;
            IJstType mixinType = mixinTypeRef.getReferencedType();
            if (mixinType == null) continue;
            if ((mixinType = ctx.getTypeSpaceType(mixinType)).equals(jstType)) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().MIXINED_TYPE_MUST_NOT_BE_ITSELF, ruleCtx);
                continue;
            }
            if (!mixinType.isMixin()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), mixinType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().MTYPE_SHOULD_ONLY_BE_MIXINED, ruleCtx);
                continue;
            }
            MixinValidationUtil.validateMixin(ctx, this, (IJstType)jstType, mixinType, instanceMethodMap, staticMethodMap, false);
        }
    }

    private void validateIType(VjoValidationCtx ctx, JstType jstType) {
        BaseVjoSemanticRuleCtx ruleCtx;
        BaseVjoSemanticRuleCtx ruleCtx2;
        if (jstType.getModifiers().isFinal() && (jstType.getOuterType() == null || !jstType.getOuterType().isInterface())) {
            ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().INTERFACE_SHOULD_NOT_BE_FINAL, ruleCtx2);
        }
        for (IJstMethod mtd : jstType.getMethods()) {
            if (mtd instanceof ISynthesized || mtd instanceof JstProxyMethod) continue;
            if (mtd.getModifiers().isPrivate() || mtd.getModifiers().isProtected()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)mtd.getName(), ctx.getGroupId(), new String[]{jstType.getName(), mtd.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_ALLOWS_ONLY_PUBLIC_MODIFIER, ruleCtx);
            }
            if (!mtd.isStatic()) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)mtd.getName(), ctx.getGroupId(), new String[]{jstType.getName(), mtd.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_SHOULD_NOT_DEFINE_STATIC_METHODS, ruleCtx);
        }
        for (IJstProperty pty : jstType.getProperties()) {
            if (pty instanceof ISynthesized || pty instanceof JstProxyProperty) continue;
            if (pty.getModifiers().isPrivate() || pty.getModifiers().isProtected()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)pty.getName(), ctx.getGroupId(), new String[]{jstType.getName(), pty.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_ALLOWS_ONLY_PUBLIC_MODIFIER, ruleCtx);
            }
            if (pty.isStatic()) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)pty.getName(), ctx.getGroupId(), new String[]{jstType.getName(), pty.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_SHOULD_NOT_HAVE_INSTANCE_PROPERTY, ruleCtx);
        }
        for (IJstType innerType : jstType.getEmbededTypes()) {
            if (innerType.getModifiers().isPrivate() || innerType.getModifiers().isProtected()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)innerType, ctx.getGroupId(), new String[]{jstType.getName(), innerType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_ALLOWS_ONLY_PUBLIC_MODIFIER, ruleCtx);
            }
            if (innerType.getModifiers().isStatic()) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)innerType, ctx.getGroupId(), new String[]{jstType.getName(), innerType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_SHOULD_NOT_HAVE_INSTANCE_PROPERTY, ruleCtx);
        }
        for (IJstType extType : jstType.getExtends()) {
            if ((extType = ctx.getTypeSpaceType(extType)).getName().equals(jstType.getName())) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().SUPER_CLASS_SHOULD_NOT_BE_THE_SAME, ruleCtx);
                continue;
            }
            if (ctx.getUnresolvedTypes().contains(extType.getName()) || extType.isInterface()) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), extType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_SHOULD_NOT_EXTEND_NONE_ITYPE_CLASS, ruleCtx);
        }
        if (jstType.getConstructor() != null) {
            ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_OR_MTYPE_SHOULD_NOT_HAVE_CONSTRUCTOR, ruleCtx2);
        }
    }

    private void validateMType(VjoValidationCtx ctx, JstType jstType) {
        if (jstType.getExpects().size() > 0) {
            for (IJstTypeReference typeRef : jstType.getExpectsRef()) {
                IJstType type = typeRef.getReferencedType();
                if (type.isClass() || type.isInterface()) continue;
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)typeRef, ctx.getGroupId(), new String[]{type.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().EXPECTS_MUST_BE_CTYPE_ITYPE, ruleCtx);
            }
        }
        if (jstType.getConstructor() != null) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ITYPE_OR_MTYPE_SHOULD_NOT_HAVE_CONSTRUCTOR, ruleCtx);
        }
        MTypeShouldNotHaveInnerTypesRuleCtx ruleCtx1 = new MTypeShouldNotHaveInnerTypesRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()}, (IJstType)jstType);
        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().MTYPE_SHOULD_NOT_HAVE_INNER_TYPES, ruleCtx1);
        if (jstType.getOuterType() != null) {
            MTypeShouldNotBeAsInnerTypeRuleCtx ruleCtx2 = new MTypeShouldNotBeAsInnerTypeRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), jstType.getOuterType().getName()}, (IJstType)jstType);
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().MTYPE_SHOULD_NOT_BE_AS_INNER_TYPE, ruleCtx2);
        }
    }

    private void validateOType(VjoValidationCtx ctx, JstType jstType) {
        BaseVjoSemanticRuleCtx ruleCtx;
        for (IJstProperty pty : jstType.getProperties()) {
            if (pty instanceof ISynthesized || pty instanceof JstProxyProperty || pty.getType() == null || pty.getType() instanceof JstObjectLiteralType) continue;
            BaseVjoSemanticRuleCtx ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)pty.getName(), ctx.getGroupId(), new String[]{jstType.getName(), pty.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OTYPE_SHOULD_NOT_HAVE_NONE_OBJ_LITERAL_PROPERTY, ruleCtx2);
        }
        if (jstType.getEmbededTypes().size() > 0) {
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OTYPE_SHOULD_NOT_HAVE_INNER_TYPES, ruleCtx);
        }
        if (jstType.getOuterType() != null && !jstType.getOuterType().isMetaType()) {
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), jstType.getOuterType().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OTYPE_SHOULD_NOT_BE_AS_INNER_TYPE, ruleCtx);
        }
        if (jstType.getContainingType() != null && !jstType.getContainingType().isMetaType()) {
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), jstType.getContainingType().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OTYPE_SHOULD_NOT_BE_AS_INNER_TYPE, ruleCtx);
        }
    }

    private void validateAllTypes(VjoValidationCtx ctx, JstType jstType) {
        List listParamTypes;
        if (jstType.getEmbededType(jstType.getSimpleName()) != null) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getSimpleName(), jstType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().INNER_TYPE_SHOULD_NOT_HAVE_NAME_SAME_AS_EMBEDDING_TYPE, ruleCtx);
        }
        if (jstType.getOuterType() != null && !jstType.getModifiers().isStatic() && !jstType.getOuterType().isInterface()) {
            BaseVjoSemanticRuleCtx ruleCtx;
            for (IJstProperty prop : jstType.getProperties(true)) {
                if (prop instanceof ISynthesized || prop.getModifiers().isFinal()) continue;
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)prop.getName(), ctx.getGroupId(), new String[]{jstType.getName(), prop.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().INSTANCE_INNER_TYPE_SHOULD_NOT_HAVE_STATIC_MEMBERS, ruleCtx);
            }
            for (IJstMethod mtd : jstType.getMethods(true)) {
                if (mtd instanceof ISynthesized) continue;
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)mtd.getName(), ctx.getGroupId(), new String[]{jstType.getName(), mtd.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().INSTANCE_INNER_TYPE_SHOULD_NOT_HAVE_STATIC_MEMBERS, ruleCtx);
            }
        }
        ArrayList<IJstType> inherits = new ArrayList<IJstType>(jstType.getExtends());
        ArrayList<IJstType> satisfies = new ArrayList<IJstType>(jstType.getSatisfies());
        this.collectInheritsSatisfiesFromSubTypes(jstType, inherits, satisfies);
        ArrayList activeNeeds = new ArrayList(jstType.getImports());
        Set<IJstRefType> mustActivelyNeeded = ctx.getMustActivelyNeededTypes((IJstType)jstType);
        HashSet<IJstType> dereferencedNeededTypes = new HashSet<IJstType>(mustActivelyNeeded.size());
        HashSet<IJstType> eligibleNeededTypes = new HashSet<IJstType>();
        eligibleNeededTypes.addAll(inherits);
        eligibleNeededTypes.addAll(satisfies);
        for (IJstType active : activeNeeds) {
            eligibleNeededTypes.addAll(this.getInnerOuterTypes(active));
        }
        eligibleNeededTypes.addAll(this.getInnerOuterTypes((IJstType)jstType));
        ArrayList<String> missingActiveNeedsTypes = new ArrayList<String>();
        for (IJstRefType neededType : mustActivelyNeeded) {
            dereferencedNeededTypes.add(neededType.getReferencedNode());
            if (neededType == null || neededType.isMixin() || neededType.isImpliedImport() || neededType.getPackage() != null && TsLibLoader.isDefaultLibName((String)neededType.getPackage().getGroupName()) || neededType.getReferencedNode() == jstType || this.checkTypeInList(eligibleNeededTypes, neededType.getReferencedNode())) continue;
            missingActiveNeedsTypes.add(neededType.getName());
        }
        if (!missingActiveNeedsTypes.isEmpty()) {
            StringBuilder missingActiveTypeNames = new StringBuilder();
            block4: for (String neededType : missingActiveNeedsTypes) {
                for (IJstType missingImport : ctx.getMissingImportTypes()) {
                    if (neededType.equals(missingImport.getName())) continue block4;
                }
                if (ctx.getUnresolvedTypes().contains(neededType)) continue;
                if (missingActiveTypeNames.length() > 0) {
                    missingActiveTypeNames.append(", ");
                }
                missingActiveTypeNames.append(neededType);
            }
            if (missingActiveTypeNames.length() > 0) {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{missingActiveTypeNames.toString()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CANNOT_USE_INACTIVE_NEED_ACTIVELY, ruleCtx);
            }
        }
        ArrayList<String> unusedActiveNeedsTypes = new ArrayList<String>();
        for (IJstRefType knownActivelyNeeded : ctx.getKnownActivelyNeededTypes((IJstType)jstType)) {
            dereferencedNeededTypes.add(knownActivelyNeeded.getReferencedNode());
        }
        for (IJstType activeNeedsType : activeNeeds) {
            if (activeNeedsType == null || this.checkTypeInList(satisfies, activeNeedsType) || this.checkTypeInList(inherits, activeNeedsType) || dereferencedNeededTypes.contains(activeNeedsType) || activeNeedsType.isFakeType()) continue;
            unusedActiveNeedsTypes.add(activeNeedsType.getName());
        }
        if (!unusedActiveNeedsTypes.isEmpty()) {
            StringBuilder unusedActiveTypeNames = new StringBuilder();
            for (String neededType : unusedActiveNeedsTypes) {
                if (unusedActiveTypeNames.length() > 0) {
                    unusedActiveTypeNames.append(", ");
                }
                unusedActiveTypeNames.append(neededType);
            }
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{unusedActiveTypeNames.toString()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().UNUSED_ACTIVE_NEEDS, ruleCtx);
        }
        if ((listParamTypes = jstType.getParamTypes()) != null && !listParamTypes.isEmpty()) {
            this.checkAndReportMissingParamTypeUpperBound((IJstType)jstType, ctx, listParamTypes);
        }
    }

    private List<IJstType> getInnerOuterTypes(IJstType jstType) {
        LinkedList<IJstType> innerOuterTypes = new LinkedList<IJstType>();
        IJstType enclosingType = jstType.getContainingType();
        while (enclosingType != null) {
            innerOuterTypes.add(enclosingType);
            enclosingType = enclosingType.getContainingType();
        }
        innerOuterTypes.addAll(jstType.getEmbededTypes());
        innerOuterTypes.add(jstType);
        return innerOuterTypes;
    }

    private boolean checkTypeInList(Collection<IJstType> list, IJstType type) {
        for (IJstType t : list) {
            if (t instanceof JstProxyType) {
                t = ((JstProxyType)t).getType();
            }
            if (type instanceof JstProxyType) {
                type = ((JstProxyType)type).getType();
            }
            if (t != type) continue;
            return true;
        }
        return false;
    }

    private void collectInheritsSatisfiesFromSubTypes(JstType jstType, List<IJstType> inherites, List<IJstType> satisfies) {
        List embeddedTypes = jstType.getEmbededTypes();
        for (JstType innerType : embeddedTypes) {
            inherites.addAll(innerType.getExtends());
            satisfies.addAll(innerType.getSatisfies());
            this.collectInheritsSatisfiesFromSubTypes(innerType, inherites, satisfies);
        }
    }

    private void validateCType(VjoValidationCtx ctx, JstType jstType, Map<String, List<IJstMethod>> instanceMethodMap) {
        BaseVjoSemanticRuleCtx ruleCtx;
        boolean isAbstract = jstType.getModifiers().isAbstract();
        for (IJstProperty prop : jstType.getProperties()) {
            if (!prop.isPrivate() || prop instanceof ISynthesized || !jstType.equals(prop.getOwnerType()) || ctx.getPropertyStatesTable().hasReferences(prop)) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)prop.getName(), ctx.getGroupId(), new String[]{prop.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().PRIVATE_PROPERTY_REFERENCED_NOWHERE, ruleCtx);
        }
        for (IJstMethod meth : jstType.getMethods()) {
            if (meth instanceof ISynthesized) continue;
            if (meth.isAbstract() && !isAbstract) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), meth.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CLASS_SHOULD_BE_ABSTRACT, ruleCtx);
            }
            if (!this.isPrivateMethod(meth) || !jstType.equals(meth.getOwnerType()) || ctx.getMethodInvocationTable().hasReferences(meth)) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)meth.getName(), ctx.getGroupId(), new String[]{meth.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().PRIVATE_METHOD_REFERENCED_NOWHERE, ruleCtx);
        }
        this.checkFinalProperties(ctx, jstType);
        if (isAbstract) {
            if (jstType.getModifiers().isFinal()) {
                BaseVjoSemanticRuleCtx ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CLASS_SHOULD_NOT_BE_BOTH_FINAL_AND_ABSTRACT, ruleCtx2);
            }
        } else {
            for (IJstType iType : jstType.getSatisfies()) {
                IJstType interfaceType = ctx.getTypeSpaceType(iType);
                if (!ctx.getUnresolvedTypes().contains(interfaceType.getName()) && !interfaceType.isInterface()) {
                    BaseVjoSemanticRuleCtx ruleCtx3 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), interfaceType.getName()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CTYPE_SHOULD_NOT_IMPLEMENT_NONE_ITYPE_INTERFACE, ruleCtx3);
                }
                if (iType instanceof JstTypeWithArgs) {
                    this.validateOverride(ctx, jstType, iType);
                    continue;
                }
                this.validateOverride(ctx, jstType, interfaceType);
            }
            for (IJstType extType : jstType.getExtends()) {
                BaseVjoSemanticRuleCtx ruleCtx4;
                IJstType extendType = ctx.getTypeSpaceType(extType);
                JstTypeWithArgs typeWithArgs = null;
                if (extType instanceof JstTypeWithArgs) {
                    typeWithArgs = (JstTypeWithArgs)extType;
                }
                if (extendType.getName().equals(jstType.getName())) {
                    ruleCtx4 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().SUPER_CLASS_SHOULD_NOT_BE_THE_SAME, ruleCtx4);
                } else if (!extendType.isClass() && !extendType.isMixin()) {
                    ruleCtx4 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), extendType.getName()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CTYPE_SHOULD_NOT_EXTEND_NONE_CTYPE_CLASS, ruleCtx4);
                }
                if (extendType.getModifiers().isFinal()) {
                    ruleCtx4 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{extendType.getName()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().SUPER_CLASS_SHOULD_NOT_BE_FINAL, ruleCtx4);
                }
                for (IJstMethod staticExtMtd : extendType.getMethods(true, false)) {
                    List<IJstMethod> candidateMtds;
                    if (this.isPrivateMethod(staticExtMtd) || (candidateMtds = instanceMethodMap.get(staticExtMtd.getName().getName())) == null) continue;
                    boolean overrided = false;
                    IJstMethod overrideMtdFound = null;
                    for (IJstMethod overrideMtd : candidateMtds) {
                        if (overrideMtd == null || !overrideMtd.getParentNode().equals(jstType)) continue;
                        if (overrideMtd.equals(staticExtMtd)) {
                            overrided = false;
                            continue;
                        }
                        if (overrideMtd.isAbstract()) {
                            overrided = false;
                            continue;
                        }
                        if (!this.isCompatibleMethod(typeWithArgs, typeWithArgs, staticExtMtd, overrideMtd)) continue;
                        overrided = true;
                        overrideMtdFound = overrideMtd;
                    }
                    if (!overrided || overrideMtdFound == null) continue;
                    BaseVjoSemanticRuleCtx ruleCtx5 = new BaseVjoSemanticRuleCtx((IJstNode)overrideMtdFound.getName(), ctx.getGroupId(), new String[]{staticExtMtd.getName().getName(), extendType.getName(), jstType.getName()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().STATIC_METHOD_SHOULD_NOT_BE_OVERRIDEN, ruleCtx5);
                }
                if (extType instanceof JstTypeWithArgs) {
                    this.validateOverride(ctx, jstType, extType);
                    continue;
                }
                this.validateOverride(ctx, jstType, extendType);
            }
        }
    }

    private boolean isPrivateMethod(IJstMethod meth) {
        if (meth.isDispatcher()) {
            for (IJstMethod overload : meth.getOverloaded()) {
                if (overload.isPrivate()) continue;
                return false;
            }
            return true;
        }
        return meth.isPrivate();
    }

    private void checkFinalProperties(VjoValidationCtx ctx, JstType jstType) {
        List jstProperties = jstType.getProperties();
        for (IJstProperty jstProperty : jstProperties) {
            boolean hasValue = false;
            if (!jstProperty.isFinal() || jstProperty instanceof ISynthesized || jstProperty.getName() != null && "vj$".equals(jstProperty.getName().getName())) continue;
            String groupId = ctx.getGroupId();
            if (!jstProperty.getModifiers().isStatic()) {
                List<IJstMethod> methods = ctx.getFinalPropertyInitConstructors(jstProperty);
                if (methods != null) {
                    for (IJstMethod method : jstType.getMethods()) {
                        boolean isOverloadedConstructor;
                        String name = method.getName().getName();
                        boolean bl = isOverloadedConstructor = method.getModifiers().isPrivate() && name.startsWith("constructs") && name.endsWith("_ovld");
                        if (!isOverloadedConstructor || methods.contains(method)) continue;
                        this.reportError(ctx, jstProperty, groupId);
                        return;
                    }
                    hasValue = true;
                } else if (ctx.getPropertyStatesTable().hasAssigned(jstProperty)) {
                    hasValue = true;
                }
            }
            if (ctx.getPropertyStatesTable().hasAssigned(jstProperty)) {
                hasValue = true;
            }
            if (!jstProperty.isFinal() || hasValue) continue;
            this.reportError(ctx, jstProperty, groupId);
        }
    }

    private void reportError(VjoValidationCtx ctx, IJstProperty jstProperty, String groupId) {
        String[] propertyArgs = new String[]{jstProperty.getName() != null && jstProperty.getName().getName() != null ? jstProperty.getName().getName() : "NULL"};
        BaseVjoSemanticRuleCtx finalPropertyShouldInitializedRuleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstProperty.getName(), groupId, propertyArgs);
        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().FINAL_PROPERTY_SHOULD_BE_INITIALIZED, finalPropertyShouldInitializedRuleCtx);
    }

    private void validateEType(VjoValidationCtx ctx, JstType jstType, Map<String, List<IJstMethod>> instanceMethodMap) {
        JstModifiers constructorMod;
        Object ruleCtx;
        if (jstType.getModifiers().isAbstract()) {
            BaseVjoSemanticRuleCtx ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ETYPE_SHOULD_NOT_BE_ABSTRACT_OR_PRIVATE_OR_PROTECTED, ruleCtx2);
        }
        for (IJstProperty prop : jstType.getProperties()) {
            if (!prop.isPrivate() || prop instanceof ISynthesized || !jstType.equals(prop.getOwnerType()) || ctx.getPropertyStatesTable().hasReferences(prop)) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)prop.getName(), ctx.getGroupId(), new String[]{prop.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().PRIVATE_PROPERTY_REFERENCED_NOWHERE, ruleCtx);
        }
        for (IJstMethod meth : jstType.getMethods()) {
            if (meth.isAbstract()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), meth.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ETYPE_SHOULD_NOT_DEFINE_ABSTRACT_METHOD_OR_PROPERTY, ruleCtx);
            }
            if (!this.isPrivateMethod(meth) || !jstType.equals(meth.getOwnerType()) || ctx.getMethodInvocationTable().hasReferences(meth)) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)meth.getName(), ctx.getGroupId(), new String[]{meth.getName().getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().PRIVATE_METHOD_REFERENCED_NOWHERE, ruleCtx);
        }
        HashSet<String> dupEnumValueProtect = new HashSet<String>();
        for (IJstProperty enumProp : jstType.getEnumValues()) {
            String enumPropName = enumProp.getName().getName();
            if (jstType.getEnumValue(enumPropName) == null) continue;
            if (dupEnumValueProtect.contains(enumPropName)) {
                BaseVjoSemanticRuleCtx ruleCtx3 = new BaseVjoSemanticRuleCtx((IJstNode)enumProp.getName(), ctx.getGroupId(), new String[]{jstType.getName(), enumPropName});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ETYPE_SHOULD_NOT_HAVE_DUP_ENUM_VALUES, ruleCtx3);
                continue;
            }
            dupEnumValueProtect.add(enumPropName);
        }
        this.checkFinalProperties(ctx, jstType);
        if (jstType.getConstructor() != null && ((constructorMod = jstType.getConstructor().getModifiers()).isPublic() || constructorMod.isProtected())) {
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ETYPE_SHOULD_NOT_DEFINE_PUBLIC_OR_PROTECTED_CONSTRUCTOR, ruleCtx);
        }
        for (IJstType interfaceType : jstType.getSatisfies()) {
            interfaceType = ctx.getTypeSpaceType(interfaceType);
            if (!ctx.getUnresolvedTypes().contains(interfaceType.getName()) && !interfaceType.isInterface()) {
                BaseVjoSemanticRuleCtx ruleCtx4 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), interfaceType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CTYPE_SHOULD_NOT_IMPLEMENT_NONE_ITYPE_INTERFACE, ruleCtx4);
            }
            this.validateOverride(ctx, jstType, interfaceType);
        }
    }

    private void validateOverride(VjoValidationCtx ctx, JstType jstType, IJstType extendType) {
        List extTypeMtds;
        JstTypeWithArgs typeWithArgs = null;
        if (extendType instanceof JstTypeWithArgs) {
            typeWithArgs = (JstTypeWithArgs)extendType;
            extendType = typeWithArgs.getType();
        }
        if ((extTypeMtds = extendType.getMethods(false, true)) != null) {
            for (IJstMethod extTypeMtd : extTypeMtds) {
                IJstMethod toExtMethod;
                if (extTypeMtd == null || this.isPrivateMethod(toExtMethod = extTypeMtd)) continue;
                IJstMethod candidateMtd = jstType.getMethod(toExtMethod.getName().getName(), false, true);
                JstType candidateType = jstType;
                if (candidateMtd != null) {
                    while (candidateType != null && candidateType.getMethod(candidateMtd.getName().getName(), false, false) != candidateMtd) {
                        candidateType = candidateType.getExtend();
                    }
                } else {
                    candidateType = null;
                }
                boolean overriden = false;
                IJstMethod implMethodFound = null;
                if (candidateMtd != null) {
                    IJstMethod implMethod = candidateMtd;
                    if (implMethod.equals(toExtMethod)) {
                        overriden = false;
                    } else if (implMethod.isAbstract()) {
                        overriden = false;
                    } else {
                        overriden = true;
                        implMethodFound = implMethod;
                    }
                }
                if (overriden && implMethodFound != null) {
                    BaseVjoSemanticRuleCtx ruleCtx;
                    JstTypeWithArgs implType = null;
                    if (candidateType != null && candidateType instanceof JstTypeWithArgs) {
                        implType = (JstTypeWithArgs)candidateType;
                    }
                    if (toExtMethod.isFinal()) {
                        ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)implMethodFound.getName(), ctx.getGroupId(), new String[]{toExtMethod.getName().getName()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().FINAL_METHOD_SHOULD_NOT_BE_OVERRIDEN, ruleCtx);
                    }
                    if (toExtMethod.isPublic() && !implMethodFound.isPublic() || toExtMethod.isProtected() && this.isPrivateMethod(implMethodFound)) {
                        ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)implMethodFound.getName(), ctx.getGroupId(), new String[]{toExtMethod.getName().getName()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OVERRIDE_METHOD_SHOULD_NOT_REDUCE_VISIBILITY, ruleCtx);
                        continue;
                    }
                    if (this.isCompatibleMethod(typeWithArgs, implType, toExtMethod, implMethodFound)) continue;
                    if (toExtMethod.isAbstract() || extendType.isInterface()) {
                        ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{toExtMethod.getName().getName()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ABSTRACT_METHOD_MUST_BE_IMPLEMENTED, ruleCtx);
                        continue;
                    }
                    if (candidateMtd instanceof ISynthesized) continue;
                    ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)implMethodFound.getName(), ctx.getGroupId(), new String[]{toExtMethod.getName().getName()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OVERRIDE_METHOD_SHOULD_HAVE_COMPATIBLE_SIGNATURE, ruleCtx);
                    continue;
                }
                if (overriden || !toExtMethod.isAbstract() && !toExtMethod.getOwnerType().isInterface() && !extendType.isInterface()) continue;
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{toExtMethod.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ABSTRACT_METHOD_MUST_BE_IMPLEMENTED, ruleCtx);
            }
        }
    }

    private void validateTypeName(VjoValidationCtx ctx, JstType jstType) {
        if (jstType.isFakeType()) {
            return;
        }
        if (jstType.getName() != null) {
            String[] splitted;
            BaseVjoSemanticRuleCtx ruleCtx;
            String typeSimpleName = jstType.getSimpleName();
            TypeNameShouldNotBeEmptyRuleCtx notEmptyTypeNameruleCtx = new TypeNameShouldNotBeEmptyRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{typeSimpleName}, typeSimpleName);
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().TYPE_NAME_SHOULD_NOT_BE_EMPTY, notEmptyTypeNameruleCtx);
            Matcher m = s_typePattern.matcher(jstType.getName());
            if (!m.matches()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CLASS_NAME_CANNOT_HAVE_ILLEGAL_TOKEN, ruleCtx);
            }
            if (!jstType.isMetaType() && jstType.getContainingType() == null && jstType.getOuterType() == null) {
                ruleCtx = new ClassBetterStartWithCapitalLetterRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{typeSimpleName}, typeSimpleName);
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CLASS_BETTER_START_WITH_NONE_CAPITAL_LETTER, ruleCtx);
            }
            String[] stringArray = splitted = jstType.getName().split("\\.");
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                String section = stringArray[n2];
                if (this.isVjoKeyword(section, VjoConstants.JAVA_FULL_KEYWORDS)) {
                    BaseVjoSemanticRuleCtx ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CLASS_NAME_CANNOT_HAVE_ILLEGAL_TOKEN, ruleCtx2);
                    break;
                }
                ++n2;
            }
        }
    }

    private void validateTypePath(VjoValidationCtx ctx, JstType jstType) {
        String jstTypePath;
        JstSource.IBinding jstTypeBnd;
        JstSource jstTypeSource;
        if (jstType.isFakeType()) {
            return;
        }
        if (jstType.getModifiers().isPublic() && jstType.getContainingType() == null && (jstTypeSource = jstType.getSource()) != null && (jstTypeBnd = jstTypeSource.getBinding()) != null && jstTypeBnd instanceof FileBinding && (jstTypePath = jstTypeBnd.getName()) != null) {
            if (jstTypePath.indexOf(File.separatorChar) >= 0) {
                jstTypePath = jstTypePath.replace(File.separatorChar, '.');
            }
            if (jstType.getPackage() != null) {
                boolean isPackageValid = true;
                String pkgPath = this.getPkgPath(jstTypePath, jstType.getPackage().getGroupName(), this.getFileName(jstTypePath));
                String pkgName = jstType.getPackage().getName();
                if (pkgName.length() > 0 && !pkgPath.endsWith(pkgName)) {
                    isPackageValid = false;
                }
                if (pkgName.length() == 0 && pkgPath.length() != 0) {
                    isPackageValid = false;
                } else {
                    String typeName = jstType.getSimpleName();
                    String fileName = this.getFileName(jstTypePath);
                    if (typeName == null) {
                        isPackageValid = false;
                    } else if (!typeName.equals(fileName)) {
                        isPackageValid = false;
                    }
                }
                if (!isPackageValid) {
                    BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName(), jstTypeBnd.getName()});
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().PUBLIC_CLASS_SHOULD_RESIDE_IN_CORRESPONDING_FILE, ruleCtx);
                }
            }
        }
        if (jstType.getContainingType() == null && jstType.getOuterType() == null && (jstType.getModifiers().isProtected() || jstType.getModifiers().isPrivate())) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{jstType.getName()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().MAIN_CLASS_SHOULD_BE_PUBLIC, ruleCtx);
        }
    }

    private String getFileName(String jstTypePath) {
        String fileName = jstTypePath.substring(0, jstTypePath.lastIndexOf(46));
        fileName = fileName.substring(fileName.lastIndexOf(46) + 1);
        return fileName;
    }

    private String getPkgPath(String jstTypePath, String groupName, String fileName) {
        String pkgPath = null;
        int groupIndex = jstTypePath.indexOf(groupName);
        if (groupIndex > 0) {
            String temp = jstTypePath.substring(groupIndex + groupName.length() + 1);
            int fileNameIndex = (temp = temp.substring(temp.indexOf(46) + 1)).lastIndexOf(fileName);
            pkgPath = fileNameIndex > 0 && fileNameIndex - 1 < temp.length() ? temp.substring(0, fileNameIndex - 1) : "";
        } else {
            pkgPath = jstTypePath.substring(0, jstTypePath.lastIndexOf(fileName) - 1);
        }
        return pkgPath;
    }

    private void validateBeforeAll(VjoValidationCtx ctx, JstType jstType) {
        List<IScriptProblem> syntaxProblems = ctx.getSyntaxProblems((IJstType)jstType);
        if (syntaxProblems != null && syntaxProblems.size() > 0) {
            for (IScriptProblem syntaxProblem : syntaxProblems) {
                VjoSemanticProblem semanticProblem = new VjoSemanticProblem(syntaxProblem.getArguments(), syntaxProblem.getID() != null ? syntaxProblem.getID() : VjoSyntaxProbIds.IncorrectVjoSyntax, syntaxProblem.getMessage(), syntaxProblem.getOriginatingFileName(), syntaxProblem.getSourceStart(), syntaxProblem.getSourceEnd(), syntaxProblem.getSourceLineNumber(), syntaxProblem.getColumn(), syntaxProblem.type());
                ctx.addProblem((IJstNode)jstType, semanticProblem);
            }
            throw new VjoValidationRuntimeException("syntax problems found");
        }
    }

    public boolean isCompatibleMethod(JstTypeWithArgs typeWithArgsContract, JstTypeWithArgs typeWithArgsImpl, IJstMethod contract, IJstMethod impl) {
        List<IJstMethod> contractOverloaded = this.getApi(contract);
        block0: for (IJstMethod contractMtd : contractOverloaded) {
            List<IJstMethod> implOverloaded = this.getApi(impl);
            for (IJstMethod implMtd : implOverloaded) {
                if (this.isCompatibleMethodNoOverload(typeWithArgsContract, typeWithArgsImpl, contractMtd, implMtd)) continue block0;
            }
            return false;
        }
        return true;
    }

    private List<IJstMethod> getApi(IJstMethod contract) {
        LinkedList<IJstMethod> contractOverloaded = new LinkedList<IJstMethod>();
        if (!contract.isDispatcher()) {
            contractOverloaded.add(contract);
        } else {
            contractOverloaded.addAll(contract.getOverloaded());
        }
        return contractOverloaded;
    }

    private boolean isCompatibleMethodNoOverload(JstTypeWithArgs typeWithArgsContract, JstTypeWithArgs typeWithArgsImpl, IJstMethod contract, IJstMethod impl) {
        JstArg lastRhsArg;
        List args = contract.getArgs();
        ArrayList<JstArg> mArgs = new ArrayList<JstArg>(impl.getArgs());
        if (mArgs.size() > args.size() && mArgs.size() > 0 && (lastRhsArg = (JstArg)mArgs.get(mArgs.size() - 1)) != null && lastRhsArg.isVariable()) {
            int i = mArgs.size();
            while (i < args.size()) {
                mArgs.add(lastRhsArg);
                ++i;
            }
        }
        if (args.size() != mArgs.size()) {
            return false;
        }
        int i = 0;
        int len = args.size();
        while (i < len) {
            JstArg arg = (JstArg)args.get(i);
            JstArg mArg = (JstArg)mArgs.get(i);
            IJstType argType = arg.getType();
            if (typeWithArgsContract != null && argType instanceof JstParamType) {
                argType = typeWithArgsContract.getParamArgType((JstParamType)argType);
            }
            IJstType mArgType = mArg.getType();
            if (typeWithArgsImpl != null && mArgType instanceof JstParamType) {
                mArgType = typeWithArgsImpl.getParamArgType((JstParamType)mArgType);
            }
            if (argType instanceof JstTypeWithArgs && mArgType instanceof JstTypeWithArgs ? !TypeCheckUtil.isAssignable(typeWithArgsContract, typeWithArgsImpl, (JstTypeWithArgs)argType, (JstTypeWithArgs)mArgType) : !TypeCheckUtil.isAssignable(argType, mArgType)) {
                return false;
            }
            ++i;
        }
        IJstType rtnType = contract.getRtnType();
        IJstType mRtnType = impl.getRtnType();
        if (typeWithArgsContract != null && rtnType instanceof JstParamType) {
            rtnType = typeWithArgsContract.getParamArgType((JstParamType)rtnType);
        }
        if (typeWithArgsImpl != null && mRtnType instanceof JstParamType) {
            mRtnType = typeWithArgsImpl.getParamArgType((JstParamType)mRtnType);
        }
        return !(rtnType instanceof JstTypeWithArgs && mRtnType instanceof JstTypeWithArgs ? !TypeCheckUtil.isAssignable(typeWithArgsContract, typeWithArgsImpl, (JstTypeWithArgs)rtnType, (JstTypeWithArgs)mRtnType) : !TypeCheckUtil.isAssignable(rtnType, mRtnType));
    }
}

