/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.vjo;

import org.eclipse.vjet.dsf.jsgen.shared.vjo.BaseGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class JsCoreGenerator
extends BaseGenerator {
    public JsCoreGenerator(GeneratorCtx ctx) {
        super(ctx);
    }

    public JsCoreGenerator writeNameValue(String name, String value, boolean hasMore) {
        return this.writeNameValue(name, value, hasMore, true);
    }

    public JsCoreGenerator writeNameValue(String name, String value, boolean hasMore, boolean addNewLine) {
        if (addNewLine) {
            this.writeIndent();
        }
        this.getWriter().append(name).append(":").append(value);
        if (hasMore) {
            this.getWriter().append(",");
        }
        if (addNewLine) {
            this.writeNewline();
        }
        return this;
    }

    public JsCoreGenerator writeNameValue(String name, boolean value, boolean hasMore) {
        return this.writeNameValue(name, String.valueOf(value), hasMore);
    }

    public JsCoreGenerator writeNameValue(String name, long value, boolean hasMore) {
        return this.writeNameValue(name, String.valueOf(value), hasMore);
    }

    public JsCoreGenerator writeNameValue(String name, double value, boolean hasMore) {
        return this.writeNameValue(name, String.valueOf(value), hasMore);
    }

    public JsCoreGenerator startWriteFunc(Object ... args) {
        this.getWriter().append(JsCoreKeywords.FUNCTION);
        if (args != null && args.length > 0) {
            this.getWriter().append("(");
            int i = 0;
            while (i < args.length) {
                if (args[i] != null) {
                    if (i > 0) {
                        this.getWriter().append(",");
                    }
                    this.getWriter().append(args[i].toString());
                }
                ++i;
            }
            this.getWriter().append("){");
        } else {
            this.getWriter().append("(){");
        }
        this.indent();
        return this;
    }

    public JsCoreGenerator endWriteFunc(boolean hasMore, boolean isMetaType) {
        this.outdent();
        this.writeNewline();
        this.writeIndent();
        if (!isMetaType) {
            this.getWriter().append("}");
        }
        if (hasMore) {
            this.getWriter().append(",");
        }
        return this;
    }

    public JsCoreGenerator writeInstanceVarAssignment(String varName, IExpr expr) {
        this.writeIndent();
        this.getWriter().append(JsCoreKeywords.THIS).append(".").append(varName).append("=").append(expr.toExprText()).append(";");
        this.writeNewline();
        return this;
    }

    public JsCoreGenerator writeInstanceFuncCall(String funcName, Object ... args) {
        this.writeIndent();
        this.getWriter().append(JsCoreKeywords.THIS).append(".").append(funcName).append("(");
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    this.getWriter().append(",");
                }
                this.getWriter().append(args[i].toString());
                ++i;
            }
        }
        this.getWriter().append(");");
        this.writeNewline();
        return this;
    }

    public JsCoreGenerator writeReturn(String value) {
        this.writeIndent();
        this.getWriter().append(JsCoreKeywords.RETURN).append(" ").append(value).append(";");
        this.writeNewline();
        return this;
    }

    public JsCoreGenerator writeReturn(boolean value) {
        return this.writeReturn(String.valueOf(value));
    }

    public JsCoreGenerator writeReturn(long value) {
        return this.writeReturn(String.valueOf(value));
    }

    public JsCoreGenerator writeReturn(double value) {
        return this.writeReturn(String.valueOf(value));
    }

    public JsCoreGenerator writeReturn(Object value) {
        return this.writeReturn(String.valueOf(value));
    }
}

