/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstArg
extends BaseJstNode {
    private static final long serialVersionUID = 1L;
    private final List<IJstTypeReference> m_types = new ArrayList<IJstTypeReference>();
    private final String m_name;
    private boolean m_isVariable;
    private boolean m_isOptional;
    private final boolean m_isFinal;

    public JstArg(IJstType type, String name, boolean isVarargs) {
        this(new JstTypeReference(type), name, isVarargs);
    }

    public JstArg(IJstType type, String name, boolean isVarargs, boolean isOptional) {
        this(new JstTypeReference(type), name, isVarargs, isOptional);
    }

    public JstArg(IJstType type, String name, boolean isVarargs, boolean isOptional, boolean isFinal) {
        this(new JstTypeReference(type), name, isVarargs, isOptional, isFinal);
    }

    public JstArg(IJstTypeReference type, String name, boolean isVarargs) {
        this.m_types.add(type);
        this.m_name = name;
        this.m_isVariable = isVarargs;
        this.m_isOptional = false;
        this.m_isFinal = false;
    }

    public JstArg(IJstTypeReference type, String name, boolean isVarargs, boolean isOptional) {
        this.m_types.add(type);
        this.m_name = name;
        this.m_isVariable = isVarargs;
        this.m_isOptional = isOptional;
        this.m_isFinal = false;
    }

    public JstArg(IJstTypeReference type, String name, boolean isVarargs, boolean isOptional, boolean isFinal) {
        this.m_types.add(type);
        this.m_name = name;
        this.m_isVariable = isVarargs;
        this.m_isOptional = isOptional;
        this.m_isFinal = isFinal;
    }

    public JstArg(List<IJstType> types, String name, boolean isVarargs, boolean isOptional) {
        assert (name != null) : "name is null";
        this.addTypes(types);
        this.m_name = name;
        this.m_isVariable = isVarargs;
        this.m_isOptional = isOptional;
        this.m_isFinal = false;
    }

    public JstArg(List<IJstType> types, String name, boolean isVarargs, boolean isOptional, boolean isFinal) {
        assert (name != null) : "name is null";
        this.addTypes(types);
        this.m_name = name;
        this.m_isVariable = isVarargs;
        this.m_isOptional = isOptional;
        this.m_isFinal = isFinal;
    }

    public JstArg(List<? extends IJstTypeReference> types, int a, String name, boolean isVarargs, boolean isOptional) {
        assert (name != null) : "name is null";
        this.addTypesRefs(types);
        this.m_name = name;
        this.m_isVariable = isVarargs;
        this.m_isOptional = isOptional;
        this.m_isFinal = false;
    }

    public JstArg(List<? extends IJstTypeReference> types, int a, String name, boolean isVarargs, boolean isOptional, boolean isFinal) {
        assert (name != null) : "name is null";
        this.addTypesRefs(types);
        this.m_name = name;
        this.m_isVariable = isVarargs;
        this.m_isOptional = isOptional;
        this.m_isFinal = isFinal;
    }

    public IJstType getType() {
        return this.getTypeRef().getReferencedType();
    }

    public IJstTypeReference getTypeRef() {
        if (this.m_types.size() > 0) {
            return this.m_types.get(0);
        }
        return new JstTypeReference(JstCache.getInstance().getType("Object"));
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isVariable() {
        return this.m_isVariable;
    }

    public void setVariable(boolean isVariable) {
        this.m_isVariable = isVariable;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.m_isOptional = isOptional;
    }

    public boolean isFinal() {
        return this.m_isFinal;
    }

    public List<IJstType> getTypes() {
        return JstType.unwrap(this.m_types);
    }

    public List<IJstTypeReference> getTypesRef() {
        return Collections.unmodifiableList(this.m_types);
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        Z z = new Z();
        z.format("m_name", (Object)this.m_name);
        z.format("m_types", this.m_types);
        z.format("m_isVariable", this.m_isVariable);
        z.format("m_isOptional", this.m_isOptional);
        return z.toString();
    }

    public void addType(IJstType type) {
        if (!this.isTypeExists(type)) {
            JstTypeReference jt = new JstTypeReference(type);
            this.m_types.add(jt);
            this.addChild(jt);
        }
    }

    public void addTypes(List<IJstType> types) {
        for (IJstType t : types) {
            if (this.isTypeExists(t)) continue;
            JstTypeReference jt = new JstTypeReference(t);
            this.m_types.add(jt);
            this.addChild(jt);
        }
    }

    public void addTypesRefs(List<? extends IJstTypeReference> types) {
        for (IJstTypeReference iJstTypeReference : types) {
            if (this.isTypeExists(iJstTypeReference.getReferencedType())) continue;
            this.m_types.add(iJstTypeReference);
            this.addChild(iJstTypeReference);
        }
    }

    public void updateType(String fullName, IJstType newType) {
        int i = 0;
        while (i < this.m_types.size()) {
            IJstTypeReference type = this.m_types.get(i);
            if (type.getReferencedType().getName().equals(fullName)) {
                this.m_types.set(i, new JstTypeReference(newType));
            }
            ++i;
        }
    }

    public void clearTypes() {
        this.m_types.clear();
    }

    private boolean isTypeExists(IJstType type) {
        int i = 0;
        while (i < this.m_types.size()) {
            if (type.getName() != null && type.getName().equals(this.m_types.get(i).getReferencedType().getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

