/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeMixer;

public class JstMixedType
extends JstTypeMixer {
    private static final long serialVersionUID = 1L;

    public JstMixedType(List<IJstType> types) {
        super("_object_");
        this.addExtend(JstCache.getInstance().getType("Object"));
        this.m_types = types;
    }

    public List<IJstType> getMixedTypes() {
        return this.m_types;
    }

    @Override
    public JstModifiers getModifiers() {
        if (this.m_types == null) {
            return super.getModifiers();
        }
        JstModifiers modifiers = new JstModifiers();
        for (IJstType t : this.getMixedTypes()) {
            modifiers.merge(t.getModifiers().getFlags());
        }
        return modifiers;
    }

    @Override
    public String getSimpleName() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean isFirst = true;
        for (IJstType t : this.m_types) {
            if (!isFirst) {
                sb.append("+");
            }
            sb.append(t.getSimpleName());
            isFirst = false;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean isFirst = true;
        for (IJstType t : this.m_types) {
            if (!isFirst) {
                sb.append("+");
            }
            sb.append(t.getName());
            isFirst = false;
        }
        sb.append("]");
        return sb.toString();
    }
}

