/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstObjectLiteralType
extends JstType
implements IJstOType {
    private static final long serialVersionUID = 1L;
    private List<IJstProperty> m_optionalFields = new ArrayList<IJstProperty>();
    private JstMethod m_constructor = null;

    public JstObjectLiteralType(String name) {
        super(name);
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public List<IJstProperty> getOptionalFields() {
        return Collections.unmodifiableList(this.m_optionalFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOptionalField(IJstProperty optionalField) {
        JstObjectLiteralType jstObjectLiteralType = this;
        synchronized (jstObjectLiteralType) {
            this.m_optionalFields.add(optionalField);
        }
    }

    public boolean hasOptionalFields() {
        return !this.m_optionalFields.isEmpty();
    }

    public boolean isOptionalField(IJstProperty pty) {
        return this.m_optionalFields.contains(pty);
    }

    @Override
    public JstMethod getConstructor() {
        if (this.m_constructor == null) {
            JstModifiers modifiers = new JstModifiers();
            modifiers.setPublic();
            List<IJstProperty> fields = this.getProperties(false);
            JstArg[] argsArray = this.getContructorArgs(fields.size() - 1, fields);
            this.m_constructor = new JstConstructor(modifiers, argsArray);
            if (this.hasOptionalFields()) {
                int i = 0;
                while (i < fields.size()) {
                    if (this.m_optionalFields.contains(fields.get(i))) {
                        int j = i - 1;
                        while (j < fields.size() - 1) {
                            JstConstructor overloaded = new JstConstructor(this.getContructorArgs(j, fields));
                            overloaded.setParent(this.m_constructor, false);
                            this.m_constructor.addOverloaded(overloaded);
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            }
            this.addChild(this.m_constructor);
        }
        return this.m_constructor;
    }

    private JstArg[] getContructorArgs(int endIndex, List<IJstProperty> fields) {
        int size = endIndex + 1;
        JstArg[] argsArray = new JstArg[size];
        int i = 0;
        while (i < size) {
            IJstProperty field = fields.get(i);
            argsArray[i] = new JstArg(field.getType(), field.getName().getName(), false);
            ++i;
        }
        return argsArray;
    }
}

