/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public abstract class JstTypeMixer
extends JstType {
    private static final long serialVersionUID = 1L;
    protected List<IJstType> m_types;
    private static final List<IJstMethod> EMPTY_MTD_LIST = new ArrayList<IJstMethod>(0);
    private static final List<IJstProperty> EMPTY_PROP_LIST = new ArrayList<IJstProperty>(0);

    protected JstTypeMixer(String name) {
        super(name);
    }

    @Override
    public List<IJstProperty> getAllPossibleProperties(boolean isStatic, boolean recursive) {
        if (isStatic) {
            return EMPTY_PROP_LIST;
        }
        ArrayList<IJstProperty> allPtys = new ArrayList<IJstProperty>();
        HashSet<String> names = new HashSet<String>();
        for (IJstType type : this.m_types) {
            List<IJstProperty> ptys = null;
            ptys = type instanceof IJstRefType ? type.getAllPossibleProperties(true, recursive) : type.getAllPossibleProperties(false, recursive);
            if (ptys == null) continue;
            for (IJstProperty pty : ptys) {
                String ptyName = pty.getName().getName();
                if (names.contains(ptyName)) continue;
                names.add(ptyName);
                allPtys.add(pty);
            }
        }
        return allPtys;
    }

    @Override
    public List<IJstType> getExtends() {
        ArrayList<IJstType> _extends = new ArrayList<IJstType>();
        for (IJstType type : this.m_types) {
            _extends.addAll(type.getExtends());
        }
        return _extends;
    }

    @Override
    public List<IJstTypeReference> getExtendsRef() {
        ArrayList<IJstTypeReference> _extends = new ArrayList<IJstTypeReference>();
        for (IJstType type : this.m_types) {
            _extends.addAll(type.getExtendsRef());
        }
        return _extends;
    }

    @Override
    public List<IJstType> getAllDerivedTypes() {
        ArrayList<IJstType> types = new ArrayList<IJstType>();
        for (IJstType type : this.m_types) {
            for (IJstType mixin : this.getMixins()) {
                if (mixin instanceof JstProxyType) {
                    JstProxyType pt = (JstProxyType)mixin;
                    types.add(pt.getType());
                    continue;
                }
                if (!(mixin instanceof JstType)) continue;
                types.add(mixin);
            }
            types.addAll(type.getExtends());
            types.addAll(type.getMixins());
        }
        return types;
    }

    @Override
    public IJstMethod getInstanceMethod(String name) {
        return this.getInstanceMethod(name, false);
    }

    @Override
    public IJstMethod getInstanceMethod(String name, boolean recursive) {
        IJstMethod mtd = null;
        for (IJstType type : this.m_types) {
            mtd = type instanceof IJstRefType ? type.getStaticMethod(name, recursive) : type.getInstanceMethod(name, recursive);
            if (mtd == null) continue;
            return mtd;
        }
        return null;
    }

    @Override
    public List<IJstMethod> getInstanceMethods() {
        return this.getMethods(false, false);
    }

    @Override
    public List<IJstProperty> getInstanceProperties() {
        return this.getAllPossibleProperties(false, false);
    }

    @Override
    public IJstProperty getInstanceProperty(String name) {
        return this.getInstanceProperty(name, false);
    }

    @Override
    public IJstProperty getInstanceProperty(String name, boolean recursive) {
        IJstProperty pty = null;
        for (IJstType type : this.m_types) {
            pty = type instanceof IJstRefType ? type.getStaticProperty(name, recursive) : type.getInstanceProperty(name, recursive);
            if (pty == null) continue;
            return pty;
        }
        return null;
    }

    @Override
    public IJstMethod getMethod(String name) {
        return this.getInstanceMethod(name);
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic) {
        if (isStatic) {
            return null;
        }
        return this.getInstanceMethod(name);
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic, boolean recursive) {
        if (isStatic) {
            return null;
        }
        return this.getInstanceMethod(name, recursive);
    }

    @Override
    public List<IJstMethod> getMethods() {
        return this.getInstanceMethods();
    }

    @Override
    public List<IJstMethod> getMethods(boolean isStatic) {
        if (isStatic) {
            return EMPTY_MTD_LIST;
        }
        return this.getInstanceMethods();
    }

    @Override
    public List<IJstMethod> getMethods(boolean isStatic, boolean recursive) {
        if (isStatic) {
            return EMPTY_MTD_LIST;
        }
        ArrayList<IJstMethod> allMtds = new ArrayList<IJstMethod>();
        HashSet<String> names = new HashSet<String>();
        for (IJstType type : this.m_types) {
            List<? extends IJstMethod> mtds = null;
            mtds = type instanceof IJstRefType ? type.getMethods(true, recursive) : type.getMethods(false, recursive);
            if (mtds == null) continue;
            for (IJstMethod iJstMethod : mtds) {
                String mtdName = iJstMethod.getName().getName();
                if (names.contains(mtdName)) continue;
                names.add(mtdName);
                allMtds.add(iJstMethod);
            }
        }
        return allMtds;
    }

    @Override
    public List<IJstProperty> getProperties() {
        return this.getInstanceProperties();
    }

    @Override
    public List<IJstProperty> getProperties(boolean isStatic) {
        if (isStatic) {
            return EMPTY_PROP_LIST;
        }
        return this.getInstanceProperties();
    }

    @Override
    public IJstProperty getProperty(String name) {
        return this.getInstanceProperty(name);
    }

    @Override
    public IJstProperty getProperty(String name, boolean isStatic) {
        if (isStatic) {
            return null;
        }
        return this.getInstanceProperty(name);
    }

    @Override
    public IJstProperty getProperty(String name, boolean isStatic, boolean recursive) {
        if (isStatic) {
            return null;
        }
        return this.getInstanceProperty(name, recursive);
    }

    @Override
    public IJstMethod getStaticMethod(String name) {
        return null;
    }

    @Override
    public IJstMethod getStaticMethod(String name, boolean recursive) {
        return null;
    }

    @Override
    public List<IJstMethod> getStaticMethods() {
        return EMPTY_MTD_LIST;
    }

    @Override
    public List<IJstProperty> getStaticProperties() {
        return EMPTY_PROP_LIST;
    }

    @Override
    public IJstProperty getStaticProperty(String name) {
        return null;
    }

    @Override
    public IJstProperty getStaticProperty(String name, boolean recursive) {
        return null;
    }

    @Override
    public boolean hasInstanceMethod(String mtdName, boolean recursive) {
        return this.getInstanceMethod(mtdName, recursive) != null;
    }

    @Override
    public boolean hasInstanceMethods() {
        return true;
    }

    @Override
    public boolean hasInstanceProperties() {
        return true;
    }

    @Override
    public boolean hasInstanceProperty(String name, boolean recursive) {
        return this.getInstanceProperty(name, recursive) != null;
    }

    @Override
    public boolean hasStaticMethod(String mtdName, boolean recursive) {
        return false;
    }

    @Override
    public boolean hasStaticMethods() {
        return false;
    }

    @Override
    public boolean hasStaticProperties() {
        return false;
    }

    @Override
    public boolean hasStaticProperty(String name, boolean recursive) {
        return false;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
    }
}

