/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstVars
extends BaseJstNode
implements IInitializer,
IStmt {
    private static final long serialVersionUID = 1L;
    private IJstTypeReference m_typeRef;
    private JstInitializer m_initializer;
    private boolean m_final = false;

    public JstVars(IJstType type) {
        this(new JstTypeReference(type));
    }

    public JstVars(IJstType type, JstInitializer initializers) {
        this(new JstTypeReference(type), initializers);
    }

    public JstVars(IJstTypeReference typeRef) {
        this.m_typeRef = typeRef;
        this.addChild(this.m_typeRef);
    }

    public JstVars(IJstTypeReference typeRef, JstInitializer initializers) {
        this.m_typeRef = typeRef;
        this.addChild(this.m_typeRef);
        this.m_initializer = initializers;
        this.addChild(this.m_initializer);
    }

    @Override
    public IJstType getType() {
        if (this.m_typeRef != null) {
            return this.m_typeRef.getReferencedType();
        }
        if (this.m_initializer != null) {
            return this.m_initializer.getType();
        }
        return null;
    }

    public void setType(IJstType type) {
        this.m_typeRef = new JstTypeReference(type);
    }

    public void setIsFinal(boolean isFinal) {
        this.m_final = isFinal;
    }

    public boolean isFinal() {
        return this.m_final;
    }

    @Override
    public String toText() {
        StringBuilder sb = new StringBuilder();
        if (this.m_typeRef != null) {
            sb.append("var ");
        }
        if (this.m_initializer != null) {
            return this.m_initializer.toText();
        }
        return sb.toString();
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toText()) + ";";
    }

    public IJstTypeReference getTypeRef() {
        return this.m_typeRef;
    }

    public void addAssignment(ILHS lhs, IExpr expr) {
        this.addAssignment(new AssignExpr(lhs, expr));
    }

    public void addAssignment(AssignExpr assignExpr) {
        if (this.m_initializer == null) {
            this.m_initializer = new JstInitializer();
        }
        this.m_initializer.addAssignment(assignExpr);
        this.addChild(assignExpr);
    }

    public JstInitializer getInitializer() {
        return this.m_initializer;
    }

    @Override
    public List<AssignExpr> getAssignments() {
        if (this.m_initializer == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_initializer.getAssignments());
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toText();
    }
}

