/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class SynthOlType
extends JstType
implements ISynthesized {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_NAME = "(obj literal)";
    private final ObjLiteral m_ol;
    private boolean m_init = false;
    private List<IJstType> m_resolvedOType;

    public SynthOlType(ObjLiteral ol) {
        this.m_ol = ol;
        this.addExtend(JstCache.getInstance().getType("ObjLiteral"));
    }

    private synchronized void init() {
        if (!this.m_init) {
            this.m_init = true;
            JstType defaultType = JstCache.getInstance().getType("ObjLiteral");
            for (NV nv : this.m_ol.getNVs()) {
                JstIdentifier id = nv.getIdentifier();
                IJstNode binding = id.getJstBinding();
                if (binding instanceof IJstMethod) {
                    this.addMethod((IJstMethod)binding);
                    continue;
                }
                IJstType type = id.getResultType();
                if (type == null || type == defaultType) {
                    IExpr expr = nv.getValue();
                    if (expr != null) {
                        type = expr.getResultType();
                    }
                    if (type == null) {
                        type = defaultType;
                    }
                }
                this.addProperty(new JstProperty(type, nv.getName(), new JstModifiers().setPublic()));
            }
        }
    }

    @Override
    public String getAlias() {
        return TYPE_NAME;
    }

    @Override
    public List<IJstProperty> getAllPossibleProperties(boolean isStatic, boolean recursive) {
        this.init();
        return super.getAllPossibleProperties(isStatic, recursive);
    }

    @Override
    public List<IJstProperty> getInstanceProperties() {
        this.init();
        return super.getInstanceProperties();
    }

    @Override
    public IJstProperty getInstanceProperty(String name) {
        this.init();
        return super.getInstanceProperty(name);
    }

    @Override
    public IJstProperty getInstanceProperty(String name, boolean recursive) {
        this.init();
        return super.getInstanceProperty(name, recursive);
    }

    @Override
    public String getName() {
        return TYPE_NAME;
    }

    @Override
    public List<IJstProperty> getProperties() {
        this.init();
        return super.getProperties();
    }

    @Override
    public List<IJstProperty> getProperties(boolean isStatic) {
        this.init();
        return super.getProperties(isStatic);
    }

    @Override
    public IJstProperty getProperty(String name) {
        this.init();
        return super.getProperty(name);
    }

    @Override
    public IJstProperty getProperty(String name, boolean isStatic) {
        this.init();
        return super.getProperty(name, isStatic);
    }

    @Override
    public IJstProperty getProperty(String name, boolean isStatic, boolean recursive) {
        this.init();
        return super.getProperty(name, isStatic, recursive);
    }

    @Override
    public String getSimpleName() {
        return TYPE_NAME;
    }

    @Override
    public boolean hasInstanceProperties() {
        this.init();
        return super.hasInstanceProperties();
    }

    @Override
    public boolean hasInstanceProperty(String name, boolean recursive) {
        this.init();
        return super.hasInstanceProperty(name, recursive);
    }

    @Override
    public JstSource getSource() {
        return this.m_ol.getSource();
    }

    @Override
    public IJstMethod getMethod(String name) {
        this.init();
        return super.getMethod(name);
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic) {
        this.init();
        return super.getMethod(name, isStatic);
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic, boolean recursive) {
        this.init();
        return super.getMethod(name, isStatic, recursive);
    }

    @Override
    public List<IJstMethod> getMethods() {
        this.init();
        return super.getMethods();
    }

    @Override
    public List<IJstMethod> getMethods(boolean isStatic) {
        this.init();
        return super.getMethods(isStatic);
    }

    @Override
    public List<IJstMethod> getMethods(boolean isStatic, boolean recursive) {
        this.init();
        return super.getMethods(isStatic, recursive);
    }

    @Override
    public boolean hasInstanceMethods() {
        this.init();
        return super.hasInstanceMethods();
    }

    @Override
    public boolean hasInstanceMethod(String mtdName, boolean recursive) {
        this.init();
        return super.hasInstanceMethod(mtdName, recursive);
    }

    @Override
    public List<IJstMethod> getInstanceMethods() {
        this.init();
        return super.getInstanceMethods();
    }

    @Override
    public IJstMethod getInstanceMethod(String name) {
        this.init();
        return super.getInstanceMethod(name);
    }

    @Override
    public IJstMethod getInstanceMethod(String name, boolean recursive) {
        this.init();
        return super.getInstanceMethod(name, recursive);
    }

    public List<IJstType> getResolvedOTypes() {
        return this.m_resolvedOType;
    }

    public void addResolvedOType(IJstType otype) {
        if (this.m_resolvedOType == null) {
            this.m_resolvedOType = new ArrayList<IJstType>();
        }
        if (!this.m_resolvedOType.contains(otype)) {
            this.m_resolvedOType.add(otype);
        }
    }
}

