/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.expr.CastExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class ParenthesizedExpr
extends ArithExpr
implements IBoolExpr {
    private static final long serialVersionUID = 1L;
    private IExpr m_term;

    public ParenthesizedExpr(IExpr term) {
        assert (term != null) : "term cannot be null";
        this.m_term = term;
        this.addChild(term);
    }

    @Override
    public IJstType getResultType() {
        return this.m_term == null ? null : this.m_term.getResultType();
    }

    @Override
    public String toExprText() {
        if (this.m_term == null) {
            return "()";
        }
        if (this.m_term instanceof JstIdentifier || this.m_term instanceof CastExpr && ((CastExpr)this.m_term).getExpr() instanceof JstIdentifier) {
            return this.m_term.toExprText();
        }
        return "(" + this.m_term.toExprText() + ")";
    }

    @Override
    public String toBoolExprText() {
        return this.toExprText();
    }

    @Override
    public String toStmtText() {
        return this.toExprText();
    }

    public void setExpression(IExpr expr) {
        this.removeChild(this.m_term);
        this.m_term = expr;
        this.addChild(this.m_term);
    }

    public IExpr getExpression() {
        return this.m_term;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }

    public static class Operator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String token;
        public static final Operator INCREMENT = new Operator("++");
        public static final Operator DECREMENT = new Operator("--");
        private static final Map<String, Operator> CODES = new HashMap<String, Operator>(20);

        static {
            Operator[] ops = new Operator[]{INCREMENT, DECREMENT};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return CODES.get(token);
        }
    }
}

