/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IIfStmt;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class IfStmt
extends BlockStmt
implements IIfStmt {
    private static final long serialVersionUID = 1L;
    private IBoolExpr m_condition;
    private JstBlock m_elseIfBlock;
    private JstBlock m_elseBlock;

    public IfStmt setCondition(IBoolExpr condition) {
        assert (condition != null) : "condition cannot be null";
        this.removeChild(this.m_condition);
        this.addChild(condition);
        this.m_condition = condition;
        return this;
    }

    @Override
    public IBoolExpr getCondition() {
        return this.m_condition;
    }

    public IfStmt addThenStmt(IStmt stmt) {
        assert (stmt != null) : "stmt cannot be null";
        this.getBody().addStmt(stmt);
        return this;
    }

    public IfStmt addElseStmt(IfStmt stmt) {
        assert (stmt != null) : "stmt cannot be null";
        this.getElseIfBlock(true).addStmt(stmt);
        return this;
    }

    public IfStmt addElseStmt(IStmt stmt) {
        assert (stmt != null) : "stmt cannot be null";
        this.getElseBlock(true).addStmt(stmt);
        return this;
    }

    @Override
    public JstBlock getElseIfBlock() {
        return this.m_elseIfBlock;
    }

    public JstBlock getElseIfBlock(boolean create) {
        if (this.m_elseIfBlock == null && create) {
            this.m_elseIfBlock = new JstBlock();
            this.addChild(this.m_elseIfBlock);
        }
        return this.m_elseIfBlock;
    }

    @Override
    public JstBlock getElseBlock() {
        return this.m_elseBlock;
    }

    public JstBlock getElseBlock(boolean create) {
        if (this.m_elseBlock == null && create) {
            this.m_elseBlock = new JstBlock();
            this.addChild(this.m_elseBlock);
        }
        return this.m_elseBlock;
    }

    @Override
    public String toStmtText() {
        if (this.m_condition == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("if(");
        sb.append(this.m_condition.toBoolExprText());
        sb.append(")");
        sb.append(this.getBody().toBlockText());
        if (this.m_elseIfBlock != null) {
            for (IStmt eif : this.m_elseIfBlock.getStmts()) {
                sb.append("else ").append(eif.toStmtText());
            }
        }
        if (this.m_elseBlock != null) {
            sb.append("else ").append(this.m_elseBlock.toBlockText());
        }
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toStmtText();
    }
}

