/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class SwitchStmt
extends BlockStmt
implements IStmt {
    private static final long serialVersionUID = 1L;
    private IExpr m_expr;

    public SwitchStmt setExpr(IExpr expr) {
        assert (expr != null) : "expr cannot be null";
        this.removeChild(this.m_expr);
        this.addChild(expr);
        this.m_expr = expr;
        return this;
    }

    public IExpr getExpr() {
        return this.m_expr;
    }

    public SwitchStmt addStmt(IStmt stmt) {
        assert (stmt != null) : "stmt cannot be null";
        this.getBody().addStmt(stmt);
        return this;
    }

    @Override
    public String toStmtText() {
        if (this.m_expr == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("switch(");
        sb.append(this.m_expr.toExprText());
        sb.append("){\n");
        sb.append(this.getBody().toBlockText());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toStmtText();
    }

    public static class CaseStmt
    extends BaseJstNode
    implements IStmt {
        private static final long serialVersionUID = 1L;
        private final IExpr m_expr;

        public CaseStmt(IExpr expr) {
            this.m_expr = expr;
            this.addChild(expr);
        }

        public IExpr getExpr() {
            return this.m_expr;
        }

        @Override
        public String toStmtText() {
            if (this.m_expr == null) {
                return "default: ";
            }
            return "case " + this.m_expr.toExprText() + ":";
        }

        @Override
        public void accept(IJstNodeVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return this.toStmtText();
        }
    }
}

