/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.FileBinding;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.ITypeSpaceLoader;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.event.EventListenerStatus;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public class JstTypeSpaceLoader
implements ITypeSpaceLoader {
    private JstTypeSpaceMgr m_tsMgr;
    private IJstTypeLoader m_typeLoader;
    public Map<String, Map<String, IJstType>> m_jstGroupTypes = new LinkedHashMap<String, Map<String, IJstType>>();

    public JstTypeSpaceLoader(JstTypeSpaceMgr tsMgr, IJstTypeLoader loader) {
        assert (tsMgr != null) : "tsMgr cannot be null";
        this.m_tsMgr = tsMgr;
        this.m_typeLoader = loader;
    }

    private synchronized boolean addType(String group, IJstType type) {
        String typeName;
        Map<String, IJstType> typeMap = this.getGroupMap(group);
        IJstType oldType = typeMap.get(typeName = type.getName());
        if (oldType != null) {
            return oldType == type;
        }
        typeMap.put(typeName, type);
        return true;
    }

    private IJstType getType(String group, String typeName) {
        Map<String, IJstType> typeMap = this.getGroupMap(group);
        return typeMap.get(typeName);
    }

    private Map<String, IJstType> getGroupMap(String group) {
        Map<String, IJstType> typeMap = this.m_jstGroupTypes.get(group);
        if (typeMap == null) {
            typeMap = new LinkedHashMap<String, IJstType>();
            this.m_jstGroupTypes.put(group, typeMap);
        }
        return typeMap;
    }

    @Override
    public EventListenerStatus<IJstType> loadJstTypesIntoTS(List<AddGroupEvent> groupList, ISourceEventCallback<IJstType> callback) {
        EventListenerStatus<IJstType> successStatus = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Successful);
        EventListenerStatus<IJstType> failedStatus = new EventListenerStatus<IJstType>(EventListenerStatus.Code.Failed);
        List<IJstTypeLoader.SourceType> jstTypeSrcList = this.m_typeLoader.loadJstTypes(groupList);
        ArrayList<IJstType> typeList = new ArrayList<IJstType>();
        IJstParseController controller = this.m_tsMgr.getJstParseController();
        float progressPercent = 0.0f;
        int total = jstTypeSrcList.size();
        boolean hasError = false;
        this.m_jstGroupTypes.clear();
        for (AddGroupEvent event : groupList) {
            try {
                this.m_tsMgr.getGroupMgr().addGroup(event.getGroupName(), event.getGroupPath(), event.getSourcePath(), event.getClassPath());
            }
            catch (Throwable e) {
                hasError = true;
                failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(event.getGroupName(), "Add group error", e));
            }
        }
        TypeSpace ts = (TypeSpace)this.m_tsMgr.getTypeSpace();
        for (AddGroupEvent event : groupList) {
            IGroup group = ts.getGroup(event.getGroupName());
            for (String d : event.getDirectDependency()) {
                group.addGroupDependency(ts.getGroup(d));
            }
        }
        for (IJstTypeLoader.SourceType srcType : jstTypeSrcList) {
            boolean isSerialized;
            block44: {
                if (srcType == null) continue;
                isSerialized = false;
                try {
                    try {
                        IJstType type = srcType.getJstType();
                        if (type != null) {
                            isSerialized = true;
                        } else if (type == null && srcType.getFile() != null) {
                            String source;
                            block43: {
                                isSerialized = false;
                                source = srcType.getSource();
                                if (source == null) {
                                    StringBuilder builder = new StringBuilder();
                                    BufferedReader reader = new BufferedReader(new FileReader(srcType.getFile()));
                                    try {
                                        try {
                                            char[] cbuf = new char[10000];
                                            int len = 0;
                                            while ((len = reader.read(cbuf)) != -1) {
                                                builder.append(cbuf, 0, len);
                                            }
                                            source = builder.toString();
                                        }
                                        catch (Exception exception) {
                                            reader.close();
                                            break block43;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        reader.close();
                                        throw throwable;
                                    }
                                    reader.close();
                                }
                            }
                            type = controller.parse(srcType.getGroupName(), srcType.getFileName(), source);
                        }
                        if (type != null) {
                            block46: {
                                JstType jstType = (JstType)type;
                                JstSource oldSource = jstType.getSource();
                                if (oldSource != null) {
                                    oldSource.setBinding(new FileBinding(srcType.getFile()));
                                } else {
                                    JstSource source = new JstSource(new FileBinding(srcType.getFile()));
                                    jstType.setSource(source);
                                }
                                if (type.getName() == null || srcType.getFileName() == null) {
                                    hasError = true;
                                    failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(srcType.getFileName(), "JstType name is null ", null));
                                    break block44;
                                }
                                typeList.add(type);
                                if (!this.addType(srcType.getGroupName(), type)) {
                                    hasError = true;
                                    failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(type.getName(), "Duplicate JstType name at path of " + srcType.getFileName(), null));
                                } else {
                                    try {
                                        try {
                                            ts.getLocker().lockExclusive();
                                            this.m_tsMgr.getTypeDependencyMgr().addTypeNoDependency(new TypeName(srcType.getGroupName(), type.getName()), type);
                                        }
                                        catch (Throwable e) {
                                            hasError = true;
                                            failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(String.valueOf(srcType.getGroupName()) + ": " + type.getName(), "type space error", e));
                                            ts.getLocker().releaseExclusive();
                                            break block46;
                                        }
                                    }
                                    catch (Throwable cbuf) {
                                        ts.getLocker().releaseExclusive();
                                        throw cbuf;
                                    }
                                    ts.getLocker().releaseExclusive();
                                }
                            }
                            if (!srcType.getFileName().equalsIgnoreCase(type.getName())) {
                                hasError = true;
                                failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(srcType.getFileName(), "JS file path doesn't match type name " + type.getName(), null));
                            }
                            break block44;
                        }
                        hasError = true;
                        failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(srcType.getFileName(), "VJO parse error", null));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        hasError = true;
                        failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(String.valueOf(srcType.getGroupName()) + ": " + srcType.getFileName(), "VJO parse error", e));
                        progressPercent = isSerialized ? (float)((double)progressPercent + 0.05 / (double)total) : (float)((double)progressPercent + 0.4 / (double)total);
                        this.notifyProgress(callback, progressPercent);
                        srcType = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    progressPercent = isSerialized ? (float)((double)progressPercent + 0.05 / (double)total) : (float)((double)progressPercent + 0.4 / (double)total);
                    this.notifyProgress(callback, progressPercent);
                    srcType = null;
                    throw throwable;
                }
            }
            progressPercent = isSerialized ? (float)((double)progressPercent + 0.05 / (double)total) : (float)((double)progressPercent + 0.4 / (double)total);
            this.notifyProgress(callback, progressPercent);
            srcType = null;
        }
        float remainingPercent = 1.0f - progressPercent;
        total = typeList.size();
        int count = 0;
        for (IJstType type : typeList) {
            try {
                System.out.println("#" + count);
                long startTime = System.nanoTime();
                System.out.println("resolving " + type.getName());
                long used1 = JstTypeSpaceLoader.memTaken();
                controller.resolve(type);
                long used2 = JstTypeSpaceLoader.memTaken();
                long endTime = System.nanoTime();
                long duration = endTime - startTime;
                System.out.println(String.valueOf(type.getName()) + "\t" + duration + "\t" + (used2 - used1));
            }
            catch (Throwable e) {
                e.printStackTrace();
                hasError = true;
                String groupName = "";
                if (type.getPackage() != null) {
                    groupName = type.getPackage().getGroupName();
                }
                failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(String.valueOf(groupName) + ": " + type.getSimpleName(), "resolve error", e));
            }
            System.out.println(String.valueOf(progressPercent += 0.4f * remainingPercent / (float)total) + "%");
            this.notifyProgress(callback, progressPercent);
            ++count;
        }
        for (String groupName : this.m_jstGroupTypes.keySet()) {
            Map<String, IJstType> typeMap = this.getGroupMap(groupName);
            for (String typeName : typeMap.keySet()) {
                block48: {
                    String typeParsedName;
                    IJstType type = typeMap.get(typeName);
                    String string = typeParsedName = type.getSimpleName() == null ? typeName : type.getName();
                    if (typeParsedName != null) {
                        try {
                            try {
                                ts.getLocker().lockExclusive();
                                this.m_tsMgr.getTypeDependencyMgr().addType(new TypeName(groupName, typeParsedName), type);
                            }
                            catch (Throwable e) {
                                hasError = true;
                                failedStatus.addErrorSource(new EventListenerStatus.ErrorSource(String.valueOf(groupName) + ": " + typeParsedName, "type space error", e));
                                ts.getLocker().releaseExclusive();
                                break block48;
                            }
                        }
                        catch (Throwable throwable) {
                            ts.getLocker().releaseExclusive();
                            throw throwable;
                        }
                        ts.getLocker().releaseExclusive();
                    }
                }
                this.notifyProgress(callback, progressPercent += 0.6f * remainingPercent / (float)total);
            }
        }
        jstTypeSrcList = null;
        if (hasError) {
            return failedStatus;
        }
        return successStatus;
    }

    static long memTaken() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public void setJstTypeLoader(IJstTypeLoader loader) {
        this.m_typeLoader = loader;
    }

    private void notifyProgress(ISourceEventCallback<IJstType> callback, float percentage) {
        if (callback == null) {
            return;
        }
        int percent = (int)((double)percentage * 100.0 + 0.5);
        if (percent > 0) {
            callback.onProgress(percent);
        }
    }
}

