/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeDependencyCollector;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.type.TypeName;

class TypeDependencyMgr {
    private static JstTypeDependencyCollector s_typeDependencyCollector = new JstTypeDependencyCollector();
    private JstTypeSpaceMgr m_tsMgr;
    private TypeSpace<IJstType, IJstNode> m_ts;

    TypeDependencyMgr(JstTypeSpaceMgr tsMgr) {
        assert (tsMgr != null) : "tsMgr cannot be null";
        this.m_tsMgr = tsMgr;
        this.m_ts = tsMgr.getTypeSpaceImpl();
    }

    public void addType(TypeName typeName, IJstType type) {
        if (type == null || typeName == null || typeName.groupName() == null) {
            return;
        }
        IJstType oldType = this.m_ts.getType(typeName);
        if (oldType != null && oldType != type) {
            throw new RuntimeException("Type alreay exists:" + typeName);
        }
        Group<IJstType> group = this.m_ts.getGroup(typeName.groupName());
        if (group == null) {
            group = this.m_tsMgr.getGroupMgr().addGroup(typeName.groupName(), null);
        }
        group.addEntity(typeName.typeName(), type);
        this.addInnerAndOTypes(group, type, true);
        this.addTypeToPackage(typeName, type);
        this.m_tsMgr.getPropertyIndexMgr().processTypeAdded(typeName, type);
        this.m_tsMgr.getMethodIndexMgr().processTypeAdded(typeName, type);
    }

    public void addInnerAndOTypes(Group<IJstType> group, IJstType type, boolean buildDependency) {
        List<? extends IJstType> innerTypes = type.getEmbededTypes();
        List<? extends IJstType> secondaryTypes = type.getSecondaryTypes();
        List<IJstOType> oTypes = type.getOTypes();
        ArrayList<IJstType> combinedTypeList = new ArrayList<IJstType>();
        if (innerTypes != null && !innerTypes.isEmpty()) {
            combinedTypeList.addAll(innerTypes);
        }
        if (oTypes != null && !oTypes.isEmpty()) {
            combinedTypeList.addAll(oTypes);
        }
        if (secondaryTypes != null && !secondaryTypes.isEmpty()) {
            combinedTypeList.addAll(secondaryTypes);
        }
        for (IJstType innerOType : combinedTypeList) {
            String typeName = innerOType.getName();
            if (typeName == null || typeName.length() <= 0) continue;
            if (buildDependency) {
                this.addType(new TypeName(group.getName(), typeName), innerOType);
                continue;
            }
            this.addTypeNoDependency(new TypeName(group.getName(), typeName), innerOType);
        }
    }

    public void removeInnerAndOTypes(Group<IJstType> group, IJstType type) {
        List<? extends IJstType> innerTypes = type.getEmbededTypes();
        List<? extends IJstType> secondaryTypes = type.getSecondaryTypes();
        List<IJstOType> oTypes = type.getOTypes();
        ArrayList<IJstType> combinedTypeList = new ArrayList<IJstType>();
        if (innerTypes != null && !innerTypes.isEmpty()) {
            combinedTypeList.addAll(innerTypes);
        }
        if (oTypes != null && !oTypes.isEmpty()) {
            combinedTypeList.addAll(oTypes);
        }
        if (secondaryTypes != null && !secondaryTypes.isEmpty()) {
            combinedTypeList.addAll(secondaryTypes);
        }
        for (IJstType innerOType : combinedTypeList) {
            String typeName = innerOType.getName();
            if (typeName == null || typeName.length() <= 0) continue;
            this.removeType(new TypeName(group.getName(), typeName));
        }
    }

    public void addTypeNoDependency(TypeName typeName, IJstType type) {
        if (type == null || typeName == null || typeName.groupName() == null) {
            return;
        }
        IJstType oldType = this.m_ts.getType(typeName);
        if (oldType != null && oldType != type) {
            throw new RuntimeException("Type alreay exists:" + typeName);
        }
        if (oldType == type) {
            return;
        }
        Group<IJstType> group = this.m_ts.getGroup(typeName.groupName());
        if (group == null) {
            group = this.m_tsMgr.getGroupMgr().addGroup(typeName.groupName(), null);
        }
        group.addEntity(typeName.typeName(), type, false);
        this.addInnerAndOTypes(group, type, false);
        this.addTypeToPackage(typeName, type);
    }

    public IJstType removeType(TypeName typeName) {
        if (typeName == null) {
            return null;
        }
        IJstType type = this.m_ts.getType(typeName);
        if (type == null) {
            throw new RuntimeException("cannot find type:" + typeName);
        }
        IGroup group = this.m_ts.getGroup(typeName.groupName());
        if (group == null) {
            throw new RuntimeException("cannot find group for type:" + typeName);
        }
        ((Group)group).removeEntity(typeName.typeName());
        this.removeInnerAndOTypes((Group<IJstType>)group, type);
        this.removeTypeFromPackage(typeName, type);
        this.m_tsMgr.getPropertyIndexMgr().processTypeRemoved(typeName);
        this.m_tsMgr.getMethodIndexMgr().processTypeRemoved(typeName);
        return type;
    }

    private void removeTypeFromPackage(TypeName typeName, IJstType type) {
        if (type != null) {
            String packageName = "";
            if (type.getPackage() != null) {
                packageName = type.getPackage().getName();
            }
            this.m_ts.removeTypeFromPackage(packageName, typeName);
        }
    }

    private void addTypeToPackage(TypeName typeName, IJstType type) {
        if (type != null) {
            String packageName = "";
            if (type.getPackage() != null) {
                packageName = type.getPackage().getName();
            }
            this.m_ts.addTypeToPackage(packageName, typeName, type);
        }
    }

    JstTypeDependencyCollector getTypeDependencyCollector() {
        return s_typeDependencyCollector;
    }
}

