/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.ts.graph.IDependencyCollector;

public class JstTypeDependencyCollector
implements IDependencyCollector<IJstType> {
    @Override
    public Map<String, IJstType> getDependency(IJstType jstType) {
        if (jstType == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IJstType> map = new LinkedHashMap<String, IJstType>();
        if (jstType.getName() != null) {
            this.addToDependency(jstType.getImports(), map);
            this.addToDependency(jstType.getExpects(), map);
            this.addToDependency(jstType.getExtends(), map);
            this.addToDependency(jstType.getInactiveImports(), map);
            this.addToDependency(jstType.getSatisfies(), map);
            this.addToDependency(jstType.getFullyQualifiedImports(), map);
            this.addToMixDependency(jstType.getMixinsRef(), map);
        }
        return map;
    }

    public Map<String, IJstTypeReference> getDependencyRefs(IJstType jstType) {
        if (jstType == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IJstTypeReference> map = new LinkedHashMap<String, IJstTypeReference>();
        if (jstType.getName() != null) {
            this.addToDependencyRef(jstType.getImportsRef(), map);
            this.addToDependencyRef(jstType.getExpectsRef(), map);
            this.addToDependencyRef(jstType.getExtendsRef(), map);
            this.addToDependencyRef(jstType.getInactiveImportsRef(), map);
            this.addToDependencyRef(jstType.getFullyQualifiedImportsRef(), map);
            this.addToDependencyRef(jstType.getSatisfiesRef(), map);
            this.addToDependencyRef(jstType.getMixinsRef(), map);
        }
        return map;
    }

    private void addToDependencyRef(List<? extends IJstTypeReference> dependencies, Map<String, IJstTypeReference> map) {
        if (dependencies != null) {
            Iterator<? extends IJstTypeReference> iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                IJstTypeReference t;
                IJstTypeReference dependency = t = iterator.next();
                map.put(dependency.getReferencedType().getName(), dependency);
            }
        }
    }

    private void addToDependency(List<? extends IJstType> dependencies, Map<String, IJstType> map) {
        if (dependencies != null) {
            Iterator<? extends IJstType> iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                IJstType t;
                IJstType dependency = t = iterator.next();
                if (t instanceof JstProxyType) {
                    dependency = t.getOwnerType();
                }
                map.put(dependency.getName(), dependency);
            }
        }
    }

    private void addToMixDependency(List<? extends IJstTypeReference> dependencies, Map<String, IJstType> map) {
        if (dependencies != null) {
            for (IJstTypeReference iJstTypeReference : dependencies) {
                IJstType type = iJstTypeReference.getReferencedType();
                map.put(type.getName(), type);
            }
        }
    }
}

