/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts.util;

import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jst.ts.util.ADependencyVisitor;
import org.eclipse.vjet.dsf.ts.graph.DependencyNode;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.method.MethodName;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public class MethodDependencyVisitor
extends ADependencyVisitor<MethodName>
implements IJstVisitor {
    @Override
    public void preVisit(IJstNode node) {
    }

    @Override
    public boolean visit(IJstNode node) {
        if (node instanceof JstIdentifier) {
            JstIdentifier identifier = (JstIdentifier)node;
            this.addDependency(identifier.getJstBinding(), identifier);
        }
        return true;
    }

    @Override
    public void endVisit(IJstNode node) {
    }

    @Override
    public void postVisit(IJstNode node) {
    }

    public Map<MethodName, List<IJstNode>> getMethodDependencies() {
        return this.m_dependencies;
    }

    private void addDependency(IJstNode binding, IJstNode dependent) {
        Group<IJstType> group;
        IJstMethod constructor;
        if (binding == null || !(binding instanceof IJstMethod)) {
            return;
        }
        IJstMethod jstMethod = (IJstMethod)binding;
        String mtdName = jstMethod.getName().getName();
        IJstType mtdOwnerType = binding.getOwnerType();
        if (mtdOwnerType == null) {
            return;
        }
        if (mtdOwnerType.getMethod(mtdName) == null && mtdOwnerType.getGlobalVar(mtdName) == null && binding != (constructor = mtdOwnerType.getConstructor())) {
            return;
        }
        String groupName = null;
        if (mtdOwnerType.getPackage() != null) {
            groupName = mtdOwnerType.getPackage().getGroupName();
        }
        if (groupName == null && this.m_ts != null && (group = this.m_ts.getGroup(mtdOwnerType)) != null) {
            groupName = group.getName();
        }
        MethodName name = new MethodName(new TypeName(groupName, mtdOwnerType.getName()), mtdName);
        if (this.m_ts != null) {
            IJstType type = (IJstType)this.m_ts.getType(name.typeName());
            if (type == null) {
                DependencyNode<Object> node = this.m_ts.getUnresolvedNodes().get(mtdOwnerType.getName());
                if (node == null) {
                    node = new DependencyNode<IJstType>(mtdOwnerType.getName(), mtdOwnerType, null);
                    this.m_ts.addUnresolvedNode(node);
                }
            } else if (JstTypeSpaceMgr.isDefaultLibName(groupName)) {
                this.addImplicitDependency(dependent, groupName, mtdOwnerType);
            }
        }
        this.add_if_absent(name, dependent);
    }
}

