/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.initialization;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.initialization.BaseInitializationContext;
import org.eclipse.vjet.dsf.common.initialization.Initializable;
import org.eclipse.vjet.dsf.common.initialization.InitializationContext;
import org.eclipse.vjet.dsf.common.initialization.InitializationException;
import org.eclipse.vjet.dsf.common.initialization.InitializationState;

public abstract class BaseInitializable
implements Initializable {
    public static final String PROP_INIT_TIME = "InitTime";
    public static final String PROP_CLASSNAME = "ClassName";
    private static int s_InitNumber = 0;
    private static int s_ShutdownNumber = 0;
    private InitializationState m_state = InitializationState.PRISTINE;
    private long m_initTime = -1L;
    private boolean m_notifyUponInitDone = false;
    private boolean m_registrationIsDone = false;
    private Map<Initializable.CharacteristicEnum, Object> m_characteristicInfoMap = new HashMap<Initializable.CharacteristicEnum, Object>();

    @Override
    public InitializationState getState() {
        return this.m_state;
    }

    @Override
    public final synchronized void doInitialize(InitializationContext context) throws InitializationException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.m_state == InitializationState.INITAILIZED) {
            return;
        }
        try {
            int num = s_InitNumber++;
            if (BaseInitializationContext.isVerbose()) {
                context.out(String.valueOf(num) + "---" + this.getClass().getName() + "--- initializing {");
            } else {
                context.out(String.valueOf(num) + ":");
            }
            long startTime = System.currentTimeMillis();
            this.initialize(context);
            long endTime = System.currentTimeMillis();
            this.m_initTime = endTime - startTime;
            if (BaseInitializationContext.isVerbose()) {
                context.out(String.valueOf(num) + "---" + this.getClass().getName() + "--- initializing } DONE - time " + this.m_initTime + "ms");
            } else {
                context.out(String.valueOf(num) + ":DONE");
            }
            this.m_state = InitializationState.INITAILIZED;
        }
        finally {
            if (this.m_state != InitializationState.INITAILIZED) {
                this.m_state = InitializationState.INITAILIZED_FAILED;
                context.out("initializing FAILED '" + this.getClass().getName() + "' }");
            }
        }
        if (!this.m_registrationIsDone) {
            this.m_registrationIsDone = true;
        }
    }

    protected abstract void initialize(InitializationContext var1);

    @Override
    public final synchronized void doShutdown(InitializationContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.m_state == InitializationState.SHUTDOWN || this.m_state == InitializationState.PRISTINE) {
            return;
        }
        try {
            int num = s_ShutdownNumber++;
            if (BaseInitializationContext.isVerbose()) {
                context.out(String.valueOf(num) + " shutdown '" + this.getClass().getName() + "' {");
            } else {
                context.out(String.valueOf(num) + ": down...");
            }
            this.shutdown(context);
            if (BaseInitializationContext.isVerbose()) {
                context.out(String.valueOf(num) + " shutdown '" + this.getClass().getName() + "' } DONE");
            } else {
                context.out(String.valueOf(num) + ": down DONE");
            }
            this.m_state = InitializationState.SHUTDOWN;
        }
        finally {
            if (this.m_state != InitializationState.SHUTDOWN) {
                this.m_state = InitializationState.SHUTDOWN_FAILED;
                context.out("shutdown FAILED'" + this.getClass().getName() + "' }");
            }
        }
    }

    protected abstract void shutdown(InitializationContext var1);

    @Override
    public boolean isNotifyUponInitDone() {
        return this.m_notifyUponInitDone;
    }

    protected void setNofifyUponInitDone(boolean notifyUponInitDone) {
        this.m_notifyUponInitDone = notifyUponInitDone;
    }

    @Override
    public void notifyInitDone() {
    }

    @Override
    public void setCharacteristicInfo(Initializable.CharacteristicEnum characteristic, Object info) {
        this.m_characteristicInfoMap.put(characteristic, info);
    }

    @Override
    public Object getCharacteristicInfo(Initializable.CharacteristicEnum characteristic) {
        return this.m_characteristicInfoMap.get(characteristic);
    }

    @Override
    public Set<?> getCharacteristics() {
        return new HashSet();
    }

    public static class InitTimeDescComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object obj1, Object obj2) {
            long time2;
            if (obj1 == obj2) {
                return 0;
            }
            Map map1 = (Map)obj1;
            Map map2 = (Map)obj2;
            long time1 = Long.parseLong((String)map1.get(BaseInitializable.PROP_INIT_TIME));
            if (time1 < (time2 = Long.parseLong((String)map2.get(BaseInitializable.PROP_INIT_TIME)))) {
                return 1;
            }
            if (time1 > time2) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }
    }
}

