/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.initialization;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.vjet.dsf.common.initialization.Initializable;
import org.eclipse.vjet.dsf.common.initialization.InitializationContext;
import org.eclipse.vjet.dsf.common.initialization.InitializationState;
import org.eclipse.vjet.dsf.common.initialization.ShutdownRuntimeException;

public class InitializationHelper {
    private final List<Initializable> m_initializables = new ArrayList<Initializable>();
    private int m_highestInitIndex = 0;
    private InitializationState m_state = InitializationState.PRISTINE;
    private List<Initializable> m_notifyUponInitDoneList;

    public synchronized void add(Initializable initializable) {
        this.m_initializables.add(initializable);
    }

    public InitializationState getState() {
        return this.m_state;
    }

    public synchronized void initialize(InitializationContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.m_state == InitializationState.INITAILIZED) {
            return;
        }
        boolean isSuccess = false;
        try {
            int initIndex = 0;
            Initializable.CharacteristicEnum characteristic = context.getCharacteristic();
            boolean initWithCharacteristic = this.hasCharacteristic(context);
            for (Initializable o : this.m_initializables) {
                if (initWithCharacteristic && !o.getCharacteristics().contains(characteristic)) continue;
                if (++initIndex > this.m_highestInitIndex) {
                    this.m_highestInitIndex = initIndex;
                }
                o.doInitialize(context);
                if (!o.isNotifyUponInitDone()) continue;
                this.addToNotifyUponInitDoneList(o);
            }
            this.m_state = initWithCharacteristic ? InitializationState.INITIALIZED_CHARACTERISTIC : InitializationState.INITAILIZED;
            isSuccess = true;
        }
        finally {
            if (!isSuccess) {
                this.m_state = InitializationState.INITAILIZED_FAILED;
            }
        }
    }

    private synchronized void addToNotifyUponInitDoneList(Initializable initializable) {
        if (this.m_notifyUponInitDoneList == null) {
            this.m_notifyUponInitDoneList = new ArrayList<Initializable>();
        }
        this.m_notifyUponInitDoneList.add(initializable);
    }

    private boolean hasCharacteristic(InitializationContext context) {
        Initializable.CharacteristicEnum characteristic = context.getCharacteristic();
        return characteristic != null && characteristic != Initializable.CharacteristicEnum.NONE;
    }

    public synchronized void shutdown(InitializationContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        try {
            ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
            ListIterator<Initializable> iter = this.m_initializables.listIterator(this.m_highestInitIndex);
            while (iter.hasPrevious()) {
                Initializable o = iter.previous();
                try {
                    o.doShutdown(context);
                }
                catch (RuntimeException e) {
                    exceptions.add(e);
                }
                --this.m_highestInitIndex;
            }
            if (exceptions.size() > 0) {
                throw new ShutdownRuntimeException(exceptions);
            }
            this.m_state = InitializationState.SHUTDOWN;
        }
        finally {
            if (this.m_state != InitializationState.SHUTDOWN) {
                this.m_state = InitializationState.SHUTDOWN_FAILED;
            }
        }
    }

    public synchronized void notifyInitDone() {
        if (this.m_notifyUponInitDoneList != null) {
            for (Initializable o : this.m_notifyUponInitDoneList) {
                o.notifyInitDone();
            }
        }
    }

    public synchronized boolean isNotifyUponInitDone() {
        return this.m_notifyUponInitDoneList != null;
    }

    protected Initializable[] getInitializables() {
        return this.m_initializables.toArray(new Initializable[0]);
    }
}

