/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.vjet.dsf.common.resource.Resolver;

public class DefaultResolver
implements Resolver {
    private String makeResourcePath(String relDir, String resourceName) {
        int len = relDir.length() + 1 + resourceName.length();
        StringBuilder buf = new StringBuilder(len);
        buf.append(relDir);
        buf.append('/');
        buf.append(resourceName);
        return buf.toString().replace('\\', '/');
    }

    private String checkPath(String path) {
        boolean startFlag = path.startsWith(File.separator);
        boolean endFlag = path.endsWith(File.separator);
        if (!startFlag && !endFlag) {
            return path;
        }
        int startOff = 0;
        int endOff = path.length();
        if (startFlag) {
            startOff = 1;
        }
        if (endFlag) {
            --endOff;
        }
        return path.substring(startOff, endOff);
    }

    @Override
    public InputStream getResourceAsStream(String relDir, String resourceName) throws IOException {
        String pathDir = this.checkPath(relDir);
        String path = this.makeResourcePath(pathDir, resourceName);
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    @Override
    public InputStream getResourceAsStream(Class sourceClass, String resourceName) throws IOException {
        return sourceClass.getResourceAsStream(resourceName);
    }

    @Override
    public URL getResource(String relDir, String resourceName) throws IOException {
        String pathDir = this.checkPath(relDir);
        String path = this.makeResourcePath(pathDir, resourceName);
        return this.getClass().getClassLoader().getResource(path);
    }

    @Override
    public URL getResource(Class sourceClass, String resourceName) throws IOException {
        return sourceClass.getResource(resourceName);
    }

    public String toString() {
        return "DefaultResolver";
    }
}

