/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.filter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.config.FilterKey;
import org.eclipse.vjet.dsf.common.trace.event.TraceEvent;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.common.trace.filter.FilterId;
import org.eclipse.vjet.dsf.common.trace.filter.ITraceEventFilter;

public class TraceIdFilter
implements ITraceEventFilter {
    private FilterKey m_filterKey;
    private Mode m_mode = Mode.ALL;
    private List<TraceId> m_ids = new ArrayList<TraceId>(2);

    public TraceIdFilter(FilterId id) {
        if (id == null) {
            DsfExceptionHelper.chuck("id is null");
        }
        this.m_filterKey = new FilterKey(this.getClass(), id);
    }

    public TraceIdFilter(FilterId id, Mode mode) {
        this(id);
        if (mode != null) {
            this.m_mode = mode;
        }
    }

    @Override
    public FilterId getId() {
        return this.m_filterKey.getId();
    }

    @Override
    public boolean isInterested(TraceEvent event) {
        if (event == null) {
            return false;
        }
        if (this.m_mode == Mode.ALL) {
            return true;
        }
        if (this.m_mode == Mode.INCLUDE) {
            return this.m_ids.contains(event.getId());
        }
        return !this.m_ids.contains(event.getId());
    }

    public Mode getMode() {
        return this.m_mode;
    }

    public static enum Mode {
        ALL,
        INCLUDE,
        EXCLUDE;

    }
}

