/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.xml;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamException;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriterOptions;

public class XmlStreamWriterF
implements IXmlStreamWriter {
    protected static final String AMP_ESCAPE_CHARS = "&amp;";
    protected static final String LT_ESCAPE_CHARS = "&lt;";
    protected static final String GT_ESCAPE_CHARS = "&gt;";
    protected static final String QUOT_ESCAPE_CHARS = "&quot;";
    protected static final String SINGLE_SPACE_CHARS = " ";
    protected static final String DOUBLE_QUOTE_CHARS = "\"";
    protected static final String EQUALS_SIGN_DOUBLE_QUOTE_CHARS = "=\"";
    protected static final String CDATA_END_CHARS = "]]>";
    protected static final String CDATA_START_CHARS = "<![CDATA[";
    protected static final String COMMENT_END_CHARS = "-->";
    protected static final String COMMENT_START_CHARS = "<!--";
    protected static final String SINGLE_LT_CHARS = "<";
    protected static final String SINGLE_GT_CHARS = ">";
    protected static final String LT_SLASH_CHARS = "</";
    protected static final String SLASH_CHARS = "/";
    protected final ArrayList<String> m_tagStack = new ArrayList(20);
    protected final XmlStreamWriterOptions m_options;
    protected boolean m_inStartTag = false;

    public XmlStreamWriterF() {
        this(new XmlStreamWriterOptions());
    }

    public XmlStreamWriterF(XmlStreamWriterOptions options) {
        if (options == null) {
            throw new RuntimeException("Options can not be null");
        }
        this.m_options = options;
    }

    public boolean isEscapingEnabled() {
        return this.m_options.isEscapeEnabled();
    }

    public void setEscapingEnabled(boolean escapingEnabled) {
        this.m_options.setEscapeEnabled(escapingEnabled);
    }

    public XmlStreamWriterOptions getOptions() {
        return this.m_options;
    }

    @Override
    public void writeAttribute(char[] key, String value) throws XmlStreamException {
        try {
            this.m_options.getWriter().write(SINGLE_SPACE_CHARS);
            this.m_options.getWriter().write(key);
            this.m_options.getWriter().write(EQUALS_SIGN_DOUBLE_QUOTE_CHARS);
            this.handleValueSubset(value, 0, value.length(), true);
            this.m_options.getWriter().write(DOUBLE_QUOTE_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeAttribute(String key, String value) throws XmlStreamException {
        try {
            this.m_options.getWriter().write(SINGLE_SPACE_CHARS);
            this.m_options.getWriter().write(key);
            this.m_options.getWriter().write(EQUALS_SIGN_DOUBLE_QUOTE_CHARS);
            this.handleValueSubset(value, 0, value.length(), true);
            this.m_options.getWriter().write(DOUBLE_QUOTE_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    private void handleEscapedValue(String value, int offset, int count, String alreadyEscapedValue, int remainingCount, boolean escapeQuotes) throws IOException {
        this.m_options.getWriter().write(value, offset, count);
        this.m_options.getWriter().write(alreadyEscapedValue);
        this.handleValueSubset(value, offset + count + 1, remainingCount - count - 1, escapeQuotes);
    }

    private void handleValueSubset(String value, int offset, int count, boolean escapeQuotes) throws IOException {
        if (!this.isEscapingEnabled()) {
            this.m_options.getWriter().write(value, offset, count);
            return;
        }
        if (offset >= value.length()) {
            return;
        }
        int size = offset + count;
        int okCharCount = 0;
        int i = offset;
        while (i < size) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    this.handleEscapedValue(value, offset, okCharCount, AMP_ESCAPE_CHARS, count, escapeQuotes);
                    return;
                }
                case '<': {
                    this.handleEscapedValue(value, offset, okCharCount, LT_ESCAPE_CHARS, count, escapeQuotes);
                    return;
                }
                case '>': {
                    this.handleEscapedValue(value, offset, okCharCount, GT_ESCAPE_CHARS, count, escapeQuotes);
                    return;
                }
                case '\"': {
                    if (!escapeQuotes) break;
                    this.handleEscapedValue(value, offset, okCharCount, QUOT_ESCAPE_CHARS, count, escapeQuotes);
                    return;
                }
            }
            ++okCharCount;
            ++i;
        }
        this.m_options.getWriter().write(value, offset, count);
    }

    @Override
    public void writeCData(String data) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_options.getWriter().write(CDATA_START_CHARS);
            this.m_options.getWriter().write(data);
            this.m_options.getWriter().write(CDATA_END_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeRaw(String data) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_options.getWriter().write(data);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeCharacters(final char[] text, final int start, final int len) throws XmlStreamException {
        CharSequence sequence = new CharSequence(){

            @Override
            public char charAt(int index) {
                return text[start + index];
            }

            @Override
            public int length() {
                return len;
            }

            @Override
            public CharSequence subSequence(int begin, int end) {
                throw new RuntimeException("not implemented");
            }
        };
        this.writeEscapedForElementBlock(sequence);
    }

    @Override
    public void writeCharacters(String text) throws XmlStreamException {
        this.closeStartTagIfNecessary();
        try {
            boolean escapeQuotes = false;
            this.handleValueSubset(text, 0, text.length(), escapeQuotes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeEscapedForElementBlock(CharSequence sequence) {
        try {
            this.closeStartTagIfNecessary();
            int sequenceLength = sequence.length();
            int i = 0;
            while (i < sequenceLength) {
                char c = sequence.charAt(i);
                switch (c) {
                    case '&': {
                        this.m_options.getWriter().write(AMP_ESCAPE_CHARS);
                        break;
                    }
                    case '<': {
                        this.m_options.getWriter().write(LT_ESCAPE_CHARS);
                        break;
                    }
                    case '>': {
                        this.m_options.getWriter().write(GT_ESCAPE_CHARS);
                        break;
                    }
                    default: {
                        this.m_options.getWriter().write(c);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeComment(String data) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_options.getWriter().write(COMMENT_START_CHARS);
            this.m_options.getWriter().write(data);
            this.m_options.getWriter().write(COMMENT_END_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeDtd(String dtd) {
        this.writeRaw(dtd);
        if (!dtd.endsWith("\n")) {
            this.writeRaw("\r\n");
        }
    }

    @Override
    public void writeEmptyElement(String tagName) throws XmlStreamException {
        throw new RuntimeException("not implemented!");
    }

    @Override
    public void writeEndDocument() throws XmlStreamException {
        while (this.m_tagStack.size() > 0) {
            this.writeEndElement();
        }
        try {
            this.m_options.getWriter().flush();
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeStartDocument() throws XmlStreamException {
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XmlStreamException {
    }

    @Override
    public void writeStartDocument(String version) throws XmlStreamException {
    }

    @Override
    public void writeEndElement() throws XmlStreamException {
        String tagName = this.m_tagStack.remove(this.m_tagStack.size() - 1);
        try {
            if (this.m_inStartTag) {
                this.m_options.getWriter().write(SLASH_CHARS);
                this.writeClosingStartTag();
            } else {
                this.m_options.getIndenter().indent(this.m_options.getWriter(), this.m_tagStack.size());
                this.m_options.getWriter().write(LT_SLASH_CHARS);
                this.m_options.getWriter().write(tagName);
                this.m_options.getWriter().write(SINGLE_GT_CHARS);
            }
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    @Override
    public void writeStartElement(char[] tagNameAsChars) throws XmlStreamException {
        this.writeStartElement(new String(tagNameAsChars));
    }

    @Override
    public void writeStartElement(String tagName) throws XmlStreamException {
        try {
            this.closeStartTagIfNecessary();
            this.m_options.getIndenter().indent(this.m_options.getWriter(), this.m_tagStack.size());
            this.m_options.getWriter().write(SINGLE_LT_CHARS);
            this.m_options.getWriter().write(tagName);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
        this.m_tagStack.add(tagName);
        this.m_inStartTag = true;
    }

    protected void closeStartTagIfNecessary() throws XmlStreamException {
        if (this.m_inStartTag) {
            this.writeClosingStartTag();
        }
    }

    private void writeClosingStartTag() {
        try {
            this.m_options.getWriter().write(SINGLE_GT_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
        this.m_inStartTag = false;
    }

    @Override
    public void flush() throws XmlStreamException {
        try {
            this.m_options.getWriter().flush();
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }

    protected String getCurrentTagName() {
        return this.m_tagStack.get(this.m_tagStack.size() - 1);
    }

    @Override
    public void writeRawCharacters(char[] text, int start, int len) {
        try {
            this.closeStartTagIfNecessary();
            this.m_options.getWriter().write(text, start, len);
        }
        catch (IOException e) {
            throw new XmlStreamException(e);
        }
    }
}

