/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;

public class VjoCcDerivedPropMethodAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcDerivedPropMethodAdvisor.class.getName();

    @Override
    public void advise(VjoCcCtx ctx) {
        String token = ctx.getActingToken();
        IJstType callingType = ctx.getActingType();
        IJstType calledType = ctx.getCalledType();
        if (calledType == null && callingType == null) {
            return;
        }
        if (calledType == null) {
            calledType = callingType;
        }
        boolean isNative = CodeCompletionUtils.isNativeType(calledType);
        IJstType tempCalledType = calledType;
        int[] levels = this.getCallLevel(callingType, calledType);
        ArrayList<String> tempString = new ArrayList<String>();
        ArrayList methods = new ArrayList();
        List derivedTypes = calledType.getAllDerivedTypes();
        for (IJstType t : derivedTypes) {
            methods.addAll(JstTypeHelper.getSignatureMethods((IJstType)t, (boolean)false, (boolean)false));
        }
        for (IJstMethod method : methods) {
            boolean exactMatch;
            if (!this.isReferenceByDot(method)) continue;
            if (tempCalledType != method.getOwnerType()) {
                tempCalledType = method.getOwnerType();
                if (tempCalledType == null) {
                    tempCalledType = calledType;
                }
                levels = this.getCallLevel(callingType, tempCalledType);
                isNative = CodeCompletionUtils.isNativeType(tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(method.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(method.getName().getName(), token);
            }
            if (!exactMatch && !basicMatch) continue;
            this.addMethod(method, levels, isNative, ctx, tempString, exactMatch);
        }
        ArrayList properties = new ArrayList();
        for (IJstType t : derivedTypes) {
            properties.addAll(t.getAllPossibleProperties(false, false));
        }
        for (IJstProperty property : properties) {
            boolean exactMatch;
            if (tempCalledType != property.getOwnerType()) {
                tempCalledType = property.getOwnerType();
                levels = this.getCallLevel(callingType, tempCalledType);
                isNative = CodeCompletionUtils.isNativeType(tempCalledType);
            }
            boolean basicMatch = exactMatch = this.exactMatch(property.getName().getName(), token);
            if (!exactMatch) {
                basicMatch = this.basicMatch(property.getName().getName(), token);
            }
            if (!this.levelCheck(property.getModifiers(), levels) || !exactMatch && !basicMatch) continue;
            this.appendData(ctx, (IJstNode)property, exactMatch && basicMatch);
        }
    }

    private boolean isReferenceByDot(IJstMethod method) {
        if (method.getName() != null) {
            if (method.getName().getName().startsWith("'")) {
                return false;
            }
            if (method.getName().getName().startsWith("\"")) {
                return false;
            }
        }
        return true;
    }

    private void addMethod(IJstMethod method, int[] levels, boolean isNative, VjoCcCtx ctx, List<String> tempString, boolean exactMatch) {
        String str;
        if (!(method.isConstructor() || !this.levelCheck(method.getModifiers(), levels) || isNative && method.getName().getName().startsWith("_") || tempString.contains(str = CodeCompletionUtils.getMthodsStr(method)))) {
            tempString.add(str);
            this.appendData(ctx, (IJstNode)method, exactMatch);
        }
    }

    @Override
    protected int[] getCallLevel(IJstType callingType, IJstType calledType) {
        return CodeCompletionUtils.getGeneralFieldCallLevel(callingType, calledType);
    }
}

