/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenInputEntity;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenOutputEntity;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenOutputType;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGenStatus;
import org.eclipse.vjet.core.codegen.bootstrap.CodeGeneratorMarker;
import org.eclipse.vjet.core.codegen.bootstrap.ICodeGeneratorInput;
import org.eclipse.vjet.core.codegen.bootstrap.ICodeGeneratorMarker;
import org.eclipse.vjet.core.codegen.bootstrap.IJs2JavaCodeGenInput;
import org.eclipse.vjet.core.codegen.bootstrap.IJs2JavaCodeGenOutput;
import org.eclipse.vjet.core.codegen.bootstrap.IJs2JavaCodeGenTool;
import org.eclipse.vjet.core.codegen.bootstrap.IToolMonitor;
import org.eclipse.vjet.core.codegen.bootstrap.Js2JavaCodeGenInput;
import org.eclipse.vjet.core.codegen.bootstrap.Js2JavaCodeGenOutput;
import org.eclipse.vjet.core.codegen.bootstrap.StatusCode;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.translate.config.CodeGenConfig;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrTypeProvider;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrTypeProvider;
import org.eclipse.vjet.dsf.jsgen.shared.generate.NativeJsProxyGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.util.CodeGenCleaner;
import org.eclipse.vjet.dsf.jst.FileBinding;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.controller.BuildController;
import org.eclipse.vjet.dsf.jstojava.controller.NativeJsLibProvider;
import org.eclipse.vjet.dsf.jstojava.exception.DsfJs2JavaException;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateConfig;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.eclipse.javatojs.core.PluginCodeGenHelper;

public class JsCodeGenTool
implements IJs2JavaCodeGenTool {
    private static boolean m_init;
    static final String VALID_FILE_EXTENSION = "js";

    public List<CodeGenStatus> generate(CodeGenInputEntity inputEntity, List<CodeGenOutputEntity> outputCollection) {
        ArrayList<CodeGenStatus> returnStatusCollection = new ArrayList<CodeGenStatus>(outputCollection.size());
        ArrayList packageCollection = new ArrayList(outputCollection.size());
        for (CodeGenOutputEntity outputEntity : outputCollection) {
            try {
                URL inputURL = (URL)inputEntity.getData();
                File inputFile = new File(inputURL.getFile());
                URL outputURL = (URL)outputEntity.getData();
                File outputFile = new File(outputURL.getFile());
                if (CodeGenCleaner.isCodeGened((File)inputFile, (boolean)false)) {
                    CodeGenStatus status = new CodeGenStatus(StatusCode.Error);
                    status.setMessage("Can not code generate a codegen'd JS file.");
                    status.setLineNumber(1);
                    returnStatusCollection.add(status);
                    return returnStatusCollection;
                }
                JsCodeGenTool.generateVjo3Jsr(inputFile, (Writer)outputEntity.getOutputStream(), outputFile.getParentFile());
                outputEntity.getOutputStream().flush();
                returnStatusCollection.add(new CodeGenStatus(StatusCode.Success));
            }
            catch (Exception e) {
                CodeGenStatus status = new CodeGenStatus(StatusCode.Error);
                status.setMessage(e.getMessage());
                status.setLineNumber(1);
                status.setThrowable((Throwable)e);
                returnStatusCollection.add(status);
            }
        }
        for (CodeGenOutputEntity pkg : packageCollection) {
            outputCollection.add(pkg);
        }
        return returnStatusCollection;
    }

    public List<CodeGenStatus> validate(CodeGenInputEntity inputEntity) {
        ArrayList<CodeGenStatus> status = new ArrayList<CodeGenStatus>();
        return status;
    }

    public List<CodeGenOutputEntity> getOutputEntities(CodeGenInputEntity inputEntity) {
        String extension;
        URL url = (URL)inputEntity.getData();
        String name = url.toExternalForm();
        int separator = name.lastIndexOf(46);
        if (separator > 0 && (extension = name.substring(separator + 1, name.length()).toLowerCase()).equals(VALID_FILE_EXTENSION)) {
            String outputFileName = name.substring(0, separator);
            CodeGenOutputEntity output = new CodeGenOutputEntity();
            String javaFileName = String.valueOf(outputFileName.substring(0, 1).toUpperCase()) + outputFileName.substring(1);
            String simpleJavaFileName = null;
            int hasForwardSlash = javaFileName.lastIndexOf("/");
            int hasBackSlash = javaFileName.lastIndexOf("\\");
            if (hasForwardSlash > -1) {
                simpleJavaFileName = javaFileName.substring(hasForwardSlash + 1);
            }
            if (hasBackSlash > -1) {
                simpleJavaFileName = javaFileName.substring(hasBackSlash + 1);
            }
            output.setName(String.valueOf(simpleJavaFileName) + "Jsr.java");
            try {
                output.setData((Object)new URL(String.valueOf(javaFileName) + "Jsr.java"));
            }
            catch (MalformedURLException e) {
                throw new DsfJs2JavaException("url not valid", (Throwable)e);
            }
            output.setType(CodeGenOutputType.JavaScript);
            ArrayList<CodeGenOutputEntity> outputEntities = new ArrayList<CodeGenOutputEntity>();
            outputEntities.add(output);
            return outputEntities;
        }
        throw new IllegalArgumentException("Unknown input file type: " + name);
    }

    public CodeGenStatus getResourceText(String className, OutputStreamWriter outputStream, Locale locale) {
        throw new UnsupportedOperationException();
    }

    public static IJstType generateVjo3Jsr(File inputFile, Writer jsrWriter, File outputParentDir) throws IOException {
        JstType type = JsCodeGenTool.getJstTypeFromFile(inputFile);
        return JsCodeGenTool.generateVjo3Jsr((IJstType)type, jsrWriter, outputParentDir);
    }

    private static JstType getJstTypeFromFile(File inputFile) {
        if (!m_init) {
            new NativeJsLibProvider();
        }
        String ONDEMAND = "ONDEMAND";
        TranslateConfig cfg = new TranslateConfig();
        cfg.setSkiptImplementation(true);
        VjoParser p = new VjoParser(cfg);
        JstType t = (JstType)p.parse(ONDEMAND, inputFile);
        BuildController c = new BuildController();
        JstTypeSpaceMgr mgr = c.loadType(ONDEMAND, (IJstType)t);
        JstType type = (JstType)mgr.getQueryExecutor().findType(new TypeName(ONDEMAND, t.getName()));
        return type;
    }

    private static IJstType generateVjo3Jsr(IJstType jstType, Writer jsrWriter, File outputParentDir) throws IOException {
        OutputStreamWriter writerForNativeJsProxy = null;
        File nativeJsProxyFile = null;
        if (!JsCodeGenTool.skipProxyGen(jstType)) {
            nativeJsProxyFile = new File(outputParentDir, String.valueOf(jstType.getSimpleName()) + ".java");
            if (!nativeJsProxyFile.exists()) {
                nativeJsProxyFile.createNewFile();
            }
            if (nativeJsProxyFile.canWrite()) {
                writerForNativeJsProxy = new FileWriter(nativeJsProxyFile);
            }
        }
        JsCodeGenTool.genJsr(jstType, jsrWriter, CodeStyle.PRETTY);
        if (writerForNativeJsProxy != null) {
            new NativeJsProxyGenerator(new PrintWriter(writerForNativeJsProxy), CodeStyle.PRETTY).writeProxy(jstType);
            writerForNativeJsProxy.flush();
            writerForNativeJsProxy.close();
            System.out.println("Proxy class generated: " + nativeJsProxyFile.getAbsolutePath());
        }
        return jstType;
    }

    public static void genJsr(IJstType type, Writer writer, CodeStyle style) {
        JsrGenerator generator = new JsrGenerator(new PrintWriter(writer), style);
        JsrTypeProvider jsrTypeProvider = new JsrTypeProvider();
        jsrTypeProvider.setEnableTypeMapping(false);
        generator.setJsToJavaMapper((IJsrTypeProvider)jsrTypeProvider);
        generator.writeJsr(type);
    }

    private static boolean skipProxyGen(IJstType jstType) {
        if (jstType.getName().startsWith("org.eclipse.vjet.vjo.java.")) {
            return true;
        }
        if (jstType.isInterface() || jstType.isEnum()) {
            return false;
        }
        if (jstType.isClass() || jstType.isOType()) {
            String typeName = jstType.getSimpleName();
            return "Object".equals(typeName) || "Class".equals(typeName);
        }
        return true;
    }

    public List<IJs2JavaCodeGenOutput> generate(List<IJs2JavaCodeGenInput> input, IToolMonitor monitor) {
        monitor.beginTask("Js 2 Java code generation", input.size());
        ArrayList<IJs2JavaCodeGenOutput> output = new ArrayList<IJs2JavaCodeGenOutput>();
        for (IJs2JavaCodeGenInput codeGenInput : input) {
            this.generate(codeGenInput, monitor, output);
        }
        monitor.done();
        return output;
    }

    private void generate(IJs2JavaCodeGenInput input, IToolMonitor monitor, List<IJs2JavaCodeGenOutput> output) {
        URL inputURL;
        if (input != null && input.getJavaSourcePath() != null) {
            System.setProperty("java.source.path", input.getJavaSourcePath());
            JavaSourceLocator.getInstance().reset();
        }
        if ((inputURL = input.getUrl()) == null) {
            throw new RuntimeException("IJava2JsCodeGenInput.getUrl() is null");
        }
        if (!inputURL.toExternalForm().endsWith(".js")) {
            return;
        }
        Properties configProp = input.getJava2JsProperties();
        if (configProp == null) {
            throw new RuntimeException("IJava2JsCodeGenInput.getJava2JsProperties() is null");
        }
        CodeGenConfig config = new CodeGenConfig(configProp);
        PluginCodeGenHelper helper = new PluginCodeGenHelper(config, monitor);
        ArrayList<JstType> jstTypes = new ArrayList<JstType>();
        jstTypes.add(JsCodeGenTool.getJstTypeFromFile(new File(inputURL.getFile())));
        List<IJs2JavaCodeGenInput> inputs = null;
        try {
            inputs = this.write(jstTypes, helper, output);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (!helper.getAllErrors().isEmpty()) {
            output.addAll(this.processErrors(inputs, helper.getAllErrors()));
        }
    }

    private Collection<? extends IJs2JavaCodeGenOutput> processErrors(List<IJs2JavaCodeGenInput> inputs, List<TranslateError> allErrors) {
        ArrayList<Js2JavaCodeGenOutput> outputs = new ArrayList<Js2JavaCodeGenOutput>();
        for (TranslateError error : allErrors) {
            IJs2JavaCodeGenInput input;
            if (error.getSrcName() == null || (input = this.findInput(error, inputs)) == null) continue;
            Js2JavaCodeGenOutput out = new Js2JavaCodeGenOutput();
            out.setInput((ICodeGeneratorInput)input);
            out.setUrl(input.getUrl());
            this.setMarkers(out.getMarkers(), error);
            outputs.add(out);
        }
        return outputs;
    }

    private void setMarkers(List<ICodeGeneratorMarker> markers, TranslateError error) {
        CodeGeneratorMarker status = new CodeGeneratorMarker();
        if (error.getLevel().equals((Object)LogLevel.ERROR)) {
            status.setStatus(StatusCode.Error);
        } else if (error.getLevel().equals((Object)LogLevel.WARN)) {
            status.setStatus(StatusCode.Warning);
        } else if (error.getLevel().equals((Object)LogLevel.FATAL)) {
            status.setStatus(StatusCode.FatalError);
        } else {
            return;
        }
        status.setMessage(error.getMsg());
        int line = (int)(error.getSrcLineNo() == 0L ? 1L : error.getSrcLineNo());
        status.setLineNumber(line);
        markers.add((ICodeGeneratorMarker)status);
    }

    private IJs2JavaCodeGenInput findInput(TranslateError error, List<IJs2JavaCodeGenInput> inputs) {
        for (IJs2JavaCodeGenInput input : inputs) {
            String source = String.valueOf(error.getSrcName().replace('.', '/')) + "/.js";
            String url = input.getUrl().toExternalForm();
            if (!url.endsWith(source)) continue;
            return input;
        }
        return null;
    }

    private List<IJs2JavaCodeGenInput> write(List<JstType> jstTypes, PluginCodeGenHelper helper, List<IJs2JavaCodeGenOutput> output) throws MalformedURLException {
        ArrayList<IJs2JavaCodeGenInput> inputs = new ArrayList<IJs2JavaCodeGenInput>();
        for (JstType jst : jstTypes) {
            File file = ((FileBinding)jst.getSource().getBinding()).getFile();
            URL inputUrl = file.toURL();
            Js2JavaCodeGenInput input = new Js2JavaCodeGenInput();
            input.setUrl(inputUrl);
            inputs.add((IJs2JavaCodeGenInput)input);
            OutputStreamWriter writerForNativeJsProxy = null;
            File nativeJsProxyFile = null;
            if (!JsCodeGenTool.skipProxyGen((IJstType)jst)) {
                nativeJsProxyFile = new File(file.getParentFile(), String.valueOf(jst.getSimpleName()) + ".java");
                if (!nativeJsProxyFile.exists()) {
                    try {
                        nativeJsProxyFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (nativeJsProxyFile.canWrite()) {
                    try {
                        writerForNativeJsProxy = new FileWriter(nativeJsProxyFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            new NativeJsProxyGenerator(new PrintWriter(writerForNativeJsProxy), CodeStyle.PRETTY).writeProxy((IJstType)jst);
            try {
                writerForNativeJsProxy.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Js2JavaCodeGenOutput proxy = new Js2JavaCodeGenOutput();
            proxy.setUrl(nativeJsProxyFile.toURL());
            proxy.setInput((ICodeGeneratorInput)input);
            output.add((IJs2JavaCodeGenOutput)proxy);
            System.out.println("Proxy class generated: " + nativeJsProxyFile.getAbsolutePath());
            if (!helper.getConfig().shouldGenJsr()) continue;
            URL jsrFilePath = new File(file.getParentFile(), String.valueOf(jst.getSimpleName()) + "Jsr.java").toURL();
            FileWriter writerForJsr = null;
            try {
                writerForJsr = new FileWriter(new File(jsrFilePath.getFile()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            JsCodeGenTool.genJsr((IJstType)jst, writerForJsr, CodeStyle.PRETTY);
            try {
                writerForJsr.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Js2JavaCodeGenOutput out = new Js2JavaCodeGenOutput();
            out.setUrl(jsrFilePath);
            out.setInput((ICodeGeneratorInput)input);
            output.add((IJs2JavaCodeGenOutput)out);
        }
        return inputs;
    }
}

